/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.ClearScrollRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchScrollRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.storage.elasticsearch7.AutoValue_ScrollResultES7_ScrollChunkES7;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollResultES7
extends IndexQueryResult
implements ScrollResult {
    private static final Logger LOG = LoggerFactory.getLogger(ScrollResult.class);
    private static final TimeValue DEFAULT_SCROLL = TimeValue.timeValueMinutes(1L);
    private final ElasticsearchClient client;
    private final long totalHits;
    private final int limit;
    private final String scroll;
    private final List<String> fields;
    private final String queryHash;
    private String scrollId;
    private SearchResponse initialResult;
    private int chunkId = 0;
    private int resultCount = 0;

    @AssistedInject
    public ScrollResultES7(ElasticsearchClient client, @Assisted SearchResponse initialResult, @Assisted(value="query") String query, @Assisted(value="scroll") String scroll, @Assisted List<String> fields, @Assisted int limit) {
        super(query, null, initialResult.getTook().getMillis());
        this.client = client;
        this.totalHits = initialResult.getHits().getTotalHits().value;
        Preconditions.checkArgument((initialResult.getScrollId() != null ? 1 : 0) != 0, (Object)"Unable to extract scroll id from supplied search result!");
        this.limit = limit;
        this.scrollId = initialResult.getScrollId();
        this.initialResult = initialResult;
        this.scroll = scroll;
        this.fields = fields;
        Md5Hash md5Hash = new Md5Hash((Object)this.getOriginalQuery());
        this.queryHash = md5Hash.toHex();
        LOG.debug("[{}] Starting scroll request for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
    }

    public ScrollResult.ScrollChunk nextChunk() throws IOException {
        if (this.limit != -1 && this.resultCount >= this.limit) {
            LOG.debug("[{}] Reached limit for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
            return null;
        }
        SearchResponse result = this.initialResult != null ? this.initialResult : this.nextSearchResult();
        this.initialResult = null;
        List<ResultMessage> resultMessages = Streams.stream((Iterable)result.getHits()).map(hit -> ResultMessage.parseFromSource((String)hit.getId(), (String)hit.getIndex(), hit.getSourceAsMap())).collect(Collectors.toList());
        if (resultMessages.size() == 0) {
            LOG.debug("[{}] Reached end of scroll results for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
            return null;
        }
        int remainingResultsForLimit = this.limit - this.resultCount;
        List<ResultMessage> resultMessagesSlice = this.limit != -1 && remainingResultsForLimit < resultMessages.size() ? resultMessages.subList(0, remainingResultsForLimit) : resultMessages;
        this.resultCount += resultMessagesSlice.size();
        this.scrollId = result.getScrollId();
        return ScrollChunkES7.create(this.fields, this.chunkId++, resultMessagesSlice);
    }

    private SearchResponse nextSearchResult() throws IOException {
        SearchScrollRequest scrollRequest = new SearchScrollRequest(this.scrollId);
        scrollRequest.scroll(TimeValue.parseTimeValue(this.scroll, DEFAULT_SCROLL, "scroll time"));
        return this.client.executeWithIOException((c, requestOptions) -> c.scroll(scrollRequest, (RequestOptions)requestOptions), "Unable to retrieve next chunk from search: ");
    }

    public String getQueryHash() {
        return this.queryHash;
    }

    public long totalHits() {
        return this.totalHits;
    }

    public void cancel() throws IOException {
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(this.scrollId);
        this.client.executeWithIOException((c, requestOptions) -> c.clearScroll(request, (RequestOptions)requestOptions), "Unable to cancel scrolling search request");
    }

    @AutoValue
    static abstract class ScrollChunkES7
    implements ScrollResult.ScrollChunk {
        ScrollChunkES7() {
        }

        public abstract List<String> getFields();

        public abstract int getChunkNumber();

        public abstract List<ResultMessage> getMessages();

        static ScrollResult.ScrollChunk create(List<String> fields, int chunkNumber, List<ResultMessage> messages) {
            return new AutoValue_ScrollResultES7_ScrollChunkES7(fields, chunkNumber, messages);
        }
    }

    public static interface Factory {
        public ScrollResultES7 create(SearchResponse var1, @Assisted(value="query") String var2, @Assisted(value="scroll") String var3, List<String> var4, int var5);
    }
}

