/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.export;

import com.google.inject.name.Named;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.SimpleMessage;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.TermsQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;
import org.graylog.storage.elasticsearch7.TimeRangeQueryFactory;
import org.graylog.storage.elasticsearch7.views.export.RequestStrategy;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchExportBackend
implements ExportBackend {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchExportBackend.class);
    private final IndexLookup indexLookup;
    private final RequestStrategy requestStrategy;
    private final boolean allowLeadingWildcard;

    @Inject
    public ElasticsearchExportBackend(IndexLookup indexLookup, RequestStrategy requestStrategy, @Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard) {
        this.indexLookup = indexLookup;
        this.requestStrategy = requestStrategy;
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    public void run(ExportMessagesCommand command, Consumer<SimpleMessageChunk> chunkCollector) {
        boolean isFirstChunk = true;
        int totalCount = 0;
        while (true) {
            List<SearchHit> hits;
            if ((hits = this.search(command)).isEmpty()) {
                this.publishChunk(chunkCollector, hits, command.fieldsInOrder(), SimpleMessageChunk.ChunkOrder.LAST);
                return;
            }
            boolean success = this.publishChunk(chunkCollector, hits, command.fieldsInOrder(), isFirstChunk ? SimpleMessageChunk.ChunkOrder.FIRST : SimpleMessageChunk.ChunkOrder.INTERMEDIATE);
            if (!success) {
                return;
            }
            if (command.limit().isPresent() && (totalCount += hits.size()) >= command.limit().getAsInt()) {
                LOG.info("Limit of {} reached. Stopping message retrieval.", (Object)command.limit().getAsInt());
                this.publishChunk(chunkCollector, Collections.emptyList(), command.fieldsInOrder(), SimpleMessageChunk.ChunkOrder.LAST);
                return;
            }
            isFirstChunk = false;
        }
    }

    private List<SearchHit> search(ExportMessagesCommand command) {
        SearchRequest search = this.prepareSearchRequest(command);
        return this.requestStrategy.nextChunk(search, command);
    }

    private SearchRequest prepareSearchRequest(ExportMessagesCommand command) {
        SearchSourceBuilder ssb = this.searchSourceBuilderFrom(command);
        Set<String> indices = this.indicesFor(command);
        return new SearchRequest().source(ssb).indices(indices.toArray(new String[0])).indicesOptions(IndicesOptions.fromOptions(false, false, true, false));
    }

    private SearchSourceBuilder searchSourceBuilderFrom(ExportMessagesCommand command) {
        QueryBuilder query = this.queryFrom(command);
        SearchSourceBuilder ssb = new SearchSourceBuilder().query(query).size(command.chunkSize()).sort("timestamp", SortOrder.ASC);
        return this.requestStrategy.configure(ssb);
    }

    private QueryBuilder queryFrom(ExportMessagesCommand command) {
        return QueryBuilders.boolQuery().filter(this.queryStringFilter(command)).filter(this.timestampFilter(command)).filter(this.streamsFilter(command));
    }

    private QueryBuilder queryStringFilter(ExportMessagesCommand command) {
        ElasticsearchQueryString backendQuery = command.queryString();
        return backendQuery.isEmpty() ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(backendQuery.queryString()).allowLeadingWildcard(this.allowLeadingWildcard);
    }

    private QueryBuilder timestampFilter(ExportMessagesCommand command) {
        return Objects.requireNonNull(TimeRangeQueryFactory.create((TimeRange)command.timeRange()));
    }

    private TermsQueryBuilder streamsFilter(ExportMessagesCommand command) {
        return QueryBuilders.termsQuery("streams", command.streams());
    }

    private Set<String> indicesFor(ExportMessagesCommand command) {
        return this.indexLookup.indexNamesForStreamsInTimeRange(command.streams(), (TimeRange)command.timeRange());
    }

    private boolean publishChunk(Consumer<SimpleMessageChunk> chunkCollector, List<SearchHit> hits, LinkedHashSet<String> desiredFieldsInOrder, SimpleMessageChunk.ChunkOrder chunkOrder) {
        SimpleMessageChunk chunk = this.chunkFrom(hits, desiredFieldsInOrder, chunkOrder);
        try {
            chunkCollector.accept(chunk);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Chunk publishing threw exception. Stopping search after queries", (Throwable)e);
            return false;
        }
    }

    private SimpleMessageChunk chunkFrom(List<SearchHit> hits, LinkedHashSet<String> desiredFieldsInOrder, SimpleMessageChunk.ChunkOrder chunkOrder) {
        LinkedHashSet<SimpleMessage> messages = this.messagesFrom(hits);
        return SimpleMessageChunk.builder().fieldsInOrder(desiredFieldsInOrder).messages(messages).chunkOrder(chunkOrder).build();
    }

    private LinkedHashSet<SimpleMessage> messagesFrom(List<SearchHit> hits) {
        return hits.stream().map(h -> this.buildHitWithAllFields(h.getSourceAsMap(), h.getIndex())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private SimpleMessage buildHitWithAllFields(Map source, String index) {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        for (Object key : source.keySet()) {
            String name = (String)key;
            Object value = this.valueFrom(source, name);
            fields.put(name, value);
        }
        fields.put("_id", UUID.randomUUID().toString());
        return SimpleMessage.from((String)index, fields);
    }

    private Object valueFrom(Map source, String name) {
        if (name.equals("timestamp")) {
            return this.fixTimestampFormat(source.get("timestamp"));
        }
        return source.get(name);
    }

    private Object fixTimestampFormat(Object rawTimestamp) {
        try {
            return Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime(String.valueOf(rawTimestamp)).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Could not parse timestamp {}", rawTimestamp, (Object)e);
            return rawTimestamp;
        }
    }
}

