/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.events.EventList;
import org.graylog.plugins.views.search.searchtypes.events.EventSummary;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.ESSearchTypeHandler;

public class ESEventList
implements ESSearchTypeHandler<EventList> {
    public void doGenerateQueryPart(SearchJob job, Query query, EventList eventList, ESGeneratedQueryContext queryContext) {
        queryContext.searchSourceBuilder((SearchType)eventList).size(10000);
    }

    protected List<Map<String, Object>> extractResult(SearchResponse result) {
        return StreamSupport.stream(result.getHits().spliterator(), false).map(SearchHit::getSourceAsMap).collect(Collectors.toList());
    }

    @Override
    public SearchType.Result doExtractResult(SearchJob job, Query query, EventList searchType, SearchResponse result, Aggregations aggregations, ESGeneratedQueryContext queryContext) {
        Set effectiveStreams = searchType.streams().isEmpty() ? query.usedStreamIds() : searchType.streams();
        List eventSummaries = this.extractResult(result).stream().map(EventSummary::parse).filter(eventSummary -> effectiveStreams.containsAll(eventSummary.streams())).collect(Collectors.toList());
        EventList.Result.Builder resultBuilder = EventList.Result.builder().events(eventSummaries).id(searchType.id());
        searchType.name().ifPresent(arg_0 -> ((EventList.Result.Builder)resultBuilder).name(arg_0));
        return resultBuilder.build();
    }
}

