/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.searchtypes.pivot.buckets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSort;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Values;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketOrder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.storage.elasticsearch7.views.ESGeneratedQueryContext;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivot;
import org.graylog.storage.elasticsearch7.views.searchtypes.pivot.ESPivotBucketSpecHandler;

public class ESValuesHandler
extends ESPivotBucketSpecHandler<Values, Terms> {
    @Nonnull
    public Optional<AggregationBuilder> doCreateAggregation(String name, Pivot pivot, Values valuesSpec, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext, Query query) {
        List<BucketOrder> ordering = this.orderListForPivot(pivot, valuesSpec, esGeneratedQueryContext);
        TermsAggregationBuilder builder = ((TermsAggregationBuilder)AggregationBuilders.terms(name).minDocCount(1L).field(valuesSpec.field())).order(ordering.isEmpty() ? Collections.singletonList(BucketOrder.count(false)) : ordering).size(valuesSpec.limit());
        this.record(esGeneratedQueryContext, pivot, (PivotSpec)valuesSpec, name, Terms.class);
        return Optional.of(builder);
    }

    private List<BucketOrder> orderListForPivot(Pivot pivot, Values valuesSpec, ESGeneratedQueryContext esGeneratedQueryContext) {
        return pivot.sort().stream().map(sortSpec -> {
            if (sortSpec instanceof PivotSort && valuesSpec.field().equals(sortSpec.field())) {
                return BucketOrder.key(sortSpec.direction().equals((Object)SortSpec.Direction.Ascending));
            }
            if (sortSpec instanceof SeriesSort) {
                Optional<SeriesSpec> matchingSeriesSpec = pivot.series().stream().filter(series -> series.literal().equals(sortSpec.field())).findFirst();
                return matchingSeriesSpec.map(seriesSpec -> {
                    if (seriesSpec.literal().equals("count()")) {
                        return BucketOrder.count(sortSpec.direction().equals((Object)SortSpec.Direction.Ascending));
                    }
                    return BucketOrder.aggregation(esGeneratedQueryContext.seriesName((SeriesSpec)seriesSpec, pivot), sortSpec.direction().equals((Object)SortSpec.Direction.Ascending));
                }).orElse(null);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Stream<ESPivotBucketSpecHandler.Bucket> doHandleResult(Pivot pivot, Values bucketSpec, SearchResponse searchResult, Terms termsAggregation, ESPivot searchTypeHandler, ESGeneratedQueryContext esGeneratedQueryContext) {
        return termsAggregation.getBuckets().stream().map(entry -> ESPivotBucketSpecHandler.Bucket.create(entry.getKeyAsString(), entry));
    }
}

