/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.searchbox.annotations.JestId;
import io.searchbox.annotations.JestVersion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestResult {
    public static final String ES_METADATA_ID = "es_metadata_id";
    public static final String ES_METADATA_VERSION = "es_metadata_version";
    private static final Logger log = LoggerFactory.getLogger(JestResult.class);
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    protected static final ImmutableList<MetaField> META_FIELDS = ImmutableList.of((Object)new MetaField("es_metadata_id", "_id", JestId.class), (Object)new MetaField("es_metadata_version", "_version", JestVersion.class));
    protected JsonNode jsonObject;
    protected String jsonString;
    protected String pathToResult;
    protected int responseCode;
    protected boolean isSucceeded;
    protected String errorMessage;
    protected ObjectMapper objectMapper;

    private JestResult() {
    }

    public JestResult(JestResult source) {
        this.jsonObject = source.jsonObject;
        this.jsonString = source.jsonString;
        this.pathToResult = source.pathToResult;
        this.responseCode = source.responseCode;
        this.isSucceeded = source.isSucceeded;
        this.errorMessage = source.errorMessage;
        this.objectMapper = source.objectMapper;
    }

    public JestResult(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getPathToResult() {
        return this.pathToResult;
    }

    public void setPathToResult(String pathToResult) {
        this.pathToResult = pathToResult;
    }

    public Object getValue(String key) {
        return this.getJsonMap().get(key);
    }

    public boolean isSucceeded() {
        return this.isSucceeded;
    }

    public void setSucceeded(boolean succeeded) {
        this.isSucceeded = succeeded;
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public JsonNode getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JsonNode jsonObject) {
        this.jsonObject = jsonObject;
        if (jsonObject.get("error") != null) {
            this.errorMessage = jsonObject.get("error").toString();
        }
    }

    @Deprecated
    public Map<String, Map> getJsonMap() {
        return (Map)this.objectMapper.convertValue((Object)this.jsonObject, TYPE_REFERENCE);
    }

    public void setJsonMap(Map<String, Object> resultMap) {
        JsonNode jsonNode = (JsonNode)this.objectMapper.convertValue(resultMap, JsonNode.class);
        this.setJsonObject(jsonNode);
    }

    public String getSourceAsString() {
        List<String> sources = this.getSourceAsStringList();
        return sources == null ? null : Joiner.on((char)',').join(sources);
    }

    public List<String> getSourceAsStringList() {
        String[] keys = this.getKeys();
        if (!this.isSucceeded || this.jsonObject == null || keys == null || keys.length == 0 || !this.jsonObject.has(keys[0])) {
            return null;
        }
        ArrayList<String> sourceList = new ArrayList<String>();
        for (JsonNode element : this.extractSource(false)) {
            sourceList.add(element.toString());
        }
        return sourceList;
    }

    public <T> T getSourceAsObject(Class<T> clazz) {
        return this.getSourceAsObject(clazz, true);
    }

    public <T> T getSourceAsObject(Class<T> clazz, boolean addEsMetadataFields) {
        T sourceAsObject = null;
        List<T> sources = this.getSourceAsObjectList(clazz, addEsMetadataFields);
        if (sources.size() > 0) {
            sourceAsObject = sources.get(0);
        }
        return sourceAsObject;
    }

    public <T> List<T> getSourceAsObjectList(Class<T> type) {
        return this.getSourceAsObjectList(type, true);
    }

    public <T> List<T> getSourceAsObjectList(Class<T> type, boolean addEsMetadataFields) {
        ArrayList<T> objectList = new ArrayList<T>();
        if (this.isSucceeded) {
            for (JsonNode source : this.extractSource(addEsMetadataFields)) {
                T obj = this.createSourceObject(source, type);
                if (obj == null) continue;
                objectList.add(obj);
            }
        }
        return objectList;
    }

    protected List<JsonNode> extractSource() {
        return this.extractSource(true);
    }

    protected List<JsonNode> extractSource(boolean addEsMetadataFields) {
        ArrayList<JsonNode> sourceList = new ArrayList<JsonNode>();
        if (this.jsonObject != null) {
            String[] keys = this.getKeys();
            if (keys == null) {
                sourceList.add(this.jsonObject);
            } else {
                String sourceKey = keys[keys.length - 1];
                JsonNode obj = this.jsonObject.get(keys[0]);
                if (keys.length > 1) {
                    for (int i = 1; i < keys.length - 1; ++i) {
                        obj = ((ObjectNode)obj).get(keys[i]);
                    }
                    if (obj.isObject()) {
                        JsonNode source = obj.get(sourceKey);
                        if (source != null) {
                            sourceList.add(source);
                        }
                    } else if (obj.isArray()) {
                        for (JsonNode element : obj) {
                            JsonNode currentObj;
                            JsonNode source;
                            if (!(element instanceof ObjectNode) || (source = (currentObj = element).get(sourceKey)) == null) continue;
                            ObjectNode copy = (ObjectNode)source.deepCopy();
                            if (addEsMetadataFields) {
                                for (MetaField metaField : META_FIELDS) {
                                    copy.set(metaField.internalFieldName, currentObj.get(metaField.esFieldName));
                                }
                            }
                            sourceList.add((JsonNode)copy);
                        }
                    }
                } else if (obj != null) {
                    JsonNode copy = obj.deepCopy();
                    if (addEsMetadataFields && copy.isObject()) {
                        for (MetaField metaField : META_FIELDS) {
                            JsonNode metaElement = this.jsonObject.get(metaField.esFieldName);
                            if (metaElement == null) continue;
                            ((ObjectNode)copy).set(metaField.internalFieldName, metaElement);
                        }
                    }
                    sourceList.add(copy);
                }
            }
        }
        return sourceList;
    }

    protected <T> T createSourceObject(JsonNode source, Class<T> type) {
        Object obj = null;
        try {
            obj = this.objectMapper.convertValue((Object)source, type);
            int knownMetadataFieldsCount = META_FIELDS.size();
            int foundFieldsCount = 0;
            boolean allFieldsFound = false;
            block2: for (Class<T> clazz = type; clazz != null && !allFieldsFound; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (foundFieldsCount == knownMetadataFieldsCount) {
                        allFieldsFound = true;
                        continue block2;
                    }
                    for (MetaField metaField : META_FIELDS) {
                        if (!field.isAnnotationPresent(metaField.annotationClass) || !this.setAnnotatedField(obj, source, field, metaField.internalFieldName)) continue;
                        ++foundFieldsCount;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred while converting source to the object. " + type.getCanonicalName(), (Throwable)e);
        }
        return (T)obj;
    }

    private <T> boolean setAnnotatedField(T obj, JsonNode source, Field field, String fieldName) {
        try {
            field.setAccessible(true);
            Object value = field.get(obj);
            if (value == null) {
                Class<?> fieldType = field.getType();
                JsonNode element = ((ObjectNode)source).get(fieldName);
                field.set(obj, this.getAs(element, fieldType));
                return true;
            }
        }
        catch (IllegalAccessException e) {
            log.error("Unhandled exception occurred while setting annotated field from source");
        }
        return false;
    }

    private <T> T getAs(JsonNode id, Class<T> fieldType) throws IllegalAccessException {
        if (id.isNull()) {
            return null;
        }
        if (fieldType.isAssignableFrom(String.class)) {
            return (T)id.asText();
        }
        if (fieldType.isAssignableFrom(Number.class)) {
            return (T)id.numberValue();
        }
        if (fieldType.isAssignableFrom(BigDecimal.class)) {
            return (T)id.decimalValue();
        }
        if (fieldType.isAssignableFrom(Double.class)) {
            Double o = id.asDouble();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Float.class)) {
            Float o = Float.valueOf(id.floatValue());
            return (T)o;
        }
        if (fieldType.isAssignableFrom(BigInteger.class)) {
            return (T)id.bigIntegerValue();
        }
        if (fieldType.isAssignableFrom(Long.class)) {
            Long o = id.asLong();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Integer.class)) {
            Integer o = id.asInt();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Short.class)) {
            Short o = id.shortValue();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Character.class)) {
            return (T)Character.valueOf((char)id.intValue());
        }
        if (fieldType.isAssignableFrom(Byte.class)) {
            return (T)Byte.valueOf(id.numberValue().byteValue());
        }
        if (fieldType.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(id.asBoolean());
        }
        throw new RuntimeException("cannot assign " + id + " to " + fieldType);
    }

    protected String[] getKeys() {
        return this.pathToResult == null ? null : this.pathToResult.split("/");
    }

    protected static class MetaField {
        public final String internalFieldName;
        public final String esFieldName;
        public final Class<? extends Annotation> annotationClass;

        MetaField(String internalFieldName, String esFieldName, Class<? extends Annotation> annotationClass) {
            this.internalFieldName = internalFieldName;
            this.esFieldName = esFieldName;
            this.annotationClass = annotationClass;
        }
    }
}

