/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.FilterAggregation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersAggregation
extends BucketAggregation {
    private static final Logger log = LoggerFactory.getLogger(FiltersAggregation.class);
    public static final String TYPE = "filters";
    private String name;
    private Map<String, Bucket> bucketMap = new HashMap<String, Bucket>();
    private List<Bucket> bucketList = new LinkedList<Bucket>();

    public FiltersAggregation(String name, JsonNode filtersAggregation) {
        super(name, filtersAggregation);
        if (filtersAggregation.has(String.valueOf((Object)AggregationField.BUCKETS))) {
            this.parseBuckets(filtersAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)));
        }
    }

    private void parseBuckets(JsonNode buckets) {
        if (buckets.isArray()) {
            int elementNumber = 0;
            for (JsonNode bucket : buckets) {
                this.addBucket("filter" + Integer.toString(elementNumber++), bucket);
            }
        } else if (buckets.isObject()) {
            Iterator it = buckets.fields();
            while (it.hasNext()) {
                Map.Entry bucket = (Map.Entry)it.next();
                this.addBucket((String)bucket.getKey(), (JsonNode)bucket.getValue());
            }
        } else {
            log.debug("Skipped bucket parsing because Buckets element of JSON was neither Object nor Array.");
        }
    }

    private void addBucket(String filterName, JsonNode bucketSource) {
        FilterAggregation bucket = new FilterAggregation(filterName, bucketSource);
        this.bucketMap.put(filterName, bucket);
        this.bucketList.add(bucket);
    }

    public List<Bucket> getBuckets() {
        return this.bucketList;
    }

    public Map<String, Bucket> getBucketMap() {
        return this.bucketMap;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FiltersAggregation rhs = (FiltersAggregation)obj;
        return super.equals(obj) && Objects.equals(this.bucketMap, rhs.bucketMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bucketMap);
    }
}

