/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices.script;

import com.google.common.io.CharStreams;
import io.searchbox.action.AbstractAction;
import io.searchbox.indices.script.AbstractIndexedScript;
import io.searchbox.indices.script.ScriptLanguage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class CreateIndexedScript
extends AbstractIndexedScript {
    protected CreateIndexedScript(Builder builder) {
        super(builder);
        this.payload = builder.payload;
        this.setURI(this.buildURI());
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public static class Builder
    extends AbstractIndexedScript.Builder<CreateIndexedScript, Builder> {
        private Map<String, String> payload;

        public Builder(String scriptName) {
            super(scriptName);
        }

        @Override
        public CreateIndexedScript build() {
            return new CreateIndexedScript(this);
        }

        public Builder setSource(String source) {
            this.createPayload(source);
            return this;
        }

        public Builder loadSource(File srcFile) throws IOException {
            return this.loadSource(srcFile, Charset.forName(AbstractAction.CHARSET));
        }

        public Builder loadSource(File srcFile, Charset encoding) throws IOException {
            return this.loadSource(new FileInputStream(srcFile), encoding);
        }

        public Builder loadSource(InputStream srcStream) throws IOException {
            return this.loadSource(srcStream, Charset.forName(AbstractAction.CHARSET));
        }

        public Builder loadSource(InputStream srcStream, Charset encoding) throws IOException {
            String src = CharStreams.toString((Readable)new InputStreamReader(srcStream, encoding));
            this.createPayload(src);
            return this;
        }

        private void createPayload(String source) {
            this.payload = Collections.singletonMap("script", source);
        }
    }
}

