/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.Rectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.SloppyMath;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.bkd.BKDReader;

class NearestNeighbor {
    NearestNeighbor() {
    }

    public static NearestHit[] nearest(double pointLat, double pointLon, List<BKDReader> readers, List<Bits> liveDocs, List<Integer> docBases, int n) throws IOException {
        BKDReader reader;
        PriorityQueue<NearestHit> hitQueue = new PriorityQueue<NearestHit>(n, new Comparator<NearestHit>(){

            @Override
            public int compare(NearestHit a, NearestHit b) {
                int cmp = Double.compare(a.distanceMeters, b.distanceMeters);
                if (cmp != 0) {
                    return -cmp;
                }
                return b.docID - a.docID;
            }
        });
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        NearestVisitor visitor = new NearestVisitor(hitQueue, n, pointLat, pointLon);
        ArrayList<BKDReader.IntersectState> states = new ArrayList<BKDReader.IntersectState>();
        int bytesPerDim = -1;
        for (int i = 0; i < readers.size(); ++i) {
            reader = readers.get(i);
            if (bytesPerDim == -1) {
                bytesPerDim = reader.getBytesPerDimension();
            } else if (bytesPerDim != reader.getBytesPerDimension()) {
                throw new IllegalStateException("bytesPerDim changed from " + bytesPerDim + " to " + reader.getBytesPerDimension() + " across readers");
            }
            byte[] minPackedValue = reader.getMinPackedValue();
            byte[] maxPackedValue = reader.getMaxPackedValue();
            BKDReader.IntersectState state = reader.getIntersectState(visitor);
            states.add(state);
            cellQueue.offer(new Cell(state.index, i, reader.getMinPackedValue(), reader.getMaxPackedValue(), NearestNeighbor.approxBestDistance(minPackedValue, maxPackedValue, pointLat, pointLon)));
        }
        while (cellQueue.size() > 0) {
            Cell cell = (Cell)cellQueue.poll();
            reader = readers.get(cell.readerIndex);
            if (cell.index.isLeafNode()) {
                visitor.curDocBase = docBases.get(cell.readerIndex);
                visitor.curLiveDocs = liveDocs.get(cell.readerIndex);
                reader.visitLeafBlockValues(cell.index, (BKDReader.IntersectState)states.get(cell.readerIndex));
                continue;
            }
            double cellMinLat = GeoEncodingUtils.decodeLatitude(cell.minPacked, 0);
            double cellMinLon = GeoEncodingUtils.decodeLongitude(cell.minPacked, 4);
            double cellMaxLat = GeoEncodingUtils.decodeLatitude(cell.maxPacked, 0);
            double cellMaxLon = GeoEncodingUtils.decodeLongitude(cell.maxPacked, 4);
            if (cellMaxLat < visitor.minLat || visitor.maxLat < cellMinLat || (cellMaxLon < visitor.minLon || visitor.maxLon < cellMinLon) && cellMaxLon < visitor.minLon2) continue;
            BytesRef splitValue = BytesRef.deepCopyOf(cell.index.getSplitDimValue());
            int splitDim = cell.index.getSplitDim();
            BKDReader.IndexTree newIndex = cell.index.clone();
            byte[] splitPackedValue = (byte[])cell.maxPacked.clone();
            System.arraycopy(splitValue.bytes, splitValue.offset, splitPackedValue, splitDim * bytesPerDim, bytesPerDim);
            cell.index.pushLeft();
            cellQueue.offer(new Cell(cell.index, cell.readerIndex, cell.minPacked, splitPackedValue, NearestNeighbor.approxBestDistance(cell.minPacked, splitPackedValue, pointLat, pointLon)));
            splitPackedValue = (byte[])cell.minPacked.clone();
            System.arraycopy(splitValue.bytes, splitValue.offset, splitPackedValue, splitDim * bytesPerDim, bytesPerDim);
            newIndex.pushRight();
            cellQueue.offer(new Cell(newIndex, cell.readerIndex, splitPackedValue, cell.maxPacked, NearestNeighbor.approxBestDistance(splitPackedValue, cell.maxPacked, pointLat, pointLon)));
        }
        NearestHit[] hits = new NearestHit[hitQueue.size()];
        int downTo = hitQueue.size() - 1;
        while (hitQueue.size() != 0) {
            hits[downTo] = hitQueue.poll();
            --downTo;
        }
        return hits;
    }

    private static double approxBestDistance(byte[] minPackedValue, byte[] maxPackedValue, double pointLat, double pointLon) {
        double minLat = GeoEncodingUtils.decodeLatitude(minPackedValue, 0);
        double minLon = GeoEncodingUtils.decodeLongitude(minPackedValue, 4);
        double maxLat = GeoEncodingUtils.decodeLatitude(maxPackedValue, 0);
        double maxLon = GeoEncodingUtils.decodeLongitude(maxPackedValue, 4);
        return NearestNeighbor.approxBestDistance(minLat, maxLat, minLon, maxLon, pointLat, pointLon);
    }

    private static double approxBestDistance(double minLat, double maxLat, double minLon, double maxLon, double pointLat, double pointLon) {
        if (pointLat >= minLat && pointLat <= maxLat && pointLon >= minLon && pointLon <= maxLon) {
            return 0.0;
        }
        double d1 = SloppyMath.haversinMeters(pointLat, pointLon, minLat, minLon);
        double d2 = SloppyMath.haversinMeters(pointLat, pointLon, minLat, maxLon);
        double d3 = SloppyMath.haversinMeters(pointLat, pointLon, maxLat, maxLon);
        double d4 = SloppyMath.haversinMeters(pointLat, pointLon, maxLat, minLon);
        return Math.min(Math.min(d1, d2), Math.min(d3, d4));
    }

    static class NearestHit {
        public int docID;
        public double distanceMeters;

        NearestHit() {
        }

        public String toString() {
            return "NearestHit(docID=" + this.docID + " distanceMeters=" + this.distanceMeters + ")";
        }
    }

    private static class NearestVisitor
    implements PointValues.IntersectVisitor {
        public int curDocBase;
        public Bits curLiveDocs;
        final int topN;
        final PriorityQueue<NearestHit> hitQueue;
        final double pointLat;
        final double pointLon;
        private int setBottomCounter;
        private double minLon = Double.NEGATIVE_INFINITY;
        private double maxLon = Double.POSITIVE_INFINITY;
        private double minLat = Double.NEGATIVE_INFINITY;
        private double maxLat = Double.POSITIVE_INFINITY;
        private double minLon2 = Double.POSITIVE_INFINITY;

        public NearestVisitor(PriorityQueue<NearestHit> hitQueue, int topN, double pointLat, double pointLon) {
            this.hitQueue = hitQueue;
            this.topN = topN;
            this.pointLat = pointLat;
            this.pointLon = pointLon;
        }

        @Override
        public void visit(int docID) {
            throw new AssertionError();
        }

        private void maybeUpdateBBox() {
            if (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63) {
                NearestHit hit = this.hitQueue.peek();
                Rectangle box = Rectangle.fromPointDistance(this.pointLat, this.pointLon, hit.distanceMeters);
                this.minLat = box.minLat;
                this.maxLat = box.maxLat;
                if (box.crossesDateline()) {
                    this.minLon = Double.NEGATIVE_INFINITY;
                    this.maxLon = box.maxLon;
                    this.minLon2 = box.minLon;
                } else {
                    this.minLon = box.minLon;
                    this.maxLon = box.maxLon;
                    this.minLon2 = Double.POSITIVE_INFINITY;
                }
            }
            ++this.setBottomCounter;
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            if (this.curLiveDocs != null && !this.curLiveDocs.get(docID)) {
                return;
            }
            double docLatitude = GeoEncodingUtils.decodeLatitude(packedValue, 0);
            double docLongitude = GeoEncodingUtils.decodeLongitude(packedValue, 4);
            if (docLatitude < this.minLat || docLatitude > this.maxLat) {
                return;
            }
            if ((docLongitude < this.minLon || docLongitude > this.maxLon) && docLongitude < this.minLon2) {
                return;
            }
            double distanceMeters = SloppyMath.haversinMeters(this.pointLat, this.pointLon, docLatitude, docLongitude);
            int fullDocID = this.curDocBase + docID;
            if (this.hitQueue.size() == this.topN) {
                NearestHit hit = this.hitQueue.peek();
                if (distanceMeters < hit.distanceMeters || distanceMeters == hit.distanceMeters && fullDocID < hit.docID) {
                    this.hitQueue.poll();
                    hit.docID = fullDocID;
                    hit.distanceMeters = distanceMeters;
                    this.hitQueue.offer(hit);
                    this.maybeUpdateBBox();
                }
            } else {
                NearestHit hit = new NearestHit();
                hit.docID = fullDocID;
                hit.distanceMeters = distanceMeters;
                this.hitQueue.offer(hit);
            }
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            throw new AssertionError();
        }
    }

    static class Cell
    implements Comparable<Cell> {
        final int readerIndex;
        final byte[] minPacked;
        final byte[] maxPacked;
        final BKDReader.IndexTree index;
        final double distanceMeters;

        public Cell(BKDReader.IndexTree index, int readerIndex, byte[] minPacked, byte[] maxPacked, double distanceMeters) {
            this.index = index;
            this.readerIndex = readerIndex;
            this.minPacked = (byte[])minPacked.clone();
            this.maxPacked = (byte[])maxPacked.clone();
            this.distanceMeters = distanceMeters;
        }

        @Override
        public int compareTo(Cell other) {
            return Double.compare(this.distanceMeters, other.distanceMeters);
        }

        public String toString() {
            double minLat = GeoEncodingUtils.decodeLatitude(this.minPacked, 0);
            double minLon = GeoEncodingUtils.decodeLongitude(this.minPacked, 4);
            double maxLat = GeoEncodingUtils.decodeLatitude(this.maxPacked, 0);
            double maxLon = GeoEncodingUtils.decodeLongitude(this.maxPacked, 4);
            return "Cell(readerIndex=" + this.readerIndex + " nodeID=" + this.index.getNodeID() + " isLeaf=" + this.index.isLeafNode() + " lat=" + minLat + " TO " + maxLat + ", lon=" + minLon + " TO " + maxLon + "; distanceMeters=" + this.distanceMeters + ")";
        }
    }
}

