/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.DocValuesProducer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.FieldsProducer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.NormsProducer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.PointsReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.StoredFieldsReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.TermVectorsReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Document;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.CodecReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexNotFoundException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.Directory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.FSDirectory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IOContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.Lock;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountables;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.LongBitSet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.StringHelper;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.SuppressForbidden;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Version;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Automata;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.CompiledAutomaton;

public final class CheckIndex
implements Closeable {
    private PrintStream infoStream;
    private Directory dir;
    private Lock writeLock;
    private volatile boolean closed;
    private boolean crossCheckTermVectors;
    private boolean failFast;
    private boolean verbose;
    private boolean checksumsOnly;
    private static boolean assertsOn;

    public CheckIndex(Directory dir) throws IOException {
        this(dir, dir.obtainLock("write.lock"));
    }

    public CheckIndex(Directory dir, Lock writeLock) throws IOException {
        this.dir = dir;
        this.writeLock = writeLock;
        this.infoStream = null;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("this instance is closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        IOUtils.close(this.writeLock);
    }

    public void setCrossCheckTermVectors(boolean v) {
        this.crossCheckTermVectors = v;
    }

    public boolean getCrossCheckTermVectors() {
        return this.crossCheckTermVectors;
    }

    public void setFailFast(boolean v) {
        this.failFast = v;
    }

    public boolean getFailFast() {
        return this.failFast;
    }

    public boolean getChecksumsOnly() {
        return this.checksumsOnly;
    }

    public void setChecksumsOnly(boolean v) {
        this.checksumsOnly = v;
    }

    public void setInfoStream(PrintStream out, boolean verbose) {
        this.infoStream = out;
        this.verbose = verbose;
    }

    public void setInfoStream(PrintStream out) {
        this.setInfoStream(out, false);
    }

    private static void msg(PrintStream out, String msg) {
        if (out != null) {
            out.println(msg);
        }
    }

    public Status checkIndex() throws IOException {
        return this.checkIndex(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status checkIndex(List<String> onlySegments) throws IOException {
        this.ensureOpen();
        long startNS = System.nanoTime();
        NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
        SegmentInfos sis = null;
        Status result = new Status();
        result.dir = this.dir;
        Object[] files = this.dir.listAll();
        String lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])files);
        if (lastSegmentsFile == null) {
            throw new IndexNotFoundException("no segments* file found in " + this.dir + ": files: " + Arrays.toString(files));
        }
        try {
            sis = SegmentInfos.readCommit(this.dir, lastSegmentsFile);
        }
        catch (Throwable t) {
            if (this.failFast) {
                throw IOUtils.rethrowAlways(t);
            }
            CheckIndex.msg(this.infoStream, "ERROR: could not read any segments file in directory");
            result.missingSegments = true;
            if (this.infoStream != null) {
                t.printStackTrace(this.infoStream);
            }
            return result;
        }
        Version oldest = null;
        Version newest = null;
        String oldSegs = null;
        for (SegmentCommitInfo si : sis) {
            Version version = si.info.getVersion();
            if (version == null) {
                oldSegs = "pre-3.1";
                continue;
            }
            if (oldest == null || !version.onOrAfter(oldest)) {
                oldest = version;
            }
            if (newest != null && !version.onOrAfter(newest)) continue;
            newest = version;
        }
        int numSegments = sis.size();
        String segmentsFileName = sis.getSegmentsFileName();
        IndexInput input = null;
        try {
            input = this.dir.openInput(segmentsFileName, IOContext.READONCE);
        }
        catch (Throwable t) {
            if (this.failFast) {
                throw IOUtils.rethrowAlways(t);
            }
            CheckIndex.msg(this.infoStream, "ERROR: could not open segments file in directory");
            if (this.infoStream != null) {
                t.printStackTrace(this.infoStream);
            }
            result.cantOpenSegments = true;
            return result;
        }
        try {
            input.readInt();
        }
        catch (Throwable t) {
            if (this.failFast) {
                throw IOUtils.rethrowAlways(t);
            }
            CheckIndex.msg(this.infoStream, "ERROR: could not read segment file version in directory");
            if (this.infoStream != null) {
                t.printStackTrace(this.infoStream);
            }
            result.missingSegmentVersion = true;
            Status status = result;
            return status;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        result.segmentsFileName = segmentsFileName;
        result.numSegments = numSegments;
        result.userData = sis.getUserData();
        String userDataString = sis.getUserData().size() > 0 ? " userData=" + sis.getUserData() : "";
        String versionString = "";
        if (oldSegs != null) {
            versionString = newest != null ? "versions=[" + oldSegs + " .. " + newest + "]" : "version=" + oldSegs;
        } else if (newest != null) {
            versionString = oldest.equals(newest) ? "version=" + oldest : "versions=[" + oldest + " .. " + newest + "]";
        }
        CheckIndex.msg(this.infoStream, "Segments file=" + segmentsFileName + " numSegments=" + numSegments + " " + versionString + " id=" + StringHelper.idToString(sis.getId()) + userDataString);
        if (onlySegments != null) {
            result.partial = true;
            if (this.infoStream != null) {
                this.infoStream.print("\nChecking only these segments:");
                for (String s : onlySegments) {
                    this.infoStream.print(" " + s);
                }
            }
            result.segmentsChecked.addAll(onlySegments);
            CheckIndex.msg(this.infoStream, ":");
        }
        result.newSegments = sis.clone();
        result.newSegments.clear();
        result.maxSegmentName = -1;
        for (int i = 0; i < numSegments; ++i) {
            SegmentCommitInfo info = sis.info(i);
            int segmentName = Integer.parseInt(info.info.name.substring(1), 36);
            if (segmentName > result.maxSegmentName) {
                result.maxSegmentName = segmentName;
            }
            if (onlySegments != null && !onlySegments.contains(info.info.name)) continue;
            Status.SegmentInfoStatus segInfoStat = new Status.SegmentInfoStatus();
            result.segmentInfos.add(segInfoStat);
            CheckIndex.msg(this.infoStream, "  " + (1 + i) + " of " + numSegments + ": name=" + info.info.name + " maxDoc=" + info.info.maxDoc());
            segInfoStat.name = info.info.name;
            segInfoStat.maxDoc = info.info.maxDoc();
            Version version = info.info.getVersion();
            if (info.info.maxDoc() <= 0) {
                throw new RuntimeException("illegal number of documents: maxDoc=" + info.info.maxDoc());
            }
            int toLoseDocCount = info.info.maxDoc();
            Sort previousIndexSort = null;
            try (IndexReader reader = null;){
                int numDocs;
                CheckIndex.msg(this.infoStream, "    version=" + (version == null ? "3.0" : version));
                CheckIndex.msg(this.infoStream, "    id=" + StringHelper.idToString(info.info.getId()));
                Codec codec = info.info.getCodec();
                CheckIndex.msg(this.infoStream, "    codec=" + codec);
                segInfoStat.codec = codec;
                CheckIndex.msg(this.infoStream, "    compound=" + info.info.getUseCompoundFile());
                segInfoStat.compound = info.info.getUseCompoundFile();
                CheckIndex.msg(this.infoStream, "    numFiles=" + info.files().size());
                Sort indexSort = info.info.getIndexSort();
                if (indexSort != null) {
                    CheckIndex.msg(this.infoStream, "    sort=" + indexSort);
                    if (previousIndexSort != null) {
                        if (!previousIndexSort.equals(indexSort)) {
                            throw new RuntimeException("index sort changed from " + previousIndexSort + " to " + indexSort);
                        }
                    } else {
                        previousIndexSort = indexSort;
                    }
                }
                segInfoStat.numFiles = info.files().size();
                segInfoStat.sizeMB = (double)info.sizeInBytes() / 1048576.0;
                CheckIndex.msg(this.infoStream, "    size (MB)=" + nf.format(segInfoStat.sizeMB));
                Map<String, String> diagnostics = info.info.getDiagnostics();
                segInfoStat.diagnostics = diagnostics;
                if (diagnostics.size() > 0) {
                    CheckIndex.msg(this.infoStream, "    diagnostics = " + diagnostics);
                }
                if (!info.hasDeletions()) {
                    CheckIndex.msg(this.infoStream, "    no deletions");
                    segInfoStat.hasDeletions = false;
                } else {
                    CheckIndex.msg(this.infoStream, "    has deletions [delGen=" + info.getDelGen() + "]");
                    segInfoStat.hasDeletions = true;
                    segInfoStat.deletionsGen = info.getDelGen();
                }
                long startOpenReaderNS = System.nanoTime();
                if (this.infoStream != null) {
                    this.infoStream.print("    test: open reader.........");
                }
                reader = new SegmentReader(info, IOContext.DEFAULT);
                CheckIndex.msg(this.infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startOpenReaderNS)));
                segInfoStat.openReaderPassed = true;
                long startIntegrityNS = System.nanoTime();
                if (this.infoStream != null) {
                    this.infoStream.print("    test: check integrity.....");
                }
                ((CodecReader)reader).checkIntegrity();
                CheckIndex.msg(this.infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startIntegrityNS)));
                if (((SegmentReader)reader).maxDoc() != info.info.maxDoc()) {
                    throw new RuntimeException("SegmentReader.maxDoc() " + ((SegmentReader)reader).maxDoc() + " != SegmentInfo.maxDoc " + info.info.maxDoc());
                }
                toLoseDocCount = numDocs = ((SegmentReader)reader).numDocs();
                if (reader.hasDeletions()) {
                    if (((SegmentReader)reader).numDocs() != info.info.maxDoc() - info.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + (info.info.maxDoc() - info.getDelCount()) + " vs reader=" + ((SegmentReader)reader).numDocs());
                    }
                    if (info.info.maxDoc() - ((SegmentReader)reader).numDocs() > ((SegmentReader)reader).maxDoc()) {
                        throw new RuntimeException("too many deleted docs: maxDoc()=" + ((SegmentReader)reader).maxDoc() + " vs del count=" + (info.info.maxDoc() - ((SegmentReader)reader).numDocs()));
                    }
                    if (info.info.maxDoc() - ((SegmentReader)reader).numDocs() != info.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.info.maxDoc() - ((SegmentReader)reader).numDocs()));
                    }
                } else if (info.getDelCount() != 0) {
                    throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.info.maxDoc() - ((SegmentReader)reader).numDocs()));
                }
                if (!this.checksumsOnly) {
                    segInfoStat.liveDocStatus = CheckIndex.testLiveDocs((CodecReader)reader, this.infoStream, this.failFast);
                    segInfoStat.fieldInfoStatus = CheckIndex.testFieldInfos((CodecReader)reader, this.infoStream, this.failFast);
                    segInfoStat.fieldNormStatus = CheckIndex.testFieldNorms((CodecReader)reader, this.infoStream, this.failFast);
                    segInfoStat.termIndexStatus = CheckIndex.testPostings((CodecReader)reader, this.infoStream, this.verbose, this.failFast);
                    segInfoStat.storedFieldStatus = CheckIndex.testStoredFields((CodecReader)reader, this.infoStream, this.failFast);
                    segInfoStat.termVectorStatus = CheckIndex.testTermVectors((CodecReader)reader, this.infoStream, this.verbose, this.crossCheckTermVectors, this.failFast);
                    segInfoStat.docValuesStatus = CheckIndex.testDocValues((CodecReader)reader, this.infoStream, this.failFast);
                    segInfoStat.pointsStatus = CheckIndex.testPoints((CodecReader)reader, this.infoStream, this.failFast);
                    segInfoStat.indexSortStatus = CheckIndex.testSort((CodecReader)reader, indexSort, this.infoStream, this.failFast);
                    if (segInfoStat.liveDocStatus.error != null) {
                        throw new RuntimeException("Live docs test failed");
                    }
                    if (segInfoStat.fieldInfoStatus.error != null) {
                        throw new RuntimeException("Field Info test failed");
                    }
                    if (segInfoStat.fieldNormStatus.error != null) {
                        throw new RuntimeException("Field Norm test failed");
                    }
                    if (segInfoStat.termIndexStatus.error != null) {
                        throw new RuntimeException("Term Index test failed");
                    }
                    if (segInfoStat.storedFieldStatus.error != null) {
                        throw new RuntimeException("Stored Field test failed");
                    }
                    if (segInfoStat.termVectorStatus.error != null) {
                        throw new RuntimeException("Term Vector test failed");
                    }
                    if (segInfoStat.docValuesStatus.error != null) {
                        throw new RuntimeException("DocValues test failed");
                    }
                    if (segInfoStat.pointsStatus.error != null) {
                        throw new RuntimeException("Points test failed");
                    }
                }
                CheckIndex.msg(this.infoStream, "");
                if (this.verbose) {
                    CheckIndex.msg(this.infoStream, "detailed segment RAM usage: ");
                    CheckIndex.msg(this.infoStream, Accountables.toString((Accountable)((Object)reader)));
                }
            }
            result.newSegments.add(info.clone());
        }
        if (0 == result.numBadSegments) {
            result.clean = true;
        } else {
            CheckIndex.msg(this.infoStream, "WARNING: " + result.numBadSegments + " broken segments (containing " + result.totLoseDocCount + " documents) detected");
        }
        if (!(result.validCounter = result.maxSegmentName < sis.counter)) {
            result.clean = false;
            result.newSegments.counter = result.maxSegmentName + 1;
            CheckIndex.msg(this.infoStream, "ERROR: Next segment name counter " + sis.counter + " is not greater than max segment name " + result.maxSegmentName);
        }
        if (result.clean) {
            CheckIndex.msg(this.infoStream, "No problems were detected with this index.\n");
        }
        CheckIndex.msg(this.infoStream, String.format(Locale.ROOT, "Took %.3f sec total.", CheckIndex.nsToSec(System.nanoTime() - startNS)));
        return result;
    }

    public static Status.IndexSortStatus testSort(CodecReader reader, Sort sort, PrintStream infoStream, boolean failFast) throws IOException {
        Status.IndexSortStatus status;
        block8: {
            long startNS = System.nanoTime();
            status = new Status.IndexSortStatus();
            if (sort != null) {
                if (infoStream != null) {
                    infoStream.print("    test: index sort..........");
                }
                SortField[] fields = sort.getSort();
                int[] reverseMul = new int[fields.length];
                LeafFieldComparator[] comparators = new LeafFieldComparator[fields.length];
                LeafReaderContext readerContext = new LeafReaderContext(reader);
                for (int i = 0; i < fields.length; ++i) {
                    reverseMul[i] = fields[i].getReverse() ? -1 : 1;
                    comparators[i] = fields[i].getComparator(1, i).getLeafComparator(readerContext);
                }
                int maxDoc = reader.maxDoc();
                try {
                    for (int docID = 1; docID < maxDoc; ++docID) {
                        int cmp = 0;
                        for (int i = 0; i < comparators.length; ++i) {
                            comparators[i].copy(0, docID - 1);
                            comparators[i].setBottom(0);
                            cmp = reverseMul[i] * comparators[i].compareBottom(docID);
                            if (cmp != 0) break;
                        }
                        if (cmp <= 0) continue;
                        throw new RuntimeException("segment has indexSort=" + sort + " but docID=" + (docID - 1) + " sorts after docID=" + docID);
                    }
                    CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startNS)));
                }
                catch (Throwable e) {
                    if (failFast) {
                        throw IOUtils.rethrowAlways(e);
                    }
                    CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                    status.error = e;
                    if (infoStream == null) break block8;
                    e.printStackTrace(infoStream);
                }
            }
        }
        return status;
    }

    public static Status.LiveDocStatus testLiveDocs(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.LiveDocStatus status;
        block11: {
            long startNS = System.nanoTime();
            status = new Status.LiveDocStatus();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: check live docs.....");
                }
                int numDocs = reader.numDocs();
                if (reader.hasDeletions()) {
                    Bits liveDocs = reader.getLiveDocs();
                    if (liveDocs == null) {
                        throw new RuntimeException("segment should have deletions, but liveDocs is null");
                    }
                    int numLive = 0;
                    for (int j = 0; j < liveDocs.length(); ++j) {
                        if (!liveDocs.get(j)) continue;
                        ++numLive;
                    }
                    if (numLive != numDocs) {
                        throw new RuntimeException("liveDocs count mismatch: info=" + numDocs + ", vs bits=" + numLive);
                    }
                    status.numDeleted = reader.numDeletedDocs();
                    CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d deleted docs] [took %.3f sec]", status.numDeleted, CheckIndex.nsToSec(System.nanoTime() - startNS)));
                } else {
                    Bits liveDocs = reader.getLiveDocs();
                    if (liveDocs != null) {
                        for (int j = 0; j < liveDocs.length(); ++j) {
                            if (liveDocs.get(j)) continue;
                            throw new RuntimeException("liveDocs mismatch: info says no deletions but doc " + j + " is deleted.");
                        }
                    }
                    CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startNS)));
                }
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block11;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.FieldInfoStatus testFieldInfos(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.FieldInfoStatus status;
        block5: {
            long startNS = System.nanoTime();
            status = new Status.FieldInfoStatus();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: field infos.........");
                }
                FieldInfos fieldInfos = reader.getFieldInfos();
                for (FieldInfo f : fieldInfos) {
                    f.checkConsistency();
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d fields] [took %.3f sec]", fieldInfos.size(), CheckIndex.nsToSec(System.nanoTime() - startNS)));
                status.totFields = fieldInfos.size();
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block5;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.FieldNormStatus testFieldNorms(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.FieldNormStatus status;
        block6: {
            long startNS = System.nanoTime();
            status = new Status.FieldNormStatus();
            try {
                NormsProducer normsReader;
                if (infoStream != null) {
                    infoStream.print("    test: field norms.........");
                }
                if ((normsReader = reader.getNormsReader()) != null) {
                    normsReader = normsReader.getMergeInstance();
                }
                for (FieldInfo info : reader.getFieldInfos()) {
                    if (!info.hasNorms()) continue;
                    CheckIndex.checkNumericDocValues(info.name, reader.maxDoc(), normsReader.getNorms(info), new Bits.MatchAllBits(reader.maxDoc()));
                    ++status.totFields;
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d fields] [took %.3f sec]", status.totFields, CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block6;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    private static long getDocsFromTermRange(String field, int maxDoc, TermsEnum termsEnum, FixedBitSet docsSeen, BytesRef minTerm, BytesRef maxTerm, boolean isIntersect) throws IOException {
        docsSeen.clear(0, docsSeen.length());
        long termCount = 0L;
        PostingsEnum postingsEnum = null;
        BytesRefBuilder lastTerm = null;
        while (true) {
            int doc;
            BytesRef term;
            if ((term = isIntersect || termCount != 0L ? termsEnum.next() : termsEnum.term()) == null) {
                if (!isIntersect) {
                    throw new RuntimeException("didn't see max term field=" + field + " term=" + maxTerm);
                }
                return termCount;
            }
            assert (term.isValid());
            if (lastTerm == null) {
                lastTerm = new BytesRefBuilder();
                lastTerm.copyBytes(term);
            } else {
                if (lastTerm.get().compareTo(term) >= 0) {
                    throw new RuntimeException("terms out of order: lastTerm=" + lastTerm.get() + " term=" + term);
                }
                lastTerm.copyBytes(term);
            }
            if (term.compareTo(minTerm) < 0) {
                throw new RuntimeException("saw term before min term field=" + field + " term=" + minTerm);
            }
            if (!isIntersect) {
                int cmp = term.compareTo(maxTerm);
                if (cmp == 0) {
                    return termCount;
                }
                if (cmp > 0) {
                    throw new RuntimeException("didn't see end term field=" + field + " term=" + maxTerm);
                }
            }
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            int lastDoc = -1;
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (doc <= lastDoc) {
                    throw new RuntimeException("term " + term + ": doc " + doc + " <= lastDoc " + lastDoc);
                }
                if (doc >= maxDoc) {
                    throw new RuntimeException("term " + term + ": doc " + doc + " >= maxDoc " + maxDoc);
                }
                docsSeen.set(doc);
                lastDoc = doc;
            }
            ++termCount;
        }
    }

    private static boolean checkSingleTermRange(String field, int maxDoc, Terms terms, BytesRef minTerm, BytesRef maxTerm, FixedBitSet normalDocs, FixedBitSet intersectDocs) throws IOException {
        assert (minTerm.compareTo(maxTerm) <= 0);
        TermsEnum termsEnum = terms.iterator();
        TermsEnum.SeekStatus status = termsEnum.seekCeil(minTerm);
        if (status != TermsEnum.SeekStatus.FOUND) {
            throw new RuntimeException("failed to seek to existing term field=" + field + " term=" + minTerm);
        }
        long normalTermCount = CheckIndex.getDocsFromTermRange(field, maxDoc, termsEnum, normalDocs, minTerm, maxTerm, false);
        long intersectTermCount = CheckIndex.getDocsFromTermRange(field, maxDoc, terms.intersect(new CompiledAutomaton(Automata.makeBinaryInterval(minTerm, true, maxTerm, false), true, false, Integer.MAX_VALUE, true), null), intersectDocs, minTerm, maxTerm, true);
        if (intersectTermCount > normalTermCount) {
            throw new RuntimeException("intersect returned too many terms: field=" + field + " intersectTermCount=" + intersectTermCount + " normalTermCount=" + normalTermCount);
        }
        if (!normalDocs.equals(intersectDocs)) {
            throw new RuntimeException("intersect visited different docs than straight terms enum: " + normalDocs.cardinality() + " for straight enum, vs " + intersectDocs.cardinality() + " for intersect, minTerm=" + minTerm + " maxTerm=" + maxTerm);
        }
        return intersectTermCount != normalTermCount;
    }

    private static void checkTermRanges(String field, int maxDoc, Terms terms, long numTerms) throws IOException {
        FixedBitSet normalDocs = new FixedBitSet(maxDoc);
        FixedBitSet intersectDocs = new FixedBitSet(maxDoc);
        for (double currentInterval = (double)numTerms; currentInterval >= 10.0; currentInterval *= 0.75) {
            BytesRef term;
            TermsEnum termsEnum = terms.iterator();
            long termCount = 0L;
            LinkedList<BytesRef> termBounds = new LinkedList<BytesRef>();
            long lastTermAdded = Long.MIN_VALUE;
            BytesRefBuilder lastTerm = null;
            while ((term = termsEnum.next()) != null) {
                if ((double)termCount >= (double)lastTermAdded + currentInterval / 4.0) {
                    termBounds.add(BytesRef.deepCopyOf(term));
                    lastTermAdded = termCount;
                    if (termBounds.size() == 5) {
                        BytesRef minTerm = (BytesRef)termBounds.removeFirst();
                        BytesRef maxTerm = (BytesRef)termBounds.getLast();
                        CheckIndex.checkSingleTermRange(field, maxDoc, terms, minTerm, maxTerm, normalDocs, intersectDocs);
                    }
                }
                ++termCount;
                if (lastTerm == null) {
                    lastTerm = new BytesRefBuilder();
                    lastTerm.copyBytes(term);
                    continue;
                }
                if (lastTerm.get().compareTo(term) >= 0) {
                    throw new RuntimeException("terms out of order: lastTerm=" + lastTerm.get() + " term=" + term);
                }
                lastTerm.copyBytes(term);
            }
            if (lastTerm == null || termBounds.isEmpty()) continue;
            BytesRef minTerm = (BytesRef)termBounds.removeFirst();
            BytesRef maxTerm = lastTerm.get();
            CheckIndex.checkSingleTermRange(field, maxDoc, terms, minTerm, maxTerm, normalDocs, intersectDocs);
        }
    }

    private static Status.TermIndexStatus checkFields(Fields fields, Bits liveDocs, int maxDoc, FieldInfos fieldInfos, boolean doPrint, boolean isVectors, PrintStream infoStream, boolean verbose) throws IOException {
        long startNS = doPrint ? System.nanoTime() : 0L;
        Status.TermIndexStatus status = new Status.TermIndexStatus();
        int computedFieldCount = 0;
        PostingsEnum postings = null;
        String lastField = null;
        for (String field : fields) {
            int i;
            int seekCount;
            long v;
            BytesRef term;
            boolean expectedHasFreqs;
            BytesRef minTerm;
            BytesRef maxTerm;
            if (lastField != null && field.compareTo(lastField) <= 0) {
                throw new RuntimeException("fields out of order: lastField=" + lastField + " field=" + field);
            }
            lastField = field;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
            if (fieldInfo == null) {
                throw new RuntimeException("fieldsEnum inconsistent with fieldInfos, no fieldInfos for: " + field);
            }
            if (fieldInfo.getIndexOptions() == IndexOptions.NONE) {
                throw new RuntimeException("fieldsEnum inconsistent with fieldInfos, isIndexed == false for: " + field);
            }
            ++computedFieldCount;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            boolean hasFreqs = terms.hasFreqs();
            boolean hasPositions = terms.hasPositions();
            boolean hasPayloads = terms.hasPayloads();
            boolean hasOffsets = terms.hasOffsets();
            if (isVectors) {
                maxTerm = null;
                minTerm = null;
            } else {
                BytesRef bb = terms.getMin();
                if (bb != null) {
                    assert (bb.isValid());
                    minTerm = BytesRef.deepCopyOf(bb);
                } else {
                    minTerm = null;
                }
                bb = terms.getMax();
                if (bb != null) {
                    assert (bb.isValid());
                    maxTerm = BytesRef.deepCopyOf(bb);
                    if (minTerm == null) {
                        throw new RuntimeException("field \"" + field + "\" has null minTerm but non-null maxTerm");
                    }
                } else {
                    maxTerm = null;
                    if (minTerm != null) {
                        throw new RuntimeException("field \"" + field + "\" has non-null minTerm but null maxTerm");
                    }
                }
            }
            boolean bl = expectedHasFreqs = isVectors || fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            if (hasFreqs != expectedHasFreqs) {
                throw new RuntimeException("field \"" + field + "\" should have hasFreqs=" + expectedHasFreqs + " but got " + hasFreqs);
            }
            if (!hasFreqs && terms.getSumTotalTermFreq() != -1L) {
                throw new RuntimeException("field \"" + field + "\" hasFreqs is false, but Terms.getSumTotalTermFreq()=" + terms.getSumTotalTermFreq() + " (should be -1)");
            }
            if (!isVectors) {
                boolean expectedHasOffsets;
                boolean expectedHasPositions;
                boolean bl2 = expectedHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                if (hasPositions != expectedHasPositions) {
                    throw new RuntimeException("field \"" + field + "\" should have hasPositions=" + expectedHasPositions + " but got " + hasPositions);
                }
                boolean expectedHasPayloads = fieldInfo.hasPayloads();
                if (hasPayloads != expectedHasPayloads) {
                    throw new RuntimeException("field \"" + field + "\" should have hasPayloads=" + expectedHasPayloads + " but got " + hasPayloads);
                }
                boolean bl3 = expectedHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                if (hasOffsets != expectedHasOffsets) {
                    throw new RuntimeException("field \"" + field + "\" should have hasOffsets=" + expectedHasOffsets + " but got " + hasOffsets);
                }
            }
            TermsEnum termsEnum = terms.iterator();
            boolean hasOrd = true;
            long termCountStart = status.delTermCount + status.termCount;
            BytesRefBuilder lastTerm = null;
            long sumTotalTermFreq = 0L;
            long sumDocFreq = 0L;
            FixedBitSet visitedDocs = new FixedBitSet(maxDoc);
            block3: while ((term = termsEnum.next()) != null) {
                int docID;
                int skipDocID;
                int idx;
                boolean hasTotalTermFreq;
                int doc;
                int docFreq;
                assert (term.isValid());
                if (lastTerm == null) {
                    lastTerm = new BytesRefBuilder();
                    lastTerm.copyBytes(term);
                } else {
                    if (lastTerm.get().compareTo(term) >= 0) {
                        throw new RuntimeException("terms out of order: lastTerm=" + lastTerm.get() + " term=" + term);
                    }
                    lastTerm.copyBytes(term);
                }
                if (!isVectors) {
                    if (minTerm == null) {
                        assert (maxTerm == null);
                        throw new RuntimeException("field=\"" + field + "\": invalid term: term=" + term + ", minTerm=" + minTerm);
                    }
                    if (term.compareTo(minTerm) < 0) {
                        throw new RuntimeException("field=\"" + field + "\": invalid term: term=" + term + ", minTerm=" + minTerm);
                    }
                    if (term.compareTo(maxTerm) > 0) {
                        throw new RuntimeException("field=\"" + field + "\": invalid term: term=" + term + ", maxTerm=" + maxTerm);
                    }
                }
                if ((docFreq = termsEnum.docFreq()) <= 0) {
                    throw new RuntimeException("docfreq: " + docFreq + " is out of bounds");
                }
                sumDocFreq += (long)docFreq;
                postings = termsEnum.postings(postings, 120);
                if (!hasFreqs && termsEnum.totalTermFreq() != -1L) {
                    throw new RuntimeException("field \"" + field + "\" hasFreqs is false, but TermsEnum.totalTermFreq()=" + termsEnum.totalTermFreq() + " (should be -1)");
                }
                if (hasOrd) {
                    long ordExpected;
                    long ord = -1L;
                    try {
                        ord = termsEnum.ord();
                    }
                    catch (UnsupportedOperationException uoe) {
                        hasOrd = false;
                    }
                    if (hasOrd && ord != (ordExpected = status.delTermCount + status.termCount - termCountStart)) {
                        throw new RuntimeException("ord mismatch: TermsEnum has ord=" + ord + " vs actual=" + ordExpected);
                    }
                }
                int lastDoc = -1;
                int docCount = 0;
                boolean hasNonDeletedDocs = false;
                long totalTermFreq = 0L;
                while ((doc = postings.nextDoc()) != Integer.MAX_VALUE) {
                    visitedDocs.set(doc);
                    int freq = -1;
                    if (hasFreqs) {
                        freq = postings.freq();
                        if (freq <= 0) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": freq " + freq + " is out of bounds");
                        }
                        totalTermFreq += (long)freq;
                    } else if (postings.freq() != 1) {
                        throw new RuntimeException("term " + term + ": doc " + doc + ": freq " + freq + " != 1 when Terms.hasFreqs() is false");
                    }
                    if (liveDocs == null || liveDocs.get(doc)) {
                        hasNonDeletedDocs = true;
                        ++status.totFreq;
                        if (freq >= 0) {
                            status.totPos += (long)freq;
                        }
                    }
                    ++docCount;
                    if (doc <= lastDoc) {
                        throw new RuntimeException("term " + term + ": doc " + doc + " <= lastDoc " + lastDoc);
                    }
                    if (doc >= maxDoc) {
                        throw new RuntimeException("term " + term + ": doc " + doc + " >= maxDoc " + maxDoc);
                    }
                    lastDoc = doc;
                    int lastPos = -1;
                    int lastOffset = 0;
                    if (!hasPositions) continue;
                    for (int j = 0; j < freq; ++j) {
                        int pos = postings.nextPosition();
                        if (pos < 0) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " is out of bounds");
                        }
                        if (pos > 0x7FFFFF7F) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " > IndexWriter.MAX_POSITION=" + 0x7FFFFF7F);
                        }
                        if (pos < lastPos) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " < lastPos " + lastPos);
                        }
                        lastPos = pos;
                        BytesRef payload = postings.getPayload();
                        if (payload != null) assert (payload.isValid());
                        if (payload != null && payload.length < 1) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " payload length is out of bounds " + payload.length);
                        }
                        if (!hasOffsets) continue;
                        int startOffset = postings.startOffset();
                        int endOffset = postings.endOffset();
                        if (!isVectors) {
                            if (startOffset < 0) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                            }
                            if (startOffset < lastOffset) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset);
                            }
                            if (endOffset < 0) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                            }
                            if (endOffset < startOffset) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                            }
                        }
                        lastOffset = startOffset;
                    }
                }
                if (hasNonDeletedDocs) {
                    ++status.termCount;
                } else {
                    ++status.delTermCount;
                }
                long totalTermFreq2 = termsEnum.totalTermFreq();
                boolean bl4 = hasTotalTermFreq = hasFreqs && totalTermFreq2 != -1L;
                if (docCount != docFreq) {
                    throw new RuntimeException("term " + term + " docFreq=" + docFreq + " != tot docs w/o deletions " + docCount);
                }
                if (hasTotalTermFreq) {
                    if (totalTermFreq2 <= 0L) {
                        throw new RuntimeException("totalTermFreq: " + totalTermFreq2 + " is out of bounds");
                    }
                    sumTotalTermFreq += totalTermFreq;
                    if (totalTermFreq != totalTermFreq2) {
                        throw new RuntimeException("term " + term + " totalTermFreq=" + totalTermFreq2 + " != recomputed totalTermFreq=" + totalTermFreq);
                    }
                }
                if (hasPositions) {
                    for (idx = 0; idx < 7; ++idx) {
                        skipDocID = (int)((long)(idx + 1) * (long)maxDoc / 8L);
                        docID = (postings = termsEnum.postings(postings, 120)).advance(skipDocID);
                        if (docID == Integer.MAX_VALUE) continue block3;
                        if (docID < skipDocID) {
                            throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                        }
                        int freq = postings.freq();
                        if (freq <= 0) {
                            throw new RuntimeException("termFreq " + freq + " is out of bounds");
                        }
                        int lastPosition = -1;
                        int lastOffset = 0;
                        for (int posUpto = 0; posUpto < freq; ++posUpto) {
                            int pos = postings.nextPosition();
                            if (pos < 0) {
                                throw new RuntimeException("position " + pos + " is out of bounds");
                            }
                            if (pos < lastPosition) {
                                throw new RuntimeException("position " + pos + " is < lastPosition " + lastPosition);
                            }
                            lastPosition = pos;
                            if (!hasOffsets) continue;
                            int startOffset = postings.startOffset();
                            int endOffset = postings.endOffset();
                            if (!isVectors) {
                                if (startOffset < 0) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                                }
                                if (startOffset < lastOffset) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset);
                                }
                                if (endOffset < 0) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                                }
                                if (endOffset < startOffset) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                                }
                            }
                            lastOffset = startOffset;
                        }
                        int nextDocID = postings.nextDoc();
                        if (nextDocID == Integer.MAX_VALUE) continue block3;
                        if (nextDocID <= docID) {
                            throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                        }
                        if (isVectors) continue block3;
                    }
                    continue;
                }
                for (idx = 0; idx < 7; ++idx) {
                    skipDocID = (int)((long)(idx + 1) * (long)maxDoc / 8L);
                    docID = (postings = termsEnum.postings(postings, 0)).advance(skipDocID);
                    if (docID == Integer.MAX_VALUE) continue block3;
                    if (docID < skipDocID) {
                        throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                    }
                    int nextDocID = postings.nextDoc();
                    if (nextDocID == Integer.MAX_VALUE) continue block3;
                    if (nextDocID <= docID) {
                        throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                    }
                    if (isVectors) continue block3;
                }
            }
            if (minTerm != null && status.termCount + status.delTermCount == 0L) {
                throw new RuntimeException("field=\"" + field + "\": minTerm is non-null yet we saw no terms: " + minTerm);
            }
            Terms fieldTerms = fields.terms(field);
            if (fieldTerms == null) continue;
            long fieldTermCount = status.delTermCount + status.termCount - termCountStart;
            Object stats = fieldTerms.getStats();
            assert (stats != null);
            if (status.blockTreeStats == null) {
                status.blockTreeStats = new HashMap<String, Object>();
            }
            status.blockTreeStats.put(field, stats);
            if (sumTotalTermFreq != 0L && (v = fields.terms(field).getSumTotalTermFreq()) != -1L && sumTotalTermFreq != v) {
                throw new RuntimeException("sumTotalTermFreq for field " + field + "=" + v + " != recomputed sumTotalTermFreq=" + sumTotalTermFreq);
            }
            if (sumDocFreq != 0L && (v = fields.terms(field).getSumDocFreq()) != -1L && sumDocFreq != v) {
                throw new RuntimeException("sumDocFreq for field " + field + "=" + v + " != recomputed sumDocFreq=" + sumDocFreq);
            }
            int v2 = fieldTerms.getDocCount();
            if (v2 != -1 && visitedDocs.cardinality() != v2) {
                throw new RuntimeException("docCount for field " + field + "=" + v2 + " != recomputed docCount=" + visitedDocs.cardinality());
            }
            if (lastTerm != null) {
                if (termsEnum.seekCeil(lastTerm.get()) != TermsEnum.SeekStatus.FOUND) {
                    throw new RuntimeException("seek to last term " + lastTerm.get() + " failed");
                }
                if (!termsEnum.term().equals(lastTerm.get())) {
                    throw new RuntimeException("seek to last term " + lastTerm.get() + " returned FOUND but seeked to the wrong term " + termsEnum.term());
                }
                int expectedDocFreq = termsEnum.docFreq();
                PostingsEnum d = termsEnum.postings(null, 0);
                int docFreq = 0;
                while (d.nextDoc() != Integer.MAX_VALUE) {
                    ++docFreq;
                }
                if (docFreq != expectedDocFreq) {
                    throw new RuntimeException("docFreq for last term " + lastTerm.get() + "=" + expectedDocFreq + " != recomputed docFreq=" + docFreq);
                }
            }
            long termCount = -1L;
            if (fieldTermCount > 0L && (termCount = fields.terms(field).size()) != -1L && termCount != fieldTermCount) {
                throw new RuntimeException("termCount mismatch " + termCount + " vs " + fieldTermCount);
            }
            if (!hasOrd || status.termCount - termCountStart <= 0L || (seekCount = (int)Math.min(10000L, termCount)) <= 0) continue;
            BytesRef[] seekTerms = new BytesRef[seekCount];
            for (i = seekCount - 1; i >= 0; --i) {
                long ord = (long)i * (termCount / (long)seekCount);
                termsEnum.seekExact(ord);
                long actualOrd = termsEnum.ord();
                if (actualOrd != ord) {
                    throw new RuntimeException("seek to ord " + ord + " returned ord " + actualOrd);
                }
                seekTerms[i] = BytesRef.deepCopyOf(termsEnum.term());
            }
            for (i = seekCount - 1; i >= 0; --i) {
                if (termsEnum.seekCeil(seekTerms[i]) != TermsEnum.SeekStatus.FOUND) {
                    throw new RuntimeException("seek to existing term " + seekTerms[i] + " failed");
                }
                if (!termsEnum.term().equals(seekTerms[i])) {
                    throw new RuntimeException("seek to existing term " + seekTerms[i] + " returned FOUND but seeked to the wrong term " + termsEnum.term());
                }
                if ((postings = termsEnum.postings(postings, 0)) != null) continue;
                throw new RuntimeException("null DocsEnum from to existing term " + seekTerms[i]);
            }
        }
        int fieldCount = fields.size();
        if (fieldCount != -1) {
            if (fieldCount < 0) {
                throw new RuntimeException("invalid fieldCount: " + fieldCount);
            }
            if (fieldCount != computedFieldCount) {
                throw new RuntimeException("fieldCount mismatch " + fieldCount + " vs recomputed field count " + computedFieldCount);
            }
        }
        if (doPrint) {
            CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d terms; %d terms/docs pairs; %d tokens] [took %.3f sec]", status.termCount, status.totFreq, status.totPos, CheckIndex.nsToSec(System.nanoTime() - startNS)));
        }
        if (verbose && status.blockTreeStats != null && infoStream != null && status.termCount > 0L) {
            for (Map.Entry<String, Object> ent : status.blockTreeStats.entrySet()) {
                infoStream.println("      field \"" + ent.getKey() + "\":");
                infoStream.println("      " + ent.getValue().toString().replace("\n", "\n      "));
            }
        }
        return status;
    }

    public static Status.TermIndexStatus testPostings(CodecReader reader, PrintStream infoStream) throws IOException {
        return CheckIndex.testPostings(reader, infoStream, false, false);
    }

    public static Status.TermIndexStatus testPostings(CodecReader reader, PrintStream infoStream, boolean verbose, boolean failFast) throws IOException {
        Status.TermIndexStatus status;
        block4: {
            int maxDoc = reader.maxDoc();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: terms, freq, prox...");
                }
                FieldsProducer fields = reader.getPostingsReader().getMergeInstance();
                FieldInfos fieldInfos = reader.getFieldInfos();
                status = CheckIndex.checkFields(fields, reader.getLiveDocs(), maxDoc, fieldInfos, true, false, infoStream, verbose);
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR: " + e);
                status = new Status.TermIndexStatus();
                status.error = e;
                if (infoStream == null) break block4;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.PointsStatus testPoints(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.PointsStatus status;
        block12: {
            if (infoStream != null) {
                infoStream.print("    test: points..............");
            }
            long startNS = System.nanoTime();
            FieldInfos fieldInfos = reader.getFieldInfos();
            status = new Status.PointsStatus();
            try {
                if (fieldInfos.hasPointValues()) {
                    PointsReader values = reader.getPointsReader();
                    if (values == null) {
                        throw new RuntimeException("there are fields with points, but reader.getPointsReader() is null");
                    }
                    for (FieldInfo fieldInfo : fieldInfos) {
                        if (fieldInfo.getPointDimensionCount() <= 0) continue;
                        ++status.totalValueFields;
                        long size = values.size(fieldInfo.name);
                        int docCount = values.getDocCount(fieldInfo.name);
                        long crossCost = values.estimatePointCount(fieldInfo.name, new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_CROSSES_QUERY));
                        if (crossCost < size / 2L) {
                            throw new RuntimeException("estimatePointCount should return >= size/2 when all cells match");
                        }
                        long insideCost = values.estimatePointCount(fieldInfo.name, new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_INSIDE_QUERY));
                        if (insideCost < size) {
                            throw new RuntimeException("estimatePointCount should return >= size when all cells fully match");
                        }
                        long outsideCost = values.estimatePointCount(fieldInfo.name, new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_OUTSIDE_QUERY));
                        if (outsideCost != 0L) {
                            throw new RuntimeException("estimatePointCount should return 0 when no cells match");
                        }
                        VerifyPointsVisitor visitor = new VerifyPointsVisitor(fieldInfo.name, reader.maxDoc(), values);
                        values.intersect(fieldInfo.name, visitor);
                        if (visitor.getPointCountSeen() != size) {
                            throw new RuntimeException("point values for field \"" + fieldInfo.name + "\" claims to have size=" + size + " points, but in fact has " + visitor.getPointCountSeen());
                        }
                        if (visitor.getDocCountSeen() != (long)docCount) {
                            throw new RuntimeException("point values for field \"" + fieldInfo.name + "\" claims to have docCount=" + docCount + " but in fact has " + visitor.getDocCountSeen());
                        }
                        status.totalValuePoints += visitor.getPointCountSeen();
                    }
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d fields, %d points] [took %.3f sec]", status.totalValueFields, status.totalValuePoints, CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR: " + e);
                status.error = e;
                if (infoStream == null) break block12;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.StoredFieldStatus testStoredFields(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.StoredFieldStatus status;
        block6: {
            long startNS = System.nanoTime();
            status = new Status.StoredFieldStatus();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: stored fields.......");
                }
                Bits liveDocs = reader.getLiveDocs();
                StoredFieldsReader storedFields = reader.getFieldsReader().getMergeInstance();
                for (int j = 0; j < reader.maxDoc(); ++j) {
                    DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
                    storedFields.visitDocument(j, visitor);
                    Document doc = visitor.getDocument();
                    if (liveDocs != null && !liveDocs.get(j)) continue;
                    ++status.docCount;
                    status.totFields += (long)doc.getFields().size();
                }
                if (status.docCount != reader.numDocs()) {
                    throw new RuntimeException("docCount=" + status.docCount + " but saw " + status.docCount + " undeleted docs");
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d total field count; avg %.1f fields per doc] [took %.3f sec]", status.totFields, Float.valueOf((float)status.totFields / (float)status.docCount), CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block6;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.DocValuesStatus testDocValues(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.DocValuesStatus status;
        block6: {
            long startNS = System.nanoTime();
            status = new Status.DocValuesStatus();
            try {
                DocValuesProducer dvReader;
                if (infoStream != null) {
                    infoStream.print("    test: docvalues...........");
                }
                if ((dvReader = reader.getDocValuesReader()) != null) {
                    dvReader = dvReader.getMergeInstance();
                }
                for (FieldInfo fieldInfo : reader.getFieldInfos()) {
                    if (fieldInfo.getDocValuesType() == DocValuesType.NONE) continue;
                    ++status.totalValueFields;
                    CheckIndex.checkDocValues(fieldInfo, dvReader, reader.maxDoc(), infoStream, status);
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d docvalues fields; %d BINARY; %d NUMERIC; %d SORTED; %d SORTED_NUMERIC; %d SORTED_SET] [took %.3f sec]", status.totalValueFields, status.totalBinaryFields, status.totalNumericFields, status.totalSortedFields, status.totalSortedNumericFields, status.totalSortedSetFields, CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block6;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    private static void checkBinaryDocValues(String fieldName, int maxDoc, BinaryDocValues dv, Bits docsWithField) {
        for (int i = 0; i < maxDoc; ++i) {
            BytesRef term = dv.get(i);
            assert (term.isValid());
            if (docsWithField.get(i) || term.length <= 0) continue;
            throw new RuntimeException("dv for field: " + fieldName + " is missing but has value=" + term + " for doc: " + i);
        }
    }

    private static void checkSortedDocValues(String fieldName, int maxDoc, SortedDocValues dv, Bits docsWithField) {
        CheckIndex.checkBinaryDocValues(fieldName, maxDoc, dv, docsWithField);
        int maxOrd = dv.getValueCount() - 1;
        FixedBitSet seenOrds = new FixedBitSet(dv.getValueCount());
        int maxOrd2 = -1;
        for (int i = 0; i < maxDoc; ++i) {
            int ord = dv.getOrd(i);
            if (ord == -1) {
                if (!docsWithField.get(i)) continue;
                throw new RuntimeException("dv for field: " + fieldName + " has -1 ord but is not marked missing for doc: " + i);
            }
            if (ord < -1 || ord > maxOrd) {
                throw new RuntimeException("ord out of bounds: " + ord);
            }
            if (!docsWithField.get(i)) {
                throw new RuntimeException("dv for field: " + fieldName + " is missing but has ord=" + ord + " for doc: " + i);
            }
            maxOrd2 = Math.max(maxOrd2, ord);
            seenOrds.set(ord);
        }
        if (maxOrd != maxOrd2) {
            throw new RuntimeException("dv for field: " + fieldName + " reports wrong maxOrd=" + maxOrd + " but this is not the case: " + maxOrd2);
        }
        if (seenOrds.cardinality() != dv.getValueCount()) {
            throw new RuntimeException("dv for field: " + fieldName + " has holes in its ords, valueCount=" + dv.getValueCount() + " but only used: " + seenOrds.cardinality());
        }
        BytesRef lastValue = null;
        for (int i = 0; i <= maxOrd; ++i) {
            BytesRef term = dv.lookupOrd(i);
            assert (term.isValid());
            if (lastValue != null && term.compareTo(lastValue) <= 0) {
                throw new RuntimeException("dv for field: " + fieldName + " has ords out of order: " + lastValue + " >=" + term);
            }
            lastValue = BytesRef.deepCopyOf(term);
        }
    }

    private static void checkSortedSetDocValues(String fieldName, int maxDoc, SortedSetDocValues dv, Bits docsWithField) {
        long maxOrd = dv.getValueCount() - 1L;
        LongBitSet seenOrds = new LongBitSet(dv.getValueCount());
        long maxOrd2 = -1L;
        for (int i = 0; i < maxDoc; ++i) {
            long ordCount2;
            dv.setDocument(i);
            long lastOrd = -1L;
            if (docsWithField.get(i)) {
                long ordCount22;
                long ord;
                int ordCount = 0;
                while ((ord = dv.nextOrd()) != -1L) {
                    long ord2;
                    if (ord <= lastOrd) {
                        throw new RuntimeException("ords out of order: " + ord + " <= " + lastOrd + " for doc: " + i);
                    }
                    if (ord < 0L || ord > maxOrd) {
                        throw new RuntimeException("ord out of bounds: " + ord);
                    }
                    if (dv instanceof RandomAccessOrds && ord != (ord2 = ((RandomAccessOrds)dv).ordAt(ordCount))) {
                        throw new RuntimeException("ordAt(" + ordCount + ") inconsistent, expected=" + ord + ",got=" + ord2 + " for doc: " + i);
                    }
                    lastOrd = ord;
                    maxOrd2 = Math.max(maxOrd2, ord);
                    seenOrds.set(ord);
                    ++ordCount;
                }
                if (ordCount == 0) {
                    throw new RuntimeException("dv for field: " + fieldName + " has no ordinals but is not marked missing for doc: " + i);
                }
                if (!(dv instanceof RandomAccessOrds) || (long)ordCount == (ordCount22 = (long)((RandomAccessOrds)dv).cardinality())) continue;
                throw new RuntimeException("cardinality inconsistent, expected=" + ordCount + ",got=" + ordCount22 + " for doc: " + i);
            }
            long o = dv.nextOrd();
            if (o != -1L) {
                throw new RuntimeException("dv for field: " + fieldName + " is marked missing but has ord=" + o + " for doc: " + i);
            }
            if (!(dv instanceof RandomAccessOrds) || (ordCount2 = (long)((RandomAccessOrds)dv).cardinality()) == 0L) continue;
            throw new RuntimeException("dv for field: " + fieldName + " is marked missing but has cardinality " + ordCount2 + " for doc: " + i);
        }
        if (maxOrd != maxOrd2) {
            throw new RuntimeException("dv for field: " + fieldName + " reports wrong maxOrd=" + maxOrd + " but this is not the case: " + maxOrd2);
        }
        if (seenOrds.cardinality() != dv.getValueCount()) {
            throw new RuntimeException("dv for field: " + fieldName + " has holes in its ords, valueCount=" + dv.getValueCount() + " but only used: " + seenOrds.cardinality());
        }
        BytesRef lastValue = null;
        for (long i = 0L; i <= maxOrd; ++i) {
            BytesRef term = dv.lookupOrd(i);
            assert (term.isValid());
            if (lastValue != null && term.compareTo(lastValue) <= 0) {
                throw new RuntimeException("dv for field: " + fieldName + " has ords out of order: " + lastValue + " >=" + term);
            }
            lastValue = BytesRef.deepCopyOf(term);
        }
    }

    private static void checkSortedNumericDocValues(String fieldName, int maxDoc, SortedNumericDocValues ndv, Bits docsWithField) {
        for (int i = 0; i < maxDoc; ++i) {
            ndv.setDocument(i);
            int count = ndv.count();
            if (docsWithField.get(i)) {
                if (count == 0) {
                    throw new RuntimeException("dv for field: " + fieldName + " is not marked missing but has zero count for doc: " + i);
                }
                long previous = Long.MIN_VALUE;
                for (int j = 0; j < count; ++j) {
                    long value = ndv.valueAt(j);
                    if (value < previous) {
                        throw new RuntimeException("values out of order: " + value + " < " + previous + " for doc: " + i);
                    }
                    previous = value;
                }
                continue;
            }
            if (count == 0) continue;
            throw new RuntimeException("dv for field: " + fieldName + " is marked missing but has count=" + count + " for doc: " + i);
        }
    }

    private static void checkNumericDocValues(String fieldName, int maxDoc, NumericDocValues ndv, Bits docsWithField) {
        for (int i = 0; i < maxDoc; ++i) {
            long value = ndv.get(i);
            if (docsWithField.get(i) || value == 0L) continue;
            throw new RuntimeException("dv for field: " + fieldName + " is marked missing but has value=" + value + " for doc: " + i);
        }
    }

    private static void checkDocValues(FieldInfo fi, DocValuesProducer dvReader, int maxDoc, PrintStream infoStream, Status.DocValuesStatus status) throws Exception {
        Bits docsWithField = dvReader.getDocsWithField(fi);
        if (docsWithField == null) {
            throw new RuntimeException(fi.name + " docsWithField does not exist");
        }
        if (docsWithField.length() != maxDoc) {
            throw new RuntimeException(fi.name + " docsWithField has incorrect length: " + docsWithField.length() + ",expected: " + maxDoc);
        }
        switch (fi.getDocValuesType()) {
            case SORTED: {
                ++status.totalSortedFields;
                CheckIndex.checkSortedDocValues(fi.name, maxDoc, dvReader.getSorted(fi), docsWithField);
                break;
            }
            case SORTED_NUMERIC: {
                ++status.totalSortedNumericFields;
                CheckIndex.checkSortedNumericDocValues(fi.name, maxDoc, dvReader.getSortedNumeric(fi), docsWithField);
                break;
            }
            case SORTED_SET: {
                ++status.totalSortedSetFields;
                CheckIndex.checkSortedSetDocValues(fi.name, maxDoc, dvReader.getSortedSet(fi), docsWithField);
                break;
            }
            case BINARY: {
                ++status.totalBinaryFields;
                CheckIndex.checkBinaryDocValues(fi.name, maxDoc, dvReader.getBinary(fi), docsWithField);
                break;
            }
            case NUMERIC: {
                ++status.totalNumericFields;
                CheckIndex.checkNumericDocValues(fi.name, maxDoc, dvReader.getNumeric(fi), docsWithField);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static Status.TermVectorStatus testTermVectors(CodecReader reader, PrintStream infoStream) throws IOException {
        return CheckIndex.testTermVectors(reader, infoStream, false, false, false);
    }

    public static Status.TermVectorStatus testTermVectors(CodecReader reader, PrintStream infoStream, boolean verbose, boolean crossCheckTermVectors, boolean failFast) throws IOException {
        Status.TermVectorStatus status;
        block27: {
            long startNS = System.nanoTime();
            status = new Status.TermVectorStatus();
            FieldInfos fieldInfos = reader.getFieldInfos();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: term vectors........");
                }
                PostingsEnum postings = null;
                PostingsEnum postingsDocs = null;
                Bits liveDocs = reader.getLiveDocs();
                FieldsProducer postingsFields = crossCheckTermVectors ? reader.getPostingsReader().getMergeInstance() : null;
                TermVectorsReader vectorsReader = reader.getTermVectorsReader();
                if (vectorsReader != null) {
                    vectorsReader = vectorsReader.getMergeInstance();
                    for (int j = 0; j < reader.maxDoc(); ++j) {
                        boolean doStats;
                        Fields tfv = vectorsReader.get(j);
                        if (tfv == null) continue;
                        CheckIndex.checkFields(tfv, null, 1, fieldInfos, false, true, infoStream, verbose);
                        boolean bl = doStats = liveDocs == null || liveDocs.get(j);
                        if (doStats) {
                            ++status.docCount;
                        }
                        for (String field : tfv) {
                            FieldInfo fieldInfo;
                            if (doStats) {
                                ++status.totVectors;
                            }
                            if (!(fieldInfo = fieldInfos.fieldInfo(field)).hasVectors()) {
                                throw new RuntimeException("docID=" + j + " has term vectors for field=" + field + " but FieldInfo has storeTermVector=false");
                            }
                            if (!crossCheckTermVectors) continue;
                            Terms terms = tfv.terms(field);
                            TermsEnum termsEnum = terms.iterator();
                            boolean postingsHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
                            boolean postingsHasPayload = fieldInfo.hasPayloads();
                            boolean vectorsHasPayload = terms.hasPayloads();
                            Terms postingsTerms = postingsFields.terms(field);
                            if (postingsTerms == null) {
                                throw new RuntimeException("vector field=" + field + " does not exist in postings; doc=" + j);
                            }
                            TermsEnum postingsTermsEnum = postingsTerms.iterator();
                            boolean hasProx = terms.hasOffsets() || terms.hasPositions();
                            BytesRef term = null;
                            while ((term = termsEnum.next()) != null) {
                                postings = termsEnum.postings(postings, 120);
                                assert (postings != null);
                                if (!postingsTermsEnum.seekExact(term)) {
                                    throw new RuntimeException("vector term=" + term + " field=" + field + " does not exist in postings; doc=" + j);
                                }
                                postingsDocs = postingsTermsEnum.postings(postingsDocs, 120);
                                assert (postingsDocs != null);
                                int advanceDoc = postingsDocs.advance(j);
                                if (advanceDoc != j) {
                                    throw new RuntimeException("vector term=" + term + " field=" + field + ": doc=" + j + " was not found in postings (got: " + advanceDoc + ")");
                                }
                                int doc = postings.nextDoc();
                                if (doc != 0) {
                                    throw new RuntimeException("vector for doc " + j + " didn't return docID=0: got docID=" + doc);
                                }
                                if (!postingsHasFreq) continue;
                                int tf = postings.freq();
                                if (postingsHasFreq && postingsDocs.freq() != tf) {
                                    throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": freq=" + tf + " differs from postings freq=" + postingsDocs.freq());
                                }
                                if (!hasProx) continue;
                                for (int i = 0; i < tf; ++i) {
                                    BytesRef payload;
                                    int pos = postings.nextPosition();
                                    if (postingsTerms.hasPositions()) {
                                        int postingsPos = postingsDocs.nextPosition();
                                        if (terms.hasPositions() && pos != postingsPos) {
                                            throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": pos=" + pos + " differs from postings pos=" + postingsPos);
                                        }
                                    }
                                    int startOffset = postings.startOffset();
                                    int endOffset = postings.endOffset();
                                    if (startOffset != -1 && endOffset != -1 && postingsTerms.hasOffsets()) {
                                        int postingsStartOffset = postingsDocs.startOffset();
                                        int postingsEndOffset = postingsDocs.endOffset();
                                        if (startOffset != postingsStartOffset) {
                                            throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": startOffset=" + startOffset + " differs from postings startOffset=" + postingsStartOffset);
                                        }
                                        if (endOffset != postingsEndOffset) {
                                            throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": endOffset=" + endOffset + " differs from postings endOffset=" + postingsEndOffset);
                                        }
                                    }
                                    if ((payload = postings.getPayload()) != null) assert (vectorsHasPayload);
                                    if (!postingsHasPayload || !vectorsHasPayload) continue;
                                    if (payload == null) {
                                        if (postingsDocs.getPayload() == null) continue;
                                        throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + " has no payload but postings does: " + postingsDocs.getPayload());
                                    }
                                    if (postingsDocs.getPayload() == null) {
                                        throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + " has payload=" + payload + " but postings does not.");
                                    }
                                    BytesRef postingsPayload = postingsDocs.getPayload();
                                    if (payload.equals(postingsPayload)) continue;
                                    throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + " has payload=" + payload + " but differs from postings payload=" + postingsPayload);
                                }
                            }
                        }
                    }
                }
                float vectorAvg = status.docCount == 0 ? 0.0f : (float)status.totVectors / (float)status.docCount;
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d total term vector count; avg %.1f term/freq vector fields per doc] [took %.3f sec]", status.totVectors, Float.valueOf(vectorAvg), CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block27;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public void exorciseIndex(Status result) throws IOException {
        this.ensureOpen();
        if (result.partial) {
            throw new IllegalArgumentException("can only exorcise an index that was fully checked (this status checked a subset of segments)");
        }
        result.newSegments.changed();
        result.newSegments.commit(result.dir);
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    public static boolean assertsOn() {
        assert (CheckIndex.testAsserts());
        return assertsOn;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        int exitCode = CheckIndex.doMain(args);
        System.exit(exitCode);
    }

    /*
     * Exception decompiling
     */
    @SuppressForbidden(reason="System.out required: command line tool")
    private static int doMain(String[] args) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Options parseOptions(String[] args) {
        Options opts = new Options();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-fast".equals(arg)) {
                opts.doChecksumsOnly = true;
                continue;
            }
            if ("-exorcise".equals(arg)) {
                opts.doExorcise = true;
                continue;
            }
            if ("-crossCheckTermVectors".equals(arg)) {
                opts.doCrossCheckTermVectors = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                opts.verbose = true;
                continue;
            }
            if (arg.equals("-segment")) {
                if (i == args.length - 1) {
                    throw new IllegalArgumentException("ERROR: missing name for -segment option");
                }
                opts.onlySegments.add(args[++i]);
                continue;
            }
            if ("-dir-impl".equals(arg)) {
                if (i == args.length - 1) {
                    throw new IllegalArgumentException("ERROR: missing value for -dir-impl option");
                }
                opts.dirImpl = args[++i];
                continue;
            }
            if (opts.indexPath != null) {
                throw new IllegalArgumentException("ERROR: unexpected extra argument '" + args[i] + "'");
            }
            opts.indexPath = args[i];
        }
        if (opts.indexPath == null) {
            throw new IllegalArgumentException("\nERROR: index path not specified\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-exorcise] [-crossCheckTermVectors] [-segment X] [-segment Y] [-dir-impl X]\n\n  -exorcise: actually write a new segments_N file, removing any problematic segments\n  -fast: just verify file checksums, omitting logical integrity checks\n  -crossCheckTermVectors: verifies that term vectors match postings; THIS IS VERY SLOW!\n  -codec X: when exorcising, codec to write the new segments_N file with\n  -verbose: print additional details\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -exorcise option\n  -dir-impl X: use a specific " + FSDirectory.class.getSimpleName() + " implementation. If no package is specified the " + FSDirectory.class.getPackage().getName() + " package will be used.\n\n**WARNING**: -exorcise *LOSES DATA*. This should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -exorcise, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -exorcise were\nspecified.  With -exorcise, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has any\ncorruption, else 0.\n");
        }
        if (opts.onlySegments.size() == 0) {
            opts.onlySegments = null;
        } else if (opts.doExorcise) {
            throw new IllegalArgumentException("ERROR: cannot specify both -exorcise and -segment");
        }
        if (opts.doChecksumsOnly && opts.doCrossCheckTermVectors) {
            throw new IllegalArgumentException("ERROR: cannot specify both -fast and -crossCheckTermVectors");
        }
        return opts;
    }

    public int doCheck(Options opts) throws IOException, InterruptedException {
        this.setCrossCheckTermVectors(opts.doCrossCheckTermVectors);
        this.setChecksumsOnly(opts.doChecksumsOnly);
        this.setInfoStream(opts.out, opts.verbose);
        Status result = this.checkIndex(opts.onlySegments);
        if (result.missingSegments) {
            return 1;
        }
        if (!result.clean) {
            if (!opts.doExorcise) {
                opts.out.println("WARNING: would write new segments file, and " + result.totLoseDocCount + " documents would be lost, if -exorcise were specified\n");
            } else {
                opts.out.println("WARNING: " + result.totLoseDocCount + " documents will be lost\n");
                opts.out.println("NOTE: will write new segments file in 5 seconds; this will remove " + result.totLoseDocCount + " docs from the index. YOU WILL LOSE DATA. THIS IS YOUR LAST CHANCE TO CTRL+C!");
                for (int s = 0; s < 5; ++s) {
                    Thread.sleep(1000L);
                    opts.out.println("  " + (5 - s) + "...");
                }
                opts.out.println("Writing...");
                this.exorciseIndex(result);
                opts.out.println("OK");
                opts.out.println("Wrote new segments file \"" + result.newSegments.getSegmentsFileName() + "\"");
            }
        }
        opts.out.println("");
        if (result.clean) {
            return 0;
        }
        return 1;
    }

    private static double nsToSec(long ns) {
        return (double)ns / 1.0E9;
    }

    public static class Options {
        boolean doExorcise = false;
        boolean doCrossCheckTermVectors = false;
        boolean verbose = false;
        boolean doChecksumsOnly = false;
        List<String> onlySegments = new ArrayList<String>();
        String indexPath = null;
        String dirImpl = null;
        PrintStream out = null;

        public String getDirImpl() {
            return this.dirImpl;
        }

        public String getIndexPath() {
            return this.indexPath;
        }

        public void setOut(PrintStream out) {
            this.out = out;
        }
    }

    private static class ConstantRelationIntersectVisitor
    implements PointValues.IntersectVisitor {
        private final PointValues.Relation relation;

        ConstantRelationIntersectVisitor(PointValues.Relation relation) {
            this.relation = relation;
        }

        @Override
        public void visit(int docID) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            return this.relation;
        }
    }

    public static class VerifyPointsVisitor
    implements PointValues.IntersectVisitor {
        private long pointCountSeen;
        private int lastDocID = -1;
        private final int maxDoc;
        private final FixedBitSet docsSeen;
        private final byte[] lastMinPackedValue;
        private final byte[] lastMaxPackedValue;
        private final byte[] lastPackedValue;
        private final byte[] globalMinPackedValue;
        private final byte[] globalMaxPackedValue;
        private final int packedBytesCount;
        private final int numDims;
        private final int bytesPerDim;
        private final String fieldName;

        public VerifyPointsVisitor(String fieldName, int maxDoc, PointValues values) throws IOException {
            this.maxDoc = maxDoc;
            this.fieldName = fieldName;
            this.numDims = values.getNumDimensions(fieldName);
            this.bytesPerDim = values.getBytesPerDimension(fieldName);
            this.packedBytesCount = this.numDims * this.bytesPerDim;
            this.globalMinPackedValue = values.getMinPackedValue(fieldName);
            this.globalMaxPackedValue = values.getMaxPackedValue(fieldName);
            this.docsSeen = new FixedBitSet(maxDoc);
            this.lastMinPackedValue = new byte[this.packedBytesCount];
            this.lastMaxPackedValue = new byte[this.packedBytesCount];
            this.lastPackedValue = new byte[this.packedBytesCount];
            if ((long)values.getDocCount(fieldName) > values.size(fieldName)) {
                throw new RuntimeException("point values for field \"" + fieldName + "\" claims to have size=" + values.size(fieldName) + " points and inconsistent docCount=" + values.getDocCount(fieldName));
            }
            if (values.getDocCount(fieldName) > maxDoc) {
                throw new RuntimeException("point values for field \"" + fieldName + "\" claims to have docCount=" + values.getDocCount(fieldName) + " but that's greater than maxDoc=" + maxDoc);
            }
            if (this.globalMinPackedValue == null) {
                if (values.size(fieldName) != 0L) {
                    throw new RuntimeException("getMinPackedValue is null points for field \"" + fieldName + "\" yet size=" + values.size(fieldName));
                }
            } else if (this.globalMinPackedValue.length != this.packedBytesCount) {
                throw new RuntimeException("getMinPackedValue for field \"" + fieldName + "\" return length=" + this.globalMinPackedValue.length + " array, but should be " + this.packedBytesCount);
            }
            if (this.globalMaxPackedValue == null) {
                if (values.size(fieldName) != 0L) {
                    throw new RuntimeException("getMaxPackedValue is null points for field \"" + fieldName + "\" yet size=" + values.size(fieldName));
                }
            } else if (this.globalMaxPackedValue.length != this.packedBytesCount) {
                throw new RuntimeException("getMaxPackedValue for field \"" + fieldName + "\" return length=" + this.globalMaxPackedValue.length + " array, but should be " + this.packedBytesCount);
            }
        }

        public long getPointCountSeen() {
            return this.pointCountSeen;
        }

        public long getDocCountSeen() {
            return this.docsSeen.cardinality();
        }

        @Override
        public void visit(int docID) {
            throw new RuntimeException("codec called IntersectVisitor.visit without a packed value for docID=" + docID);
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            this.checkPackedValue("packed value", packedValue, docID);
            ++this.pointCountSeen;
            this.docsSeen.set(docID);
            for (int dim = 0; dim < this.numDims; ++dim) {
                int offset = this.bytesPerDim * dim;
                if (StringHelper.compare(this.bytesPerDim, packedValue, offset, this.lastMinPackedValue, offset) < 0) {
                    throw new RuntimeException("packed points value " + Arrays.toString(packedValue) + " for field=\"" + this.fieldName + "\", docID=" + docID + " is out-of-bounds of the last cell min=" + Arrays.toString(this.lastMinPackedValue) + " max=" + Arrays.toString(this.lastMaxPackedValue) + " dim=" + dim);
                }
                if (StringHelper.compare(this.bytesPerDim, packedValue, offset, this.lastMaxPackedValue, offset) <= 0) continue;
                throw new RuntimeException("packed points value " + Arrays.toString(packedValue) + " for field=\"" + this.fieldName + "\", docID=" + docID + " is out-of-bounds of the last cell min=" + Arrays.toString(this.lastMinPackedValue) + " max=" + Arrays.toString(this.lastMaxPackedValue) + " dim=" + dim);
            }
            if (this.numDims == 1) {
                int cmp = StringHelper.compare(this.bytesPerDim, this.lastPackedValue, 0, packedValue, 0);
                if (cmp > 0) {
                    throw new RuntimeException("packed points value " + Arrays.toString(packedValue) + " for field=\"" + this.fieldName + "\", for docID=" + docID + " is out-of-order vs the previous document's value " + Arrays.toString(this.lastPackedValue));
                }
                if (cmp == 0 && docID < this.lastDocID) {
                    throw new RuntimeException("packed points value is the same, but docID=" + docID + " is out of order vs previous docID=" + this.lastDocID + ", field=\"" + this.fieldName + "\"");
                }
                System.arraycopy(packedValue, 0, this.lastPackedValue, 0, this.bytesPerDim);
                this.lastDocID = docID;
            }
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.checkPackedValue("min packed value", minPackedValue, -1);
            System.arraycopy(minPackedValue, 0, this.lastMinPackedValue, 0, this.packedBytesCount);
            this.checkPackedValue("max packed value", maxPackedValue, -1);
            System.arraycopy(maxPackedValue, 0, this.lastMaxPackedValue, 0, this.packedBytesCount);
            for (int dim = 0; dim < this.numDims; ++dim) {
                int offset = this.bytesPerDim * dim;
                if (StringHelper.compare(this.bytesPerDim, minPackedValue, offset, maxPackedValue, offset) > 0) {
                    throw new RuntimeException("packed points cell minPackedValue " + Arrays.toString(minPackedValue) + " is out-of-bounds of the cell's maxPackedValue " + Arrays.toString(maxPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (StringHelper.compare(this.bytesPerDim, minPackedValue, offset, this.globalMinPackedValue, offset) < 0) {
                    throw new RuntimeException("packed points cell minPackedValue " + Arrays.toString(minPackedValue) + " is out-of-bounds of the global minimum " + Arrays.toString(this.globalMinPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (StringHelper.compare(this.bytesPerDim, maxPackedValue, offset, this.globalMinPackedValue, offset) < 0) {
                    throw new RuntimeException("packed points cell maxPackedValue " + Arrays.toString(maxPackedValue) + " is out-of-bounds of the global minimum " + Arrays.toString(this.globalMinPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (StringHelper.compare(this.bytesPerDim, minPackedValue, offset, this.globalMaxPackedValue, offset) > 0) {
                    throw new RuntimeException("packed points cell minPackedValue " + Arrays.toString(minPackedValue) + " is out-of-bounds of the global maximum " + Arrays.toString(this.globalMaxPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (StringHelper.compare(this.bytesPerDim, maxPackedValue, offset, this.globalMaxPackedValue, offset) <= 0) continue;
                throw new RuntimeException("packed points cell maxPackedValue " + Arrays.toString(maxPackedValue) + " is out-of-bounds of the global maximum " + Arrays.toString(this.globalMaxPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private void checkPackedValue(String desc, byte[] packedValue, int docID) {
            if (packedValue == null) {
                throw new RuntimeException(desc + " is null for docID=" + docID + " field=\"" + this.fieldName + "\"");
            }
            if (packedValue.length != this.packedBytesCount) {
                throw new RuntimeException(desc + " has incorrect length=" + packedValue.length + " vs expected=" + this.packedBytesCount + " for docID=" + docID + " field=\"" + this.fieldName + "\"");
            }
        }
    }

    public static class Status {
        public boolean clean;
        public boolean missingSegments;
        public boolean cantOpenSegments;
        public boolean missingSegmentVersion;
        public String segmentsFileName;
        public int numSegments;
        public List<String> segmentsChecked = new ArrayList<String>();
        public boolean toolOutOfDate;
        public List<SegmentInfoStatus> segmentInfos = new ArrayList<SegmentInfoStatus>();
        public Directory dir;
        SegmentInfos newSegments;
        public int totLoseDocCount;
        public int numBadSegments;
        public boolean partial;
        public int maxSegmentName;
        public boolean validCounter;
        public Map<String, String> userData;

        Status() {
        }

        public static final class IndexSortStatus {
            public Throwable error = null;

            IndexSortStatus() {
            }
        }

        public static final class PointsStatus {
            public long totalValuePoints;
            public int totalValueFields;
            public Throwable error = null;

            PointsStatus() {
            }
        }

        public static final class DocValuesStatus {
            public long totalValueFields;
            public long totalNumericFields;
            public long totalBinaryFields;
            public long totalSortedFields;
            public long totalSortedNumericFields;
            public long totalSortedSetFields;
            public Throwable error = null;

            DocValuesStatus() {
            }
        }

        public static final class TermVectorStatus {
            public int docCount = 0;
            public long totVectors = 0L;
            public Throwable error = null;

            TermVectorStatus() {
            }
        }

        public static final class StoredFieldStatus {
            public int docCount = 0;
            public long totFields = 0L;
            public Throwable error = null;

            StoredFieldStatus() {
            }
        }

        public static final class TermIndexStatus {
            public long termCount = 0L;
            public long delTermCount = 0L;
            public long totFreq = 0L;
            public long totPos = 0L;
            public Throwable error = null;
            public Map<String, Object> blockTreeStats = null;

            TermIndexStatus() {
            }
        }

        public static final class FieldNormStatus {
            public long totFields = 0L;
            public Throwable error = null;

            private FieldNormStatus() {
            }
        }

        public static final class FieldInfoStatus {
            public long totFields = 0L;
            public Throwable error = null;

            private FieldInfoStatus() {
            }
        }

        public static final class LiveDocStatus {
            public int numDeleted;
            public Throwable error = null;

            private LiveDocStatus() {
            }
        }

        public static class SegmentInfoStatus {
            public String name;
            public Codec codec;
            public int maxDoc;
            public boolean compound;
            public int numFiles;
            public double sizeMB;
            public boolean hasDeletions;
            public long deletionsGen;
            public boolean openReaderPassed;
            public Map<String, String> diagnostics;
            public LiveDocStatus liveDocStatus;
            public FieldInfoStatus fieldInfoStatus;
            public FieldNormStatus fieldNormStatus;
            public TermIndexStatus termIndexStatus;
            public StoredFieldStatus storedFieldStatus;
            public TermVectorStatus termVectorStatus;
            public DocValuesStatus docValuesStatus;
            public PointsStatus pointsStatus;
            public IndexSortStatus indexSortStatus;

            SegmentInfoStatus() {
            }
        }
    }
}

