/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.mutable.MutableValue;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.mutable.MutableValueDouble;

public class DoubleFieldSource
extends FieldCacheSource {
    public DoubleFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "double(" + this.field + ')';
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortField(this.field, SortField.Type.DOUBLE, reverse);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = this.getNumericDocValues(context, readerContext);
        final Bits valid = DocValues.getDocsWithField(readerContext.reader(), this.field);
        return new DoubleDocValues(this){

            @Override
            public double doubleVal(int doc) {
                return Double.longBitsToDouble(arr.get(doc));
            }

            @Override
            public boolean exists(int doc) {
                return arr.get(doc) != 0L || valid.get(doc);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDouble mval = new MutableValueDouble();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        this.mval.value = this.doubleVal(doc);
                        this.mval.exists = this.mval.value != 0.0 || valid.get(doc);
                    }
                };
            }
        };
    }

    protected NumericDocValues getNumericDocValues(Map context, LeafReaderContext readerContext) throws IOException {
        return DocValues.getNumeric(readerContext.reader(), this.field);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != DoubleFieldSource.class) {
            return false;
        }
        DoubleFieldSource other = (DoubleFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = Double.class.hashCode();
        return h += super.hashCode();
    }
}

