/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queryparser.classic;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queryparser.classic.FieldQueryExtension;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.WildcardQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.ExistsQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;

public class ExistsFieldQueryExtension
implements FieldQueryExtension {
    public static final String NAME = "_exists_";

    @Override
    public Query query(QueryShardContext context, String queryText) {
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)context.getMapperService().fullName("_field_names");
        if (fieldNamesFieldType == null) {
            return new MatchNoDocsQuery("No mappings yet");
        }
        if (!fieldNamesFieldType.isEnabled()) {
            return new WildcardQuery(new Term(queryText, "*"));
        }
        return ExistsQueryBuilder.newFilter(context, queryText);
    }
}

