/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DisjunctionMaxScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

public final class DisjunctionMaxQuery
extends Query
implements Iterable<Query> {
    private final Query[] disjuncts;
    private final float tieBreakerMultiplier;

    public DisjunctionMaxQuery(Collection<Query> disjuncts, float tieBreakerMultiplier) {
        Objects.requireNonNull(disjuncts, "Collection of Querys must not be null");
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.disjuncts = disjuncts.toArray(new Query[disjuncts.size()]);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.getDisjuncts().iterator();
    }

    public List<Query> getDisjuncts() {
        return Collections.unmodifiableList(Arrays.asList(this.disjuncts));
    }

    public float getTieBreakerMultiplier() {
        return this.tieBreakerMultiplier;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new DisjunctionMaxWeight(searcher, needsScores);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.disjuncts.length == 1) {
            return this.disjuncts[0];
        }
        boolean actuallyRewritten = false;
        ArrayList<Query> rewrittenDisjuncts = new ArrayList<Query>();
        for (Query sub : this.disjuncts) {
            Query rewrittenSub = sub.rewrite(reader);
            actuallyRewritten |= rewrittenSub != sub;
            rewrittenDisjuncts.add(rewrittenSub);
        }
        if (actuallyRewritten) {
            return new DisjunctionMaxQuery(rewrittenDisjuncts, this.tieBreakerMultiplier);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        for (int i = 0; i < this.disjuncts.length; ++i) {
            Query subquery = this.disjuncts[i];
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i == this.disjuncts.length - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DisjunctionMaxQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(DisjunctionMaxQuery other) {
        return this.tieBreakerMultiplier == other.tieBreakerMultiplier && Arrays.equals(this.disjuncts, other.disjuncts);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Float.floatToIntBits(this.tieBreakerMultiplier);
        h = 31 * h + Arrays.hashCode(this.disjuncts);
        return h;
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected final ArrayList<Weight> weights;
        private final boolean needsScores;

        public DisjunctionMaxWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            super(DisjunctionMaxQuery.this);
            this.weights = new ArrayList();
            for (Query disjunctQuery : DisjunctionMaxQuery.this.disjuncts) {
                this.weights.add(searcher.createWeight(disjunctQuery, needsScores));
            }
            this.needsScores = needsScores;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (Weight weight : this.weights) {
                weight.extractTerms(terms);
            }
        }

        @Override
        public float getValueForNormalization() throws IOException {
            float max = 0.0f;
            float sum = 0.0f;
            for (Weight currentWeight : this.weights) {
                float sub = currentWeight.getValueForNormalization();
                sum += sub;
                max = Math.max(max, sub);
            }
            return (sum - max) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max;
        }

        @Override
        public void normalize(float norm, float boost) {
            for (Weight wt : this.weights) {
                wt.normalize(norm, boost);
            }
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            ArrayList<Scorer> scorers = new ArrayList<Scorer>();
            for (Weight w : this.weights) {
                Scorer subScorer = w.scorer(context);
                if (subScorer == null) continue;
                scorers.add(subScorer);
            }
            if (scorers.isEmpty()) {
                return null;
            }
            if (scorers.size() == 1) {
                return (Scorer)scorers.get(0);
            }
            return new DisjunctionMaxScorer(this, DisjunctionMaxQuery.this.tieBreakerMultiplier, scorers, this.needsScores);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            boolean match = false;
            float max = Float.NEGATIVE_INFINITY;
            float sum = 0.0f;
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            for (Weight wt : this.weights) {
                Explanation e = wt.explain(context, doc);
                if (!e.isMatch()) continue;
                match = true;
                subs.add(e);
                sum += e.getValue();
                max = Math.max(max, e.getValue());
            }
            if (match) {
                float score = max + (sum - max) * DisjunctionMaxQuery.this.tieBreakerMultiplier;
                String desc = DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:";
                return Explanation.match(score, desc, subs);
            }
            return Explanation.noMatch("No matching clause", new Explanation[0]);
        }
    }
}

