/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FilterWeight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.join.BitSetProducer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BitSet;

public class ToChildBlockJoinQuery
extends Query {
    static final String INVALID_QUERY_MESSAGE = "Parent query must not match any docs besides parent filter. Combine them as must (+) and must-not (-) clauses to find a problem doc. docID=";
    static final String ILLEGAL_ADVANCE_ON_PARENT = "Expect to be advanced on child docs only. got docID=";
    private final BitSetProducer parentsFilter;
    private final Query parentQuery;

    public ToChildBlockJoinQuery(Query parentQuery, BitSetProducer parentsFilter) {
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher, needsScores), this.parentsFilter, needsScores);
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            return new ToChildBlockJoinQuery(parentRewrite, this.parentsFilter);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((ToChildBlockJoinQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(ToChildBlockJoinQuery other) {
        return this.parentQuery.equals(other.parentQuery) && this.parentsFilter.equals(other.parentsFilter);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.parentQuery.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final DocIdSetIterator parentIt;
        private final BitSet parentBits;
        private final boolean doScores;
        private float parentScore;
        private int parentFreq = 1;
        private int childDoc = -1;
        private int parentDoc = 0;

        public ToChildBlockJoinScorer(Weight weight, Scorer parentScorer, BitSet parentBits, boolean doScores) {
            super(weight);
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
            this.parentIt = parentScorer.iterator();
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.parentScorer, "BLOCK_JOIN"));
        }

        @Override
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                @Override
                public int docID() {
                    return childDoc;
                }

                @Override
                public int nextDoc() throws IOException {
                    if (childDoc + 1 == parentDoc) {
                        do {
                            parentDoc = parentIt.nextDoc();
                            this.validateParentDoc();
                            if (parentDoc == 0) {
                                parentDoc = parentIt.nextDoc();
                                this.validateParentDoc();
                            }
                            if (parentDoc == Integer.MAX_VALUE) {
                                childDoc = Integer.MAX_VALUE;
                                return childDoc;
                            }
                            childDoc = 1 + parentBits.prevSetBit(parentDoc - 1);
                        } while (childDoc == parentDoc || childDoc >= parentDoc);
                        if (doScores) {
                            parentScore = parentScorer.score();
                            parentFreq = parentScorer.freq();
                        }
                        return childDoc;
                    }
                    assert (childDoc < parentDoc) : "childDoc=" + ToChildBlockJoinScorer.access$000(this) + " parentDoc=" + ToChildBlockJoinScorer.access$100(this);
                    childDoc++;
                    return childDoc;
                }

                @Override
                public int advance(int childTarget) throws IOException {
                    if (childTarget >= parentDoc) {
                        int firstChild;
                        block7: {
                            if (childTarget == Integer.MAX_VALUE) {
                                return childDoc = (parentDoc = Integer.MAX_VALUE);
                            }
                            parentDoc = parentIt.advance(childTarget + 1);
                            this.validateParentDoc();
                            if (parentDoc == Integer.MAX_VALUE) {
                                return childDoc = Integer.MAX_VALUE;
                            }
                            do {
                                if ((firstChild = parentBits.prevSetBit(parentDoc - 1) + 1) != parentDoc) break block7;
                                parentDoc = parentIt.nextDoc();
                                this.validateParentDoc();
                            } while (parentDoc != Integer.MAX_VALUE);
                            return childDoc = Integer.MAX_VALUE;
                        }
                        childTarget = Math.max(childTarget, firstChild);
                        if (doScores) {
                            parentScore = parentScorer.score();
                            parentFreq = parentScorer.freq();
                        }
                    }
                    assert (childTarget < parentDoc);
                    assert (!parentBits.get(childTarget));
                    childDoc = childTarget;
                    return childDoc;
                }

                @Override
                public long cost() {
                    return parentIt.cost();
                }
            };
        }

        private void validateParentDoc() {
            if (this.parentDoc != Integer.MAX_VALUE && !this.parentBits.get(this.parentDoc)) {
                throw new IllegalStateException(ToChildBlockJoinQuery.INVALID_QUERY_MESSAGE + this.parentDoc);
            }
        }

        @Override
        public int docID() {
            return this.childDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScore;
        }

        @Override
        public int freq() throws IOException {
            return this.parentFreq;
        }

        int getParentDoc() {
            return this.parentDoc;
        }
    }

    private static class ToChildBlockJoinWeight
    extends FilterWeight {
        private final BitSetProducer parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, BitSetProducer parentsFilter, boolean doScores) {
            super(joinQuery, parentWeight);
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        @Override
        public Scorer scorer(LeafReaderContext readerContext) throws IOException {
            Scorer parentScorer = this.in.scorer(readerContext);
            if (parentScorer == null) {
                return null;
            }
            BitSet parents = this.parentsFilter.getBitSet(readerContext);
            if (parents == null) {
                return null;
            }
            return new ToChildBlockJoinScorer(this, parentScorer, parents, this.doScores);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            ToChildBlockJoinScorer scorer = (ToChildBlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                int parentDoc = scorer.getParentDoc();
                return Explanation.match(scorer.score(), String.format(Locale.ROOT, "Score based on parent document %d", parentDoc + context.docBase), this.in.explain(context, parentDoc));
            }
            return Explanation.noMatch("Not a match", new Explanation[0]);
        }
    }
}

