/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.ConjunctionSpans;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanCollector;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.SpanNearQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.spans.Spans;

public class NearSpansOrdered
extends ConjunctionSpans {
    protected int matchStart = -1;
    protected int matchEnd = -1;
    protected int matchWidth = -1;
    private final int allowedSlop;

    public NearSpansOrdered(int allowedSlop, List<Spans> subSpans) throws IOException {
        super(subSpans);
        this.atFirstInCurrentDoc = true;
        this.allowedSlop = allowedSlop;
    }

    @Override
    boolean twoPhaseCurrentDocMatches() throws IOException {
        assert (this.unpositioned());
        this.oneExhaustedInCurrentDoc = false;
        while (this.subSpans[0].nextStartPosition() != Integer.MAX_VALUE && !this.oneExhaustedInCurrentDoc) {
            if (!this.stretchToOrder() || this.matchWidth > this.allowedSlop) continue;
            this.atFirstInCurrentDoc = true;
            return true;
        }
        return false;
    }

    private boolean unpositioned() {
        for (Spans span : this.subSpans) {
            if (span.startPosition() == -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public int nextStartPosition() throws IOException {
        if (this.atFirstInCurrentDoc) {
            this.atFirstInCurrentDoc = false;
            return this.matchStart;
        }
        this.oneExhaustedInCurrentDoc = false;
        while (this.subSpans[0].nextStartPosition() != Integer.MAX_VALUE && !this.oneExhaustedInCurrentDoc) {
            if (!this.stretchToOrder() || this.matchWidth > this.allowedSlop) continue;
            return this.matchStart;
        }
        this.matchEnd = Integer.MAX_VALUE;
        this.matchStart = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }

    private boolean stretchToOrder() throws IOException {
        Spans prevSpans = this.subSpans[0];
        this.matchStart = prevSpans.startPosition();
        assert (prevSpans.startPosition() != Integer.MAX_VALUE) : "prevSpans no start position " + prevSpans;
        assert (prevSpans.endPosition() != Integer.MAX_VALUE);
        this.matchWidth = 0;
        for (int i = 1; i < this.subSpans.length; ++i) {
            Spans spans = this.subSpans[i];
            assert (spans.startPosition() != Integer.MAX_VALUE);
            assert (spans.endPosition() != Integer.MAX_VALUE);
            if (NearSpansOrdered.advancePosition(spans, prevSpans.endPosition()) == Integer.MAX_VALUE) {
                this.oneExhaustedInCurrentDoc = true;
                return false;
            }
            this.matchWidth += spans.startPosition() - prevSpans.endPosition();
            prevSpans = spans;
        }
        this.matchEnd = this.subSpans[this.subSpans.length - 1].endPosition();
        return true;
    }

    private static int advancePosition(Spans spans, int position) throws IOException {
        if (spans instanceof SpanNearQuery.GapSpans) {
            return ((SpanNearQuery.GapSpans)spans).skipToPosition(position);
        }
        while (spans.startPosition() < position) {
            spans.nextStartPosition();
        }
        return spans.startPosition();
    }

    @Override
    public int startPosition() {
        return this.atFirstInCurrentDoc ? -1 : this.matchStart;
    }

    @Override
    public int endPosition() {
        return this.atFirstInCurrentDoc ? -1 : this.matchEnd;
    }

    @Override
    public int width() {
        return this.matchWidth;
    }

    @Override
    public void collect(SpanCollector collector) throws IOException {
        for (Spans span : this.subSpans) {
            span.collect(collector);
        }
    }
}

