/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight;

import java.text.BreakIterator;
import java.util.Locale;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.Passage;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.PassageFormatter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.PassageScorer;

class CustomFieldHighlighter
extends FieldHighlighter {
    private static final Passage[] EMPTY_PASSAGE = new Passage[0];
    private final Locale breakIteratorLocale;
    private final int noMatchSize;
    private final String fieldValue;

    CustomFieldHighlighter(String field, FieldOffsetStrategy fieldOffsetStrategy, Locale breakIteratorLocale, BreakIterator breakIterator, PassageScorer passageScorer, int maxPassages, int maxNoHighlightPassages, PassageFormatter passageFormatter, int noMatchSize, String fieldValue) {
        super(field, fieldOffsetStrategy, breakIterator, passageScorer, maxPassages, maxNoHighlightPassages, passageFormatter);
        this.breakIteratorLocale = breakIteratorLocale;
        this.noMatchSize = noMatchSize;
        this.fieldValue = fieldValue;
    }

    @Override
    protected Passage[] getSummaryPassagesNoHighlight(int maxPassages) {
        if (this.noMatchSize > 0) {
            int pos;
            for (pos = 0; pos < this.fieldValue.length() && this.fieldValue.charAt(pos) == '\u0000'; ++pos) {
            }
            if (pos < this.fieldValue.length()) {
                int end = this.fieldValue.indexOf(0, pos);
                if (end == -1) {
                    end = this.fieldValue.length();
                }
                if (this.noMatchSize + pos < end) {
                    BreakIterator bi = BreakIterator.getWordInstance(this.breakIteratorLocale);
                    bi.setText(this.fieldValue);
                    end = bi.following(this.noMatchSize + pos);
                    if (end == -1) {
                        end = this.fieldValue.length();
                    }
                }
                Passage passage = new Passage();
                passage.setScore(Float.NaN);
                passage.setStartOffset(pos);
                passage.setEndOffset(end);
                return new Passage[]{passage};
            }
        }
        return EMPTY_PASSAGE;
    }
}

