/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.tasks.get;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ResourceNotFoundException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.GetRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.GetResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.HandledTransportAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexNotFoundException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportResponseHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportGetTaskAction
extends HandledTransportAction<GetTaskRequest, GetTaskResponse> {
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportGetTaskAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super(settings, "cluster:monitor/task/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetTaskRequest::new);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    protected void doExecute(GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        throw new UnsupportedOperationException("Task is required");
    }

    @Override
    protected void doExecute(Task thisTask, GetTaskRequest request, ActionListener<GetTaskResponse> listener) {
        if (this.clusterService.localNode().getId().equals(request.getTaskId().getNodeId())) {
            this.getRunningTaskFromNode(thisTask, request, listener);
        } else {
            this.runOnNodeWithTaskIfPossible(thisTask, request, listener);
        }
    }

    private void runOnNodeWithTaskIfPossible(Task thisTask, GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        TransportRequestOptions.Builder builder = TransportRequestOptions.builder();
        if (request.getTimeout() != null) {
            builder.withTimeout(request.getTimeout());
        }
        builder.withCompress(false);
        DiscoveryNode node = this.clusterService.state().nodes().get(request.getTaskId().getNodeId());
        if (node == null) {
            this.getFinishedTaskFromIndex(thisTask, request, ActionListener.wrap(listener::onResponse, e -> {
                if (e instanceof ResourceNotFoundException) {
                    e = new ResourceNotFoundException("task [" + request.getTaskId() + "] belongs to the node [" + request.getTaskId().getNodeId() + "] which isn't part of the cluster and there is no record of the task", (Throwable)e, new Object[0]);
                }
                listener.onFailure((Exception)e);
            }));
            return;
        }
        GetTaskRequest nodeRequest = request.nodeRequest(this.clusterService.localNode().getId(), thisTask.getId());
        this.transportService.sendRequest(node, "cluster:monitor/task/get", (TransportRequest)nodeRequest, builder.build(), new TransportResponseHandler<GetTaskResponse>(){

            @Override
            public GetTaskResponse newInstance() {
                return new GetTaskResponse();
            }

            @Override
            public void handleResponse(GetTaskResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    void getRunningTaskFromNode(final Task thisTask, final GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        final Task runningTask = this.taskManager.getTask(request.getTaskId().getId());
        if (runningTask == null) {
            this.getFinishedTaskFromIndex(thisTask, request, listener);
        } else if (request.getWaitForCompletion()) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                protected void doRun() throws Exception {
                    TransportGetTaskAction.this.taskManager.waitForTaskCompletion(runningTask, TransportListTasksAction.waitForCompletionTimeout(request.getTimeout()));
                    TransportGetTaskAction.this.waitedForCompletion(thisTask, request, runningTask.taskInfo(TransportGetTaskAction.this.clusterService.localNode().getId(), true), listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            TaskInfo info = runningTask.taskInfo(this.clusterService.localNode().getId(), true);
            listener.onResponse(new GetTaskResponse(new TaskResult(false, info)));
        }
    }

    void waitedForCompletion(Task thisTask, GetTaskRequest request, final TaskInfo snapshotOfRunningTask, final ActionListener<GetTaskResponse> listener) {
        this.getFinishedTaskFromIndex(thisTask, request, new ActionListener<GetTaskResponse>(){

            @Override
            public void onResponse(GetTaskResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrap(e, ResourceNotFoundException.class) != null) {
                    listener.onResponse(new GetTaskResponse(new TaskResult(true, snapshotOfRunningTask)));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    void getFinishedTaskFromIndex(Task thisTask, final GetTaskRequest request, final ActionListener<GetTaskResponse> listener) {
        GetRequest get = new GetRequest(".tasks", "task", request.getTaskId().toString());
        get.setParentTask(this.clusterService.localNode().getId(), thisTask.getId());
        this.client.get(get, new ActionListener<GetResponse>(){

            @Override
            public void onResponse(GetResponse getResponse) {
                try {
                    TransportGetTaskAction.this.onGetFinishedTaskFromIndex(getResponse, listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class) != null) {
                    listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", (Throwable)e, request.getTaskId()));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    void onGetFinishedTaskFromIndex(GetResponse response, ActionListener<GetTaskResponse> listener) throws IOException {
        if (!response.isExists()) {
            listener.onFailure(new ResourceNotFoundException("task [{}] isn't running and hasn't stored its results", response.getId()));
            return;
        }
        if (response.isSourceEmpty()) {
            listener.onFailure(new ElasticsearchException("Stored task status for [{}] didn't contain any source!", response.getId()));
            return;
        }
        try (XContentParser parser = XContentHelper.createParser(this.xContentRegistry, response.getSourceAsBytesRef());){
            TaskResult result = TaskResult.PARSER.apply(parser, null);
            listener.onResponse(new GetTaskResponse(result));
        }
    }
}

