/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.repositories.put;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchGenerationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;

public class PutRepositoryRequest
extends AcknowledgedRequest<PutRepositoryRequest> {
    private String name;
    private String type;
    private boolean verify = true;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;

    public PutRepositoryRequest() {
    }

    public PutRepositoryRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        return validationException;
    }

    public PutRepositoryRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutRepositoryRequest type(String type) {
        this.type = type;
        return this;
    }

    public String type() {
        return this.type;
    }

    public PutRepositoryRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutRepositoryRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    @Deprecated
    public PutRepositoryRequest settings(String source) {
        this.settings = Settings.builder().loadFromSource(source).build();
        return this;
    }

    public PutRepositoryRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public PutRepositoryRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string(), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutRepositoryRequest verify(boolean verify) {
        this.verify = verify;
        return this;
    }

    public boolean verify() {
        return this.verify;
    }

    public PutRepositoryRequest source(Map<String, Object> repositoryDefinition) {
        for (Map.Entry<String, Object> entry : repositoryDefinition.entrySet()) {
            String name = entry.getKey();
            if (name.equals("type")) {
                this.type(entry.getValue().toString());
                continue;
            }
            if (!name.equals("settings")) continue;
            if (!(entry.getValue() instanceof Map)) {
                throw new IllegalArgumentException("Malformed settings section, should include an inner object");
            }
            Map sub = (Map)entry.getValue();
            this.settings(sub);
        }
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.name = in.readString();
        this.type = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        this.readTimeout(in);
        this.verify = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeString(this.type);
        Settings.writeSettingsToStream(this.settings, out);
        this.writeTimeout(out);
        out.writeBoolean(this.verify);
    }
}

