/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.exists.indices;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexNotFoundException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportIndicesExistsAction
extends TransportMasterNodeReadAction<IndicesExistsRequest, IndicesExistsResponse> {
    @Inject
    public TransportIndicesExistsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/exists", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, IndicesExistsRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected IndicesExistsResponse newResponse() {
        return new IndicesExistsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesExistsRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request.indices()));
    }

    @Override
    protected void masterOperation(IndicesExistsRequest request, ClusterState state, ActionListener<IndicesExistsResponse> listener) {
        boolean exists;
        try {
            this.indexNameExpressionResolver.concreteIndexNames(state, request);
            exists = true;
        }
        catch (IndexNotFoundException e) {
            exists = false;
        }
        listener.onResponse(new IndicesExistsResponse(exists));
    }
}

