/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ShardOperationFailedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RecoveryState;

public class RecoveryResponse
extends BroadcastResponse
implements ToXContent {
    private boolean detailed = false;
    private Map<String, List<RecoveryState>> shardRecoveryStates = new HashMap<String, List<RecoveryState>>();

    public RecoveryResponse() {
    }

    public RecoveryResponse(int totalShards, int successfulShards, int failedShards, boolean detailed, Map<String, List<RecoveryState>> shardRecoveryStates, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardRecoveryStates = shardRecoveryStates;
        this.detailed = detailed;
    }

    public boolean hasRecoveries() {
        return this.shardRecoveryStates.size() > 0;
    }

    public boolean detailed() {
        return this.detailed;
    }

    public void detailed(boolean detailed) {
        this.detailed = detailed;
    }

    public Map<String, List<RecoveryState>> shardRecoveryStates() {
        return this.shardRecoveryStates;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.hasRecoveries()) {
            for (String index : this.shardRecoveryStates.keySet()) {
                List<RecoveryState> recoveryStates = this.shardRecoveryStates.get(index);
                if (recoveryStates == null || recoveryStates.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("shards");
                for (RecoveryState recoveryState : recoveryStates) {
                    builder.startObject();
                    recoveryState.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardRecoveryStates.size());
        for (Map.Entry<String, List<RecoveryState>> entry : this.shardRecoveryStates.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (RecoveryState recoveryState : entry.getValue()) {
                recoveryState.writeTo(out);
            }
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String s = in.readString();
            int listSize = in.readVInt();
            ArrayList<RecoveryState> list = new ArrayList<RecoveryState>(listSize);
            for (int j = 0; j < listSize; ++j) {
                list.add(RecoveryState.readRecoveryState(in));
            }
            this.shardRecoveryStates.put(s, list);
        }
    }
}

