/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ShardOperationFailedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;

public class UpgradeResponse
extends BroadcastResponse {
    private Map<String, Tuple<Version, String>> versions;

    UpgradeResponse() {
    }

    UpgradeResponse(Map<String, Tuple<Version, String>> versions, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.versions = versions;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.versions = new HashMap<String, Tuple<Version, String>>();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            Version upgradeVersion = Version.readVersion(in);
            String oldestLuceneSegment = in.readString();
            this.versions.put(index, new Tuple<Version, String>(upgradeVersion, oldestLuceneSegment));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.versions.size());
        for (Map.Entry<String, Tuple<Version, String>> entry : this.versions.entrySet()) {
            out.writeString(entry.getKey());
            Version.writeVersion(entry.getValue().v1(), out);
            out.writeString(entry.getValue().v2());
        }
    }

    public Map<String, Tuple<Version, String>> versions() {
        return this.versions;
    }
}

