/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats.FieldStatsRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.fieldstats.IndexConstraint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;

public class FieldStatsShardRequest
extends BroadcastShardRequest {
    private String[] fields;
    private boolean useCache;

    public FieldStatsShardRequest() {
    }

    public FieldStatsShardRequest(ShardId shardId, FieldStatsRequest request) {
        super(shardId, request);
        HashSet<String> fields = new HashSet<String>(Arrays.asList(request.getFields()));
        for (IndexConstraint indexConstraint : request.getIndexConstraints()) {
            fields.add(indexConstraint.getField());
        }
        this.fields = fields.toArray(new String[fields.size()]);
        this.useCache = request.shouldUseCache();
    }

    public String[] getFields() {
        return this.fields;
    }

    public boolean shouldUseCache() {
        return this.useCache;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.fields = in.readStringArray();
        this.useCache = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.fields);
        out.writeBoolean(this.useCache);
    }
}

