/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest;

import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulateExecutionService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.HandledTransportAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.PipelineStore;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.node.NodeService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class SimulatePipelineTransportAction
extends HandledTransportAction<SimulatePipelineRequest, SimulatePipelineResponse> {
    private final PipelineStore pipelineStore;
    private final SimulateExecutionService executionService;

    @Inject
    public SimulatePipelineTransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeService nodeService) {
        super(settings, "cluster:admin/ingest/pipeline/simulate", threadPool, transportService, actionFilters, indexNameExpressionResolver, SimulatePipelineRequest::new);
        this.pipelineStore = nodeService.getIngestService().getPipelineStore();
        this.executionService = new SimulateExecutionService(threadPool);
    }

    @Override
    protected void doExecute(SimulatePipelineRequest request, ActionListener<SimulatePipelineResponse> listener) {
        SimulatePipelineRequest.Parsed simulateRequest;
        Map<String, Object> source = XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        try {
            simulateRequest = request.getId() != null ? SimulatePipelineRequest.parseWithPipelineId(request.getId(), source, request.isVerbose(), this.pipelineStore) : SimulatePipelineRequest.parse(source, request.isVerbose(), this.pipelineStore);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.executionService.execute(simulateRequest, listener);
    }
}

