/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;

public class ClearScrollResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField SUCCEEDED = new ParseField("succeeded", new String[0]);
    private static final ParseField NUMFREED = new ParseField("num_freed", new String[0]);
    private static final ConstructingObjectParser<ClearScrollResponse, Void> PARSER = new ConstructingObjectParser("clear_scroll", true, a -> new ClearScrollResponse((Boolean)a[0], (Integer)a[1]));
    private boolean succeeded;
    private int numFreed;

    public ClearScrollResponse(boolean succeeded, int numFreed) {
        this.succeeded = succeeded;
        this.numFreed = numFreed;
    }

    ClearScrollResponse() {
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public int getNumFreed() {
        return this.numFreed;
    }

    @Override
    public RestStatus status() {
        return this.numFreed == 0 ? RestStatus.NOT_FOUND : RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SUCCEEDED.getPreferredName(), this.succeeded);
        builder.field(NUMFREED.getPreferredName(), this.numFreed);
        builder.endObject();
        return builder;
    }

    public static ClearScrollResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.succeeded = in.readBoolean();
        this.numFreed = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.succeeded);
        out.writeVInt(this.numFreed);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), SUCCEEDED, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.intValue(), NUMFREED, ObjectParser.ValueType.INT);
    }
}

