/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActiveShardCount;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterStateObserver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.node.NodeClosedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

public class ActiveShardsObserver
extends AbstractComponent {
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public ActiveShardsObserver(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public void waitForActiveShards(final String indexName, ActiveShardCount activeShardCount, TimeValue timeout, final Consumer<Boolean> onResult, final Consumer<Exception> onFailure) {
        if (activeShardCount == ActiveShardCount.NONE) {
            onResult.accept(true);
            return;
        }
        ClusterState state = this.clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService, null, this.logger, this.threadPool.getThreadContext());
        if (activeShardCount.enoughShardsActive(state, indexName)) {
            onResult.accept(true);
        } else {
            Predicate<ClusterState> shardsAllocatedPredicate = newState -> activeShardCount.enoughShardsActive((ClusterState)newState, indexName);
            ClusterStateObserver.Listener observerListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    onResult.accept(true);
                }

                @Override
                public void onClusterServiceClose() {
                    ActiveShardsObserver.this.logger.debug("[{}] cluster service closed while waiting for enough shards to be started.", (Object)indexName);
                    onFailure.accept(new NodeClosedException(ActiveShardsObserver.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    onResult.accept(false);
                }
            };
            observer.waitForNextChange(observerListener, shardsAllocatedPredicate, timeout);
        }
    }
}

