/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.IntArrayList;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;

public class MultiTermVectorsShardResponse
extends ActionResponse {
    IntArrayList locations = new IntArrayList();
    List<TermVectorsResponse> responses = new ArrayList<TermVectorsResponse>();
    List<MultiTermVectorsResponse.Failure> failures = new ArrayList<MultiTermVectorsResponse.Failure>();

    MultiTermVectorsShardResponse() {
    }

    public void add(int location, TermVectorsResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiTermVectorsResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.responses = new ArrayList<TermVectorsResponse>(size);
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                TermVectorsResponse response = new TermVectorsResponse();
                response.readFrom(in);
                this.responses.add(response);
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(MultiTermVectorsResponse.Failure.readFailure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

