/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.IntSet;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.IntCursor;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.IntObjectCursor;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.CollectionUtil;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.AbstractDiffable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.Diff;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RecoverySource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RotationShardShuffler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRoutingState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardShuffler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardsIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.UnassignedInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Randomness;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.Index;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;

public class IndexRoutingTable
extends AbstractDiffable<IndexRoutingTable>
implements Iterable<IndexShardRoutingTable> {
    private final Index index;
    private final ShardShuffler shuffler;
    private final ImmutableOpenIntMap<IndexShardRoutingTable> shards;
    private final List<ShardRouting> allActiveShards;

    IndexRoutingTable(Index index, ImmutableOpenIntMap<IndexShardRoutingTable> shards) {
        this.index = index;
        this.shuffler = new RotationShardShuffler(Randomness.get().nextInt());
        this.shards = shards;
        ArrayList<ShardRouting> allActiveShards = new ArrayList<ShardRouting>();
        for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : shards) {
            for (ShardRouting shardRouting : (IndexShardRoutingTable)intObjectCursor.value) {
                if (!shardRouting.active()) continue;
                allActiveShards.add(shardRouting);
            }
        }
        this.allActiveShards = Collections.unmodifiableList(allActiveShards);
    }

    public Index getIndex() {
        return this.index;
    }

    boolean validate(MetaData metaData) {
        if (!metaData.hasIndex(this.index.getName())) {
            throw new IllegalStateException(this.index + " exists in routing does not exists in metadata");
        }
        IndexMetaData indexMetaData = metaData.index(this.index.getName());
        if (!indexMetaData.getIndexUUID().equals(this.index.getUUID())) {
            throw new IllegalStateException(this.index.getName() + " exists in routing does not exists in metadata with the same uuid");
        }
        if (indexMetaData.getNumberOfShards() != this.shards().size()) {
            HashSet<Integer> expected = new HashSet<Integer>();
            for (int i = 0; i < indexMetaData.getNumberOfShards(); ++i) {
                expected.add(i);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : this) {
                expected.remove(indexShardRoutingTable.shardId().id());
            }
            throw new IllegalStateException("Wrong number of shards in routing table, missing: " + expected);
        }
        for (IndexShardRoutingTable indexShardRoutingTable : this) {
            int routingNumberOfReplicas = indexShardRoutingTable.size() - 1;
            if (routingNumberOfReplicas != indexMetaData.getNumberOfReplicas()) {
                throw new IllegalStateException("Shard [" + indexShardRoutingTable.shardId().id() + "] routing table has wrong number of replicas, expected [" + indexMetaData.getNumberOfReplicas() + "], got [" + routingNumberOfReplicas + "]");
            }
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                if (!shardRouting.index().equals(this.index)) {
                    throw new IllegalStateException("shard routing has an index [" + shardRouting.index() + "] that is different from the routing table");
                }
                Set<String> inSyncAllocationIds = indexMetaData.inSyncAllocationIds(shardRouting.id());
                if (shardRouting.active() && !inSyncAllocationIds.contains(shardRouting.allocationId().getId())) {
                    throw new IllegalStateException("active shard routing " + shardRouting + " has no corresponding entry in the in-sync allocation set " + inSyncAllocationIds);
                }
                if (!indexMetaData.getCreationVersion().onOrAfter(Version.V_5_0_0_alpha1) || IndexMetaData.isIndexUsingShadowReplicas(indexMetaData.getSettings()) || !shardRouting.primary() || !shardRouting.initializing() || shardRouting.recoverySource().getType() != RecoverySource.Type.SNAPSHOT || inSyncAllocationIds.contains(shardRouting.allocationId().getId())) continue;
                throw new IllegalStateException("a primary shard routing " + shardRouting + " is a primary that is recovering from a known allocation id but has no corresponding entry in the in-sync allocation set " + inSyncAllocationIds);
            }
        }
        return true;
    }

    @Override
    public Iterator<IndexShardRoutingTable> iterator() {
        return this.shards.valuesIt();
    }

    public int numberOfNodesShardsAreAllocatedOn(String ... excludedNodes) {
        HashSet<String> nodes = new HashSet<String>();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            for (ShardRouting shardRouting : shardRoutingTable) {
                if (!shardRouting.assignedToNode()) continue;
                String currentNodeId = shardRouting.currentNodeId();
                boolean excluded = false;
                if (excludedNodes != null) {
                    for (String excludedNode : excludedNodes) {
                        if (!currentNodeId.equals(excludedNode)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                nodes.add(currentNodeId);
            }
        }
        return nodes.size();
    }

    public ImmutableOpenIntMap<IndexShardRoutingTable> shards() {
        return this.shards;
    }

    public ImmutableOpenIntMap<IndexShardRoutingTable> getShards() {
        return this.shards();
    }

    public IndexShardRoutingTable shard(int shardId) {
        return this.shards.get(shardId);
    }

    public boolean allPrimaryShardsActive() {
        return this.primaryShardsActive() == this.shards().size();
    }

    public int primaryShardsActive() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().active()) continue;
            ++counter;
        }
        return counter;
    }

    public boolean allPrimaryShardsUnassigned() {
        return this.primaryShardsUnassigned() == this.shards.size();
    }

    public int primaryShardsUnassigned() {
        int counter = 0;
        for (IndexShardRoutingTable shardRoutingTable : this) {
            if (!shardRoutingTable.primaryShard().unassigned()) continue;
            ++counter;
        }
        return counter;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexShardRoutingTable shardRoutingTable : this) {
            shards.addAll(shardRoutingTable.shardsWithState(state));
        }
        return shards;
    }

    public ShardsIterator randomAllActiveShardsIt() {
        return new PlainShardsIterator(this.shuffler.shuffle(this.allActiveShards));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRoutingTable that = (IndexRoutingTable)o;
        if (!this.index.equals(that.index)) {
            return false;
        }
        return this.shards.equals(that.shards);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + this.shards.hashCode();
        return result;
    }

    public static IndexRoutingTable readFrom(StreamInput in) throws IOException {
        Index index = new Index(in);
        Builder builder = new Builder(index);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            builder.addIndexShard(IndexShardRoutingTable.Builder.readFromThin(in, index));
        }
        return builder.build();
    }

    public static Diff<IndexRoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return IndexRoutingTable.readDiffFrom(IndexRoutingTable::readFrom, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shards.size());
        for (IndexShardRoutingTable indexShard : this) {
            IndexShardRoutingTable.Builder.writeToThin(indexShard, out);
        }
    }

    public static Builder builder(Index index) {
        return new Builder(index);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("-- index [" + this.index + "]\n");
        ArrayList<IndexShardRoutingTable> ordered = new ArrayList<IndexShardRoutingTable>();
        for (IndexShardRoutingTable indexShard : this) {
            ordered.add(indexShard);
        }
        CollectionUtil.timSort(ordered, (o1, o2) -> {
            int v = o1.shardId().getIndex().getName().compareTo(o2.shardId().getIndex().getName());
            if (v == 0) {
                v = Integer.compare(o1.shardId().id(), o2.shardId().id());
            }
            return v;
        });
        for (IndexShardRoutingTable indexShard : ordered) {
            sb.append("----shard_id [").append(indexShard.shardId().getIndex().getName()).append("][").append(indexShard.shardId().id()).append("]\n");
            for (ShardRouting shard : indexShard) {
                sb.append("--------").append(shard.shortSummary()).append("\n");
            }
        }
        return sb.toString();
    }

    public static class Builder {
        private final Index index;
        private final ImmutableOpenIntMap.Builder<IndexShardRoutingTable> shards = ImmutableOpenIntMap.builder();

        public Builder(Index index) {
            this.index = index;
        }

        public Builder initializeAsNew(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null));
        }

        public Builder initializeAsRecovery(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.CLUSTER_RECOVERED, null));
        }

        public Builder initializeAsFromDangling(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.DANGLING_INDEX_IMPORTED, null));
        }

        public Builder initializeAsFromCloseToOpen(IndexMetaData indexMetaData) {
            return this.initializeEmpty(indexMetaData, new UnassignedInfo(UnassignedInfo.Reason.INDEX_REOPENED, null));
        }

        public Builder initializeAsNewRestore(IndexMetaData indexMetaData, RecoverySource.SnapshotRecoverySource recoverySource, IntSet ignoreShards) {
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.NEW_INDEX_RESTORED, "restore_source[" + recoverySource.snapshot().getRepository() + "/" + recoverySource.snapshot().getSnapshotId().getName() + "]");
            return this.initializeAsRestore(indexMetaData, recoverySource, ignoreShards, true, unassignedInfo);
        }

        public Builder initializeAsRestore(IndexMetaData indexMetaData, RecoverySource.SnapshotRecoverySource recoverySource) {
            UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.EXISTING_INDEX_RESTORED, "restore_source[" + recoverySource.snapshot().getRepository() + "/" + recoverySource.snapshot().getSnapshotId().getName() + "]");
            return this.initializeAsRestore(indexMetaData, recoverySource, null, false, unassignedInfo);
        }

        private Builder initializeAsRestore(IndexMetaData indexMetaData, RecoverySource.SnapshotRecoverySource recoverySource, IntSet ignoreShards, boolean asNew, UnassignedInfo unassignedInfo) {
            assert (indexMetaData.getIndex().equals(this.index));
            if (!this.shards.isEmpty()) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardNumber = 0; shardNumber < indexMetaData.getNumberOfShards(); ++shardNumber) {
                ShardId shardId = new ShardId(this.index, shardNumber);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
                for (int i = 0; i <= indexMetaData.getNumberOfReplicas(); ++i) {
                    boolean primary;
                    boolean bl = primary = i == 0;
                    if (asNew && ignoreShards.contains(shardNumber)) {
                        indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                        continue;
                    }
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? recoverySource : RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                }
                this.shards.put(shardNumber, indexShardRoutingBuilder.build());
            }
            return this;
        }

        private Builder initializeEmpty(IndexMetaData indexMetaData, UnassignedInfo unassignedInfo) {
            assert (indexMetaData.getIndex().equals(this.index));
            if (!this.shards.isEmpty()) {
                throw new IllegalStateException("trying to initialize an index with fresh shards, but already has shards created");
            }
            for (int shardNumber = 0; shardNumber < indexMetaData.getNumberOfShards(); ++shardNumber) {
                ShardId shardId = new ShardId(this.index, shardNumber);
                RecoverySource primaryRecoverySource = !indexMetaData.inSyncAllocationIds(shardNumber).isEmpty() ? RecoverySource.StoreRecoverySource.EXISTING_STORE_INSTANCE : (indexMetaData.getCreationVersion().before(Version.V_5_0_0_alpha1) && unassignedInfo.getReason() != UnassignedInfo.Reason.INDEX_CREATED ? RecoverySource.StoreRecoverySource.EXISTING_STORE_INSTANCE : (indexMetaData.getMergeSourceIndex() != null ? RecoverySource.LocalShardsRecoverySource.INSTANCE : RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE));
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
                for (int i = 0; i <= indexMetaData.getNumberOfReplicas(); ++i) {
                    boolean primary = i == 0;
                    indexShardRoutingBuilder.addShard(ShardRouting.newUnassigned(shardId, primary, primary ? primaryRecoverySource : RecoverySource.PeerRecoverySource.INSTANCE, unassignedInfo));
                }
                this.shards.put(shardNumber, indexShardRoutingBuilder.build());
            }
            return this;
        }

        public Builder addReplica() {
            for (IntCursor cursor : this.shards.keys()) {
                int shardNumber = cursor.value;
                ShardId shardId = new ShardId(this.index, shardNumber);
                ShardRouting shard = ShardRouting.newUnassigned(shardId, false, RecoverySource.PeerRecoverySource.INSTANCE, new UnassignedInfo(UnassignedInfo.Reason.REPLICA_ADDED, null));
                this.shards.put(shardNumber, new IndexShardRoutingTable.Builder(this.shards.get(shard.id())).addShard(shard).build());
            }
            return this;
        }

        public Builder removeReplica() {
            for (IntCursor cursor : this.shards.keys()) {
                int shardId = cursor.value;
                IndexShardRoutingTable indexShard = this.shards.get(shardId);
                if (indexShard.replicaShards().isEmpty()) {
                    return this;
                }
                IndexShardRoutingTable.Builder builder = new IndexShardRoutingTable.Builder(indexShard.shardId());
                for (ShardRouting shardRouting : indexShard) {
                    builder.addShard(shardRouting);
                }
                boolean removed = false;
                for (ShardRouting shardRouting : indexShard) {
                    if (shardRouting.primary() || shardRouting.assignedToNode()) continue;
                    builder.removeShard(shardRouting);
                    removed = true;
                    break;
                }
                if (!removed) {
                    for (ShardRouting shardRouting : indexShard) {
                        if (shardRouting.primary()) continue;
                        builder.removeShard(shardRouting);
                        break;
                    }
                }
                this.shards.put(shardId, builder.build());
            }
            return this;
        }

        public Builder addIndexShard(IndexShardRoutingTable indexShard) {
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public Builder addShard(ShardRouting shard) {
            IndexShardRoutingTable indexShard = this.shards.get(shard.id());
            indexShard = indexShard == null ? new IndexShardRoutingTable.Builder(shard.shardId()).addShard(shard).build() : new IndexShardRoutingTable.Builder(indexShard).addShard(shard).build();
            this.shards.put(indexShard.shardId().id(), indexShard);
            return this;
        }

        public IndexRoutingTable build() {
            return new IndexRoutingTable(this.index, this.shards.build());
        }
    }
}

