/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.blobstore.url;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.blobstore.BlobMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.blobstore.BlobPath;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.blobstore.url.URLBlobStore;

public class URLBlobContainer
extends AbstractBlobContainer {
    protected final URLBlobStore blobStore;
    protected final URL path;

    public URLBlobContainer(URLBlobStore blobStore, BlobPath blobPath, URL path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public URL url() {
        return this.path;
    }

    @Override
    public Map<String, BlobMetaData> listBlobs() throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public Map<String, BlobMetaData> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public void move(String from, String to) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public void deleteBlob(String blobName) throws IOException {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    @Override
    public boolean blobExists(String blobName) {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public InputStream readBlob(String name) throws IOException {
        try {
            return new BufferedInputStream(new URL(this.path, name).openStream(), this.blobStore.bufferSizeInBytes());
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + name + "] blob not found");
        }
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }
}

