/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Locale;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.GeoUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.DistanceUnit;

public enum GeoDistance implements Writeable
{
    PLANE,
    ARC;

    private static final DeprecationLogger DEPRECATION_LOGGER;

    public static GeoDistance readFromStream(StreamInput in) throws IOException {
        Version clientVersion = in.getVersion();
        int ord = in.readVInt();
        if (clientVersion.before(Version.V_5_3_0)) {
            switch (ord) {
                case 0: {
                    return PLANE;
                }
                case 1: {
                    DEPRECATION_LOGGER.deprecated("[factor] is deprecated. Using [plane] instead.", new Object[0]);
                    return PLANE;
                }
                case 2: {
                    return ARC;
                }
                case 3: {
                    DEPRECATION_LOGGER.deprecated("[sloppy_arc] is deprecated. Using [arc] instead.", new Object[0]);
                    return ARC;
                }
            }
            throw new IOException("Unknown GeoDistance ordinal [" + ord + "]");
        }
        if (ord < 0 || ord >= GeoDistance.values().length) {
            throw new IOException("Unknown GeoDistance ordinal [" + ord + "]");
        }
        return GeoDistance.values()[ord];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Version clientVersion = out.getVersion();
        int ord = this.ordinal();
        if (clientVersion.before(Version.V_5_3_0)) {
            switch (ord) {
                case 0: {
                    out.write(0);
                    return;
                }
                case 1: {
                    out.write(2);
                    return;
                }
            }
            throw new IOException("Unknown GeoDistance ordinal [" + ord + "]");
        }
        out.writeVInt(this.ordinal());
    }

    public static GeoDistance fromString(String name) {
        if ("plane".equals(name = name.toLowerCase(Locale.ROOT))) {
            return PLANE;
        }
        if ("sloppy_arc".equals(name)) {
            DEPRECATION_LOGGER.deprecated("[sloppy_arc] is deprecated. Use [arc] instead.", new Object[0]);
            return ARC;
        }
        if ("arc".equals(name)) {
            return ARC;
        }
        throw new IllegalArgumentException("No geo distance for [" + name + "]");
    }

    public double calculate(double srcLat, double srcLon, double dstLat, double dstLon, DistanceUnit unit) {
        if (this == PLANE) {
            return DistanceUnit.convert(GeoUtils.planeDistance(srcLat, srcLon, dstLat, dstLon), DistanceUnit.METERS, unit);
        }
        return DistanceUnit.convert(GeoUtils.arcDistance(srcLat, srcLon, dstLat, dstLon), DistanceUnit.METERS, unit);
    }

    static {
        DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(GeoDistance.class));
    }
}

