/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.CoordinateCollection;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.spatial4j.shape.Shape;

public class LineStringBuilder
extends CoordinateCollection<LineStringBuilder> {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.LINESTRING;

    public LineStringBuilder(List<Coordinate> coordinates) {
        super(coordinates);
        if (coordinates.size() < 2) {
            throw new IllegalArgumentException("invalid number of points in LineString (found [" + coordinates.size() + "] - must be >= 2)");
        }
    }

    public LineStringBuilder(CoordinatesBuilder coordinates) {
        this(coordinates.build());
    }

    public LineStringBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE.shapeName());
        builder.field("coordinates");
        this.coordinatesToXcontent(builder, false);
        builder.endObject();
        return builder;
    }

    public LineStringBuilder close() {
        Coordinate start = (Coordinate)this.coordinates.get(0);
        Coordinate end = (Coordinate)this.coordinates.get(this.coordinates.size() - 1);
        if (start.x != end.x || start.y != end.y) {
            this.coordinates.add(start);
        }
        return this;
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    @Override
    public Shape build() {
        LineString geometry;
        Coordinate[] coordinates = this.coordinates.toArray(new Coordinate[this.coordinates.size()]);
        if (this.wrapdateline) {
            ArrayList<LineString> strings = LineStringBuilder.decompose(FACTORY, coordinates, new ArrayList<LineString>());
            if (strings.size() == 1) {
                geometry = (Geometry)strings.get(0);
            } else {
                LineString[] linestrings = strings.toArray(new LineString[strings.size()]);
                geometry = FACTORY.createMultiLineString(linestrings);
            }
        } else {
            geometry = FACTORY.createLineString(coordinates);
        }
        return this.jtsGeometry((Geometry)geometry);
    }

    static ArrayList<LineString> decompose(GeometryFactory factory, Coordinate[] coordinates, ArrayList<LineString> strings) {
        for (Coordinate[] part : LineStringBuilder.decompose(180.0, coordinates)) {
            for (Coordinate[] line : LineStringBuilder.decompose(-180.0, part)) {
                strings.add(factory.createLineString(line));
            }
        }
        return strings;
    }

    private static Coordinate[][] decompose(double dateline, Coordinate[] coordinates) {
        int offset = 0;
        ArrayList<Coordinate[]> parts = new ArrayList<Coordinate[]>();
        double shift = coordinates[0].x > 180.0 ? 180.0 : (coordinates[0].x < -180.0 ? -180.0 : 0.0);
        for (int i = 1; i < coordinates.length; ++i) {
            Coordinate[] part;
            double t = LineStringBuilder.intersection(coordinates[i - 1], coordinates[i], dateline);
            if (Double.isNaN(t)) continue;
            if (t < 1.0) {
                part = Arrays.copyOfRange(coordinates, offset, i + 1);
                part[part.length - 1] = ShapeBuilder.Edge.position(coordinates[i - 1], coordinates[i], t);
                coordinates[offset + i - 1] = ShapeBuilder.Edge.position(coordinates[i - 1], coordinates[i], t);
                LineStringBuilder.shift(shift, part);
                offset = i - 1;
                shift = coordinates[i].x > 180.0 ? 180.0 : (coordinates[i].x < -180.0 ? -180.0 : 0.0);
            } else {
                part = LineStringBuilder.shift(shift, Arrays.copyOfRange(coordinates, offset, i + 1));
                offset = i;
            }
            parts.add(part);
        }
        if (offset == 0) {
            parts.add(LineStringBuilder.shift(shift, coordinates));
        } else if (offset < coordinates.length - 1) {
            Coordinate[] part = Arrays.copyOfRange(coordinates, offset, coordinates.length);
            parts.add(LineStringBuilder.shift(shift, part));
        }
        return (Coordinate[][])parts.toArray((T[])new Coordinate[parts.size()][]);
    }

    private static Coordinate[] shift(double shift, Coordinate ... coordinates) {
        if (shift != 0.0) {
            for (int j = 0; j < coordinates.length; ++j) {
                coordinates[j] = new Coordinate(coordinates[j].x - 2.0 * shift, coordinates[j].y);
            }
        }
        return coordinates;
    }

    public int hashCode() {
        return Objects.hash(this.coordinates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LineStringBuilder other = (LineStringBuilder)obj;
        return Objects.equals(this.coordinates, other.coordinates);
    }
}

