/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject;

import java.util.List;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Binding;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.BindingProcessor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.ContextualCallable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.DeferredLookups;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Initializer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.InjectionRequestProcessor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Injector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.InjectorImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.InjectorShell;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.LookupProcessor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Module;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Stage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.BindingImpl;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.Errors;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.ErrorsException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.InternalContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.internal.Stopwatch;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.spi.Dependency;

class InjectorBuilder {
    private final Stopwatch stopwatch = new Stopwatch();
    private final Errors errors = new Errors();
    private Stage stage;
    private final Initializer initializer = new Initializer();
    private final BindingProcessor bindingProcesor;
    private final InjectionRequestProcessor injectionRequestProcessor;
    private final InjectorShell.Builder shellBuilder = new InjectorShell.Builder();
    private List<InjectorShell> shells;

    InjectorBuilder() {
        this.injectionRequestProcessor = new InjectionRequestProcessor(this.errors, this.initializer);
        this.bindingProcesor = new BindingProcessor(this.errors, this.initializer);
    }

    InjectorBuilder stage(Stage stage) {
        this.shellBuilder.stage(stage);
        this.stage = stage;
        return this;
    }

    InjectorBuilder addModules(Iterable<? extends Module> modules) {
        this.shellBuilder.addModules(modules);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Injector build() {
        if (this.shellBuilder == null) {
            throw new AssertionError((Object)"Already built, builders are not reusable.");
        }
        Object object = this.shellBuilder.lock();
        synchronized (object) {
            this.shells = this.shellBuilder.build(this.initializer, this.bindingProcesor, this.stopwatch, this.errors);
            this.stopwatch.resetAndLog("Injector construction");
            this.initializeStatically();
        }
        this.injectDynamically();
        return this.primaryInjector();
    }

    private void initializeStatically() {
        this.bindingProcesor.initializeBindings();
        this.stopwatch.resetAndLog("Binding initialization");
        for (InjectorShell shell : this.shells) {
            shell.getInjector().index();
        }
        this.stopwatch.resetAndLog("Binding indexing");
        this.injectionRequestProcessor.process(this.shells);
        this.stopwatch.resetAndLog("Collecting injection requests");
        this.bindingProcesor.runCreationListeners();
        this.stopwatch.resetAndLog("Binding validation");
        this.injectionRequestProcessor.validate();
        this.stopwatch.resetAndLog("Static validation");
        this.initializer.validateOustandingInjections(this.errors);
        this.stopwatch.resetAndLog("Instance member validation");
        new LookupProcessor(this.errors).process(this.shells);
        for (InjectorShell shell : this.shells) {
            ((DeferredLookups)shell.getInjector().lookups).initialize(this.errors);
        }
        this.stopwatch.resetAndLog("Provider verification");
        for (InjectorShell shell : this.shells) {
            if (!shell.getElements().isEmpty()) {
                throw new AssertionError((Object)("Failed to execute " + shell.getElements()));
            }
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    private Injector primaryInjector() {
        return this.shells.get(0).getInjector();
    }

    private void injectDynamically() {
        this.injectionRequestProcessor.injectMembers();
        this.stopwatch.resetAndLog("Static member injection");
        this.initializer.injectAll(this.errors);
        this.stopwatch.resetAndLog("Instance injection");
        this.errors.throwCreationExceptionIfErrorsExist();
        for (InjectorShell shell : this.shells) {
            this.loadEagerSingletons(shell.getInjector(), this.stage, this.errors);
        }
        this.stopwatch.resetAndLog("Preloading singletons");
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    public void loadEagerSingletons(InjectorImpl injector, Stage stage, Errors errors) {
        for (Binding<?> binding : injector.state.getExplicitBindingsThisLevel().values()) {
            this.loadEagerSingletons(injector, stage, errors, (BindingImpl)binding);
        }
        for (Binding<?> binding : injector.jitBindings.values()) {
            this.loadEagerSingletons(injector, stage, errors, (BindingImpl)binding);
        }
    }

    private void loadEagerSingletons(InjectorImpl injector, Stage stage, final Errors errors, final BindingImpl<?> binding) {
        if (binding.getScoping().isEagerSingleton(stage)) {
            try {
                injector.callInContext(new ContextualCallable<Void>(){
                    Dependency<?> dependency;
                    {
                        this.dependency = Dependency.get(binding.getKey());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call(InternalContext context) {
                        context.setDependency(this.dependency);
                        Errors errorsForBinding = errors.withSource(this.dependency);
                        try {
                            binding.getInternalFactory().get(errorsForBinding, context, this.dependency);
                        }
                        catch (ErrorsException e) {
                            errorsForBinding.merge(e.getErrors());
                        }
                        finally {
                            context.setDependency(null);
                        }
                        return null;
                    }
                });
            }
            catch (ErrorsException e) {
                throw new AssertionError();
            }
        }
    }
}

