/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.metrics;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class EWMA {
    private static final double M1_ALPHA = 1.0 - Math.exp(-0.08333333333333333);
    private static final double M5_ALPHA = 1.0 - Math.exp(-0.016666666666666666);
    private static final double M15_ALPHA = 1.0 - Math.exp(-0.005555555555555555);
    private volatile boolean initialized = false;
    private volatile double rate = 0.0;
    private final LongAdder uncounted = new LongAdder();
    private final double alpha;
    private final double interval;

    public static EWMA oneMinuteEWMA() {
        return new EWMA(M1_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public static EWMA fiveMinuteEWMA() {
        return new EWMA(M5_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public static EWMA fifteenMinuteEWMA() {
        return new EWMA(M15_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public EWMA(double alpha, long interval, TimeUnit intervalUnit) {
        this.interval = intervalUnit.toNanos(interval);
        this.alpha = alpha;
    }

    public void update(long n) {
        this.uncounted.add(n);
    }

    public void tick() {
        long count = this.uncounted.sumThenReset();
        double instantRate = (double)count / this.interval;
        if (this.initialized) {
            this.rate += this.alpha * (instantRate - this.rate);
        } else {
            this.rate = instantRate;
            this.initialized = true;
        }
    }

    public double rate(TimeUnit rateUnit) {
        return this.rate * (double)rateUnit.toNanos(1L);
    }
}

