/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.metrics;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.metrics.EWMA;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.metrics.Metric;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.concurrent.FutureUtils;

public class MeterMetric
implements Metric {
    private static final long INTERVAL = 5L;
    private final EWMA m1Rate = EWMA.oneMinuteEWMA();
    private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
    private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
    private final LongAdder count = new LongAdder();
    private final long startTime = System.nanoTime();
    private final TimeUnit rateUnit;
    private final ScheduledFuture<?> future;

    public MeterMetric(ScheduledExecutorService tickThread, TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        this.future = tickThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MeterMetric.this.tick();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    void tick() {
        this.m1Rate.tick();
        this.m5Rate.tick();
        this.m15Rate.tick();
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.count.add(n);
        this.m1Rate.update(n);
        this.m5Rate.update(n);
        this.m15Rate.update(n);
    }

    public long count() {
        return this.count.sum();
    }

    public double fifteenMinuteRate() {
        return this.m15Rate.rate(this.rateUnit);
    }

    public double fiveMinuteRate() {
        return this.m5Rate.rate(this.rateUnit);
    }

    public double meanRate() {
        long count = this.count();
        if (count == 0L) {
            return 0.0;
        }
        long elapsed = System.nanoTime() - this.startTime;
        return this.convertNsRate((double)count / (double)elapsed);
    }

    public double oneMinuteRate() {
        return this.m1Rate.rate(this.rateUnit);
    }

    private double convertNsRate(double ratePerNs) {
        return ratePerNs * (double)this.rateUnit.toNanos(1L);
    }

    public void stop() {
        FutureUtils.cancel(this.future);
    }
}

