/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSet;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSpec;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.EnvironmentAwareCommand;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.UserException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.KeyStoreWrapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;

class AddStringKeyStoreCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<Void> stdinOption;
    private final OptionSpec<Void> forceOption;
    private final OptionSpec<String> arguments;

    AddStringKeyStoreCommand() {
        super("Add a string setting to the keystore");
        this.stdinOption = this.parser.acceptsAll(Arrays.asList("x", "stdin"), "Read setting value from stdin");
        this.forceOption = this.parser.acceptsAll(Arrays.asList("f", "force"), "Overwrite existing setting without prompting");
        this.arguments = this.parser.nonOptions("setting name");
    }

    InputStream getStdin() {
        return System.in;
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        char[] value;
        KeyStoreWrapper keystore = KeyStoreWrapper.load(env.configFile());
        if (keystore == null) {
            throw new UserException(65, "Elasticsearch keystore not found. Use 'create' command to create one.");
        }
        keystore.decrypt(new char[0]);
        String setting = this.arguments.value(options);
        if (setting == null) {
            throw new UserException(64, "The setting name can not be null");
        }
        if (keystore.getSettingNames().contains(setting) && !options.has(this.forceOption) && !terminal.promptYesNo("Setting " + setting + " already exists. Overwrite?", false)) {
            terminal.println("Exiting without modifying keystore.");
            return;
        }
        if (options.has(this.stdinOption)) {
            BufferedReader stdinReader = new BufferedReader(new InputStreamReader(this.getStdin(), StandardCharsets.UTF_8));
            value = stdinReader.readLine().toCharArray();
        } else {
            value = terminal.readSecret("Enter value for " + setting + ": ");
        }
        try {
            keystore.setString(setting, value);
        }
        catch (IllegalArgumentException e) {
            throw new UserException(65, "String value must contain only ASCII");
        }
        keystore.save(env.configFile());
    }
}

