/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.ByteSizeUnit;

public class ByteSizeValue
implements Writeable,
Comparable<ByteSizeValue> {
    private final long size;
    private final ByteSizeUnit unit;

    public ByteSizeValue(StreamInput in) throws IOException {
        this.size = in.readVLong();
        this.unit = ByteSizeUnit.BYTES;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.getBytes());
    }

    public ByteSizeValue(long bytes) {
        this(bytes, ByteSizeUnit.BYTES);
    }

    public ByteSizeValue(long size, ByteSizeUnit unit) {
        this.size = size;
        this.unit = unit;
    }

    public int bytesAsInt() {
        long bytes = this.getBytes();
        if (bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size [" + this.toString() + "] is bigger than max int");
        }
        return (int)bytes;
    }

    public long getBytes() {
        return this.unit.toBytes(this.size);
    }

    public long getKb() {
        return this.unit.toKB(this.size);
    }

    public long getMb() {
        return this.unit.toMB(this.size);
    }

    public long getGb() {
        return this.unit.toGB(this.size);
    }

    public long getTb() {
        return this.unit.toTB(this.size);
    }

    public long getPb() {
        return this.unit.toPB(this.size);
    }

    public double getKbFrac() {
        return (double)this.getBytes() / 1024.0;
    }

    public double getMbFrac() {
        return (double)this.getBytes() / 1048576.0;
    }

    public double getGbFrac() {
        return (double)this.getBytes() / 1.073741824E9;
    }

    public double getTbFrac() {
        return (double)this.getBytes() / 1.099511627776E12;
    }

    public double getPbFrac() {
        return (double)this.getBytes() / 1.125899906842624E15;
    }

    public String toString() {
        long bytes = this.getBytes();
        double value = bytes;
        String suffix = "b";
        if (bytes >= 0x4000000000000L) {
            value = this.getPbFrac();
            suffix = "pb";
        } else if (bytes >= 0x10000000000L) {
            value = this.getTbFrac();
            suffix = "tb";
        } else if (bytes >= 0x40000000L) {
            value = this.getGbFrac();
            suffix = "gb";
        } else if (bytes >= 0x100000L) {
            value = this.getMbFrac();
            suffix = "mb";
        } else if (bytes >= 1024L) {
            value = this.getKbFrac();
            suffix = "kb";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue, String settingName) throws ElasticsearchParseException {
        return ByteSizeValue.parseBytesSizeValue(sValue, null, settingName);
    }

    public static ByteSizeValue parseBytesSizeValue(String sValue, ByteSizeValue defaultValue, String settingName) throws ElasticsearchParseException {
        long bytes;
        block16: {
            settingName = Objects.requireNonNull(settingName);
            if (sValue == null) {
                return defaultValue;
            }
            try {
                String lowerSValue = sValue.toLowerCase(Locale.ROOT).trim();
                if (lowerSValue.endsWith("k")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1024.0);
                    break block16;
                }
                if (lowerSValue.endsWith("kb")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1024.0);
                    break block16;
                }
                if (lowerSValue.endsWith("m")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1048576.0);
                    break block16;
                }
                if (lowerSValue.endsWith("mb")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1048576.0);
                    break block16;
                }
                if (lowerSValue.endsWith("g")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.073741824E9);
                    break block16;
                }
                if (lowerSValue.endsWith("gb")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.073741824E9);
                    break block16;
                }
                if (lowerSValue.endsWith("t")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.099511627776E12);
                    break block16;
                }
                if (lowerSValue.endsWith("tb")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.099511627776E12);
                    break block16;
                }
                if (lowerSValue.endsWith("p")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 1)) * 1.125899906842624E15);
                    break block16;
                }
                if (lowerSValue.endsWith("pb")) {
                    bytes = (long)(Double.parseDouble(lowerSValue.substring(0, lowerSValue.length() - 2)) * 1.125899906842624E15);
                    break block16;
                }
                if (lowerSValue.endsWith("b")) {
                    bytes = Long.parseLong(lowerSValue.substring(0, lowerSValue.length() - 1).trim());
                    break block16;
                }
                if (lowerSValue.equals("-1")) {
                    bytes = -1L;
                    break block16;
                }
                if (lowerSValue.equals("0")) {
                    bytes = 0L;
                    break block16;
                }
                throw new ElasticsearchParseException("failed to parse setting [{}] with value [{}] as a size in bytes: unit is missing or unrecognized", settingName, sValue);
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchParseException("failed to parse [{}]", (Throwable)e, sValue);
            }
        }
        return new ByteSizeValue(bytes, ByteSizeUnit.BYTES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((ByteSizeValue)o) == 0;
    }

    public int hashCode() {
        return Double.hashCode((double)this.size * (double)this.unit.toBytes(1L));
    }

    @Override
    public int compareTo(ByteSizeValue other) {
        double thisValue = (double)this.size * (double)this.unit.toBytes(1L);
        double otherValue = (double)other.size * (double)other.unit.toBytes(1L);
        return Double.compare(thisValue, otherValue);
    }
}

