/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit;

import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.ByteSizeUnit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.monitor.jvm.JvmInfo;

public enum MemorySizeValue {


    public static ByteSizeValue parseBytesSizeValueOrHeapRatio(String sValue, String settingName) {
        settingName = Objects.requireNonNull(settingName);
        if (sValue != null && sValue.endsWith("%")) {
            String percentAsString = sValue.substring(0, sValue.length() - 1);
            try {
                double percent = Double.parseDouble(percentAsString);
                if (percent < 0.0 || percent > 100.0) {
                    throw new ElasticsearchParseException("percentage should be in [0-100], got [{}]", percentAsString);
                }
                return new ByteSizeValue((long)(percent / 100.0 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes()), ByteSizeUnit.BYTES);
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchParseException("failed to parse [{}] as a double", (Throwable)e, percentAsString);
            }
        }
        return ByteSizeValue.parseBytesSizeValue(sValue, settingName);
    }
}

