/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.KeepWordFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.Analysis;

public class KeepWordFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet keepWords;
    private static final String KEEP_WORDS_KEY = "keep_words";
    private static final String KEEP_WORDS_PATH_KEY = "keep_words_path";
    private static final String KEEP_WORDS_CASE_KEY = "keep_words_case";
    private static final String ENABLE_POS_INC_KEY = "enable_position_increments";

    public KeepWordFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        String[] arrayKeepWords = settings.getAsArray(KEEP_WORDS_KEY, null);
        String keepWordsPath = settings.get(KEEP_WORDS_PATH_KEY, null);
        if (arrayKeepWords == null && keepWordsPath == null || arrayKeepWords != null && keepWordsPath != null) {
            throw new IllegalArgumentException("keep requires either `keep_words` or `keep_words_path` to be configured");
        }
        if (settings.get(ENABLE_POS_INC_KEY) != null) {
            throw new IllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain");
        }
        this.keepWords = Analysis.getWordSet(env, settings, KEEP_WORDS_KEY);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new KeepWordFilter(tokenStream, this.keepWords);
    }
}

