/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.TokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis.AnalysisModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis.PreBuiltTokenizers;

public class PreBuiltTokenizerFactoryFactory
implements AnalysisModule.AnalysisProvider<TokenizerFactory> {
    private final TokenizerFactory tokenizerFactory;

    public PreBuiltTokenizerFactoryFactory(TokenizerFactory tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    @Override
    public TokenizerFactory get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        PreBuiltTokenizers preBuiltTokenizers;
        Version indexVersion = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltTokenizers = PreBuiltTokenizers.getOrDefault(name, null)) != null) {
            return preBuiltTokenizers.getTokenizerFactory(indexVersion);
        }
        return this.tokenizerFactory;
    }
}

