/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TermInSetQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TermBasedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TextFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Uid;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;

public class IdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_id";
    public static final String CONTENT_TYPE = "_id";

    static MappedFieldType defaultFieldType(IndexSettings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        if (indexSettings.isSingleType()) {
            defaultFieldType.setIndexOptions(IndexOptions.DOCS);
            defaultFieldType.setStored(true);
        } else {
            defaultFieldType.setIndexOptions(IndexOptions.NONE);
            defaultFieldType.setStored(false);
        }
        return defaultFieldType;
    }

    private IdFieldMapper(IndexSettings indexSettings, MappedFieldType existing) {
        this(existing == null ? IdFieldMapper.defaultFieldType(indexSettings) : existing, indexSettings);
    }

    private IdFieldMapper(MappedFieldType fieldType, IndexSettings indexSettings) {
        super("_id", fieldType, IdFieldMapper.defaultFieldType(indexSettings), indexSettings.getSettings());
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field id = new Field("_id", context.sourceToParse().id(), (FieldType)this.fieldType);
            fields.add(id);
        }
    }

    @Override
    protected String contentType() {
        return "_id";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class IdFieldType
    extends TermBasedFieldType {
        IdFieldType() {
        }

        protected IdFieldType(IdFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new IdFieldType(this);
        }

        @Override
        public String typeName() {
            return "_id";
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
            if (this.indexOptions() != IndexOptions.NONE) {
                return super.termsQuery(values, context);
            }
            return new TermInSetQuery("_uid", Uid.createUidsForTypesAndIds(context.queryTypes(), values));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            if (this.indexOptions() == IndexOptions.NONE) {
                throw new IllegalArgumentException("Fielddata access on the _uid field is disallowed");
            }
            return new PagedBytesIndexFieldData.Builder(TextFieldMapper.Defaults.FIELDDATA_MIN_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MAX_FREQUENCY, TextFieldMapper.Defaults.FIELDDATA_MIN_SEGMENT_SIZE);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_id is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            IndexSettings indexSettings = context.mapperService().getIndexSettings();
            return new IdFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Defaults {
        public static final String NAME = "_id";
        public static final MappedFieldType FIELD_TYPE = new IdFieldType();
        public static final MappedFieldType NESTED_FIELD_TYPE;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_id");
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE = FIELD_TYPE.clone();
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

