/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ObjectObjectHashMap;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ObjectObjectMap;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.all.AllEntries;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ContentPath;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DocumentMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DocumentMapperParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.RootObjectMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.SourceToParse;

public abstract class ParseContext {
    public abstract DocumentMapperParser docMapperParser();

    public final ParseContext setIncludeInAllDefault(final boolean includeInAll) {
        return new FilterParseContext(this){

            @Override
            public Boolean getIncludeInAllDefault() {
                return includeInAll;
            }
        };
    }

    public Boolean getIncludeInAllDefault() {
        return null;
    }

    public final ParseContext createCopyToContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinCopyTo() {
                return true;
            }
        };
    }

    public boolean isWithinCopyTo() {
        return false;
    }

    public final ParseContext createMultiFieldContext() {
        return new FilterParseContext(this){

            @Override
            public boolean isWithinMultiFields() {
                return true;
            }
        };
    }

    public final ParseContext createNestedContext(String fullPath) {
        Document doc = new Document(fullPath, this.doc());
        this.addDoc(doc);
        return this.switchDoc(doc);
    }

    public final ParseContext switchDoc(final Document document) {
        return new FilterParseContext(this){

            @Override
            public Document doc() {
                return document;
            }
        };
    }

    public final ParseContext overridePath(final ContentPath path) {
        return new FilterParseContext(this){

            @Override
            public ContentPath path() {
                return path;
            }
        };
    }

    public boolean isWithinMultiFields() {
        return false;
    }

    @Nullable
    public abstract Settings indexSettings();

    public abstract SourceToParse sourceToParse();

    public abstract ContentPath path();

    public abstract XContentParser parser();

    public abstract Document rootDoc();

    public abstract List<Document> docs();

    public abstract Document doc();

    protected abstract void addDoc(Document var1);

    public abstract RootObjectMapper root();

    public abstract DocumentMapper docMapper();

    public abstract MapperService mapperService();

    public abstract Field version();

    public abstract void version(Field var1);

    public final boolean includeInAll(Boolean includeInAll, FieldMapper mapper) {
        return this.includeInAll(includeInAll, mapper.fieldType().indexOptions() != IndexOptions.NONE);
    }

    private boolean includeInAll(Boolean includeInAll, boolean indexed) {
        if (this.isWithinCopyTo()) {
            return false;
        }
        if (this.isWithinMultiFields()) {
            return false;
        }
        if (!this.docMapper().allFieldMapper().enabled()) {
            return false;
        }
        if (includeInAll == null) {
            includeInAll = this.getIncludeInAllDefault();
        }
        if (includeInAll == null) {
            return indexed;
        }
        return includeInAll;
    }

    public abstract AllEntries allEntries();

    public final ParseContext createExternalValueContext(final Object externalValue) {
        return new FilterParseContext(this){

            @Override
            public boolean externalValueSet() {
                return true;
            }

            @Override
            public Object externalValue() {
                return externalValue;
            }
        };
    }

    public boolean externalValueSet() {
        return false;
    }

    public Object externalValue() {
        throw new IllegalStateException("External value is not set");
    }

    public final <T> T parseExternalValue(Class<T> clazz) {
        if (!this.externalValueSet() || this.externalValue() == null) {
            return null;
        }
        if (!clazz.isInstance(this.externalValue())) {
            throw new IllegalArgumentException("illegal external value class [" + this.externalValue().getClass().getName() + "]. Should be " + clazz.getName());
        }
        return clazz.cast(this.externalValue());
    }

    public abstract void addDynamicMapper(Mapper var1);

    public abstract List<Mapper> getDynamicMappers();

    public static class InternalParseContext
    extends ParseContext {
        private final DocumentMapper docMapper;
        private final DocumentMapperParser docMapperParser;
        private final ContentPath path;
        private final XContentParser parser;
        private Document document;
        private final List<Document> documents;
        @Nullable
        private final Settings indexSettings;
        private final SourceToParse sourceToParse;
        private Field version;
        private final AllEntries allEntries;
        private final List<Mapper> dynamicMappers;

        public InternalParseContext(@Nullable Settings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper, SourceToParse source, XContentParser parser) {
            this.indexSettings = indexSettings;
            this.docMapper = docMapper;
            this.docMapperParser = docMapperParser;
            this.path = new ContentPath(0);
            this.parser = parser;
            this.document = new Document();
            this.documents = new ArrayList<Document>();
            this.documents.add(this.document);
            this.version = null;
            this.sourceToParse = source;
            this.allEntries = new AllEntries();
            this.dynamicMappers = new ArrayList<Mapper>();
        }

        @Override
        public DocumentMapperParser docMapperParser() {
            return this.docMapperParser;
        }

        @Override
        @Nullable
        public Settings indexSettings() {
            return this.indexSettings;
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.sourceToParse;
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public Document rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public List<Document> docs() {
            return this.documents;
        }

        @Override
        public Document doc() {
            return this.document;
        }

        @Override
        protected void addDoc(Document doc) {
            this.documents.add(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.docMapper.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        @Override
        public MapperService mapperService() {
            return this.docMapperParser.mapperService;
        }

        @Override
        public Field version() {
            return this.version;
        }

        @Override
        public void version(Field version) {
            this.version = version;
        }

        @Override
        public AllEntries allEntries() {
            return this.allEntries;
        }

        @Override
        public void addDynamicMapper(Mapper mapper) {
            this.dynamicMappers.add(mapper);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.dynamicMappers;
        }
    }

    private static class FilterParseContext
    extends ParseContext {
        private final ParseContext in;

        private FilterParseContext(ParseContext in) {
            this.in = in;
        }

        @Override
        public DocumentMapperParser docMapperParser() {
            return this.in.docMapperParser();
        }

        @Override
        public boolean isWithinCopyTo() {
            return this.in.isWithinCopyTo();
        }

        @Override
        public boolean isWithinMultiFields() {
            return this.in.isWithinMultiFields();
        }

        @Override
        public Settings indexSettings() {
            return this.in.indexSettings();
        }

        @Override
        public SourceToParse sourceToParse() {
            return this.in.sourceToParse();
        }

        @Override
        public ContentPath path() {
            return this.in.path();
        }

        @Override
        public XContentParser parser() {
            return this.in.parser();
        }

        @Override
        public Document rootDoc() {
            return this.in.rootDoc();
        }

        @Override
        public List<Document> docs() {
            return this.in.docs();
        }

        @Override
        public Document doc() {
            return this.in.doc();
        }

        @Override
        protected void addDoc(Document doc) {
            this.in.addDoc(doc);
        }

        @Override
        public RootObjectMapper root() {
            return this.in.root();
        }

        @Override
        public DocumentMapper docMapper() {
            return this.in.docMapper();
        }

        @Override
        public MapperService mapperService() {
            return this.in.mapperService();
        }

        @Override
        public Field version() {
            return this.in.version();
        }

        @Override
        public void version(Field version) {
            this.in.version(version);
        }

        @Override
        public AllEntries allEntries() {
            return this.in.allEntries();
        }

        @Override
        public boolean externalValueSet() {
            return this.in.externalValueSet();
        }

        @Override
        public Object externalValue() {
            return this.in.externalValue();
        }

        @Override
        public void addDynamicMapper(Mapper update) {
            this.in.addDynamicMapper(update);
        }

        @Override
        public List<Mapper> getDynamicMappers() {
            return this.in.getDynamicMappers();
        }
    }

    public static class Document
    implements Iterable<IndexableField> {
        private final Document parent;
        private final String path;
        private final String prefix;
        private final List<IndexableField> fields = new ArrayList<IndexableField>();
        private ObjectObjectMap<Object, IndexableField> keyedFields;

        private Document(String path, Document parent) {
            this.path = path;
            this.prefix = path.isEmpty() ? "" : path + ".";
            this.parent = parent;
        }

        public Document() {
            this("", null);
        }

        public String getPath() {
            return this.path;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Document getParent() {
            return this.parent;
        }

        @Override
        public Iterator<IndexableField> iterator() {
            return this.fields.iterator();
        }

        public List<IndexableField> getFields() {
            return this.fields;
        }

        public void add(IndexableField field) {
            assert (field.name().startsWith("_") || field.name().startsWith(this.prefix)) : field.name() + " " + this.prefix;
            this.fields.add(field);
        }

        public void addWithKey(Object key, IndexableField field) {
            if (this.keyedFields == null) {
                this.keyedFields = new ObjectObjectHashMap<Object, IndexableField>();
            } else if (this.keyedFields.containsKey(key)) {
                throw new IllegalStateException("Only one field can be stored per key");
            }
            this.keyedFields.put(key, field);
            this.add(field);
        }

        public IndexableField getByKey(Object key) {
            return this.keyedFields == null ? null : this.keyedFields.get(key);
        }

        public IndexableField[] getFields(String name) {
            ArrayList<IndexableField> f = new ArrayList<IndexableField>();
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                f.add(field);
            }
            return f.toArray(new IndexableField[f.size()]);
        }

        public final String[] getValues(String name) {
            ArrayList<String> result = new ArrayList<String>();
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name) || field.stringValue() == null) continue;
                result.add(field.stringValue());
            }
            return result.toArray(new String[result.size()]);
        }

        public IndexableField getField(String name) {
            for (IndexableField field : this.fields) {
                if (!field.name().equals(name)) continue;
                return field;
            }
            return null;
        }

        public String get(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.stringValue() == null) continue;
                return f.stringValue();
            }
            return null;
        }

        public BytesRef getBinaryValue(String name) {
            for (IndexableField f : this.fields) {
                if (!f.name().equals(name) || f.binaryValue() == null) continue;
                return f.binaryValue();
            }
            return null;
        }
    }
}

