/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.LatLonDocValuesField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.LatLonPoint;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.Rectangle;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexOrDocValuesQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Numbers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.GeoHashUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.GeoPoint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.GeoUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.BaseGeoPointFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LatLonPointFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeoExecType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.GeoValidationMethod;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.search.geo.LegacyInMemoryGeoBoundingBoxQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.search.geo.LegacyIndexedGeoBoundingBoxQuery;

public class GeoBoundingBoxQueryBuilder
extends AbstractQueryBuilder<GeoBoundingBoxQueryBuilder> {
    public static final String NAME = "geo_bounding_box";
    public static final ParseField QUERY_NAME_FIELD = new ParseField("geo_bounding_box", "geo_bbox");
    public static final GeoExecType DEFAULT_TYPE = GeoExecType.MEMORY;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField COERCE_FIELD = new ParseField("coerce", "normalize").withAllDeprecated("validation_method");
    private static final ParseField IGNORE_MALFORMED_FIELD = new ParseField("ignore_malformed", new String[0]).withAllDeprecated("validation_method");
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField TOP_FIELD = new ParseField("top", new String[0]);
    private static final ParseField BOTTOM_FIELD = new ParseField("bottom", new String[0]);
    private static final ParseField LEFT_FIELD = new ParseField("left", new String[0]);
    private static final ParseField RIGHT_FIELD = new ParseField("right", new String[0]);
    private static final ParseField TOP_LEFT_FIELD = new ParseField("top_left", new String[0]);
    private static final ParseField BOTTOM_RIGHT_FIELD = new ParseField("bottom_right", new String[0]);
    private static final ParseField TOP_RIGHT_FIELD = new ParseField("top_right", new String[0]);
    private static final ParseField BOTTOM_LEFT_FIELD = new ParseField("bottom_left", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private GeoPoint topLeft = new GeoPoint(Double.NaN, Double.NaN);
    private GeoPoint bottomRight = new GeoPoint(Double.NaN, Double.NaN);
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private GeoExecType type = DEFAULT_TYPE;
    private boolean ignoreUnmapped = false;

    public GeoBoundingBoxQueryBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name must not be empty.");
        }
        this.fieldName = fieldName;
    }

    public GeoBoundingBoxQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.topLeft = in.readGeoPoint();
        this.bottomRight = in.readGeoPoint();
        this.type = GeoExecType.readFromStream(in);
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGeoPoint(this.topLeft);
        out.writeGeoPoint(this.bottomRight);
        this.type.writeTo(out);
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public GeoBoundingBoxQueryBuilder setCorners(double top, double left, double bottom, double right) {
        if (!GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            if (!Numbers.isValidDouble(top)) {
                throw new IllegalArgumentException("top latitude is invalid: " + top);
            }
            if (!Numbers.isValidDouble(left)) {
                throw new IllegalArgumentException("left longitude is invalid: " + left);
            }
            if (!Numbers.isValidDouble(bottom)) {
                throw new IllegalArgumentException("bottom latitude is invalid: " + bottom);
            }
            if (!Numbers.isValidDouble(right)) {
                throw new IllegalArgumentException("right longitude is invalid: " + right);
            }
            if (top < bottom) {
                throw new IllegalArgumentException("top is below bottom corner: " + top + " vs. " + bottom);
            }
            if (top == bottom) {
                throw new IllegalArgumentException("top cannot be the same as bottom: " + top + " == " + bottom);
            }
            if (left == right) {
                throw new IllegalArgumentException("left cannot be the same as right: " + left + " == " + right);
            }
        }
        this.topLeft.reset(top, left);
        this.bottomRight.reset(bottom, right);
        return this;
    }

    public GeoBoundingBoxQueryBuilder setCorners(GeoPoint topLeft, GeoPoint bottomRight) {
        return this.setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCorners(String geohash) {
        Rectangle ghBBox = GeoHashUtils.bbox(geohash);
        return this.setCorners(new GeoPoint(ghBBox.maxLat, ghBBox.minLon), new GeoPoint(ghBBox.minLat, ghBBox.maxLon));
    }

    public GeoBoundingBoxQueryBuilder setCorners(String topLeft, String bottomRight) {
        return this.setCorners(GeoPoint.fromGeohash(topLeft), GeoPoint.fromGeohash(bottomRight));
    }

    public GeoPoint topLeft() {
        return this.topLeft;
    }

    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(GeoPoint bottomLeft, GeoPoint topRight) {
        return this.setCorners(topRight.getLat(), bottomLeft.getLon(), bottomLeft.getLat(), topRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(String bottomLeft, String topRight) {
        return this.setCornersOGC(GeoPoint.fromGeohash(bottomLeft), GeoPoint.fromGeohash(topRight));
    }

    public GeoBoundingBoxQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoBoundingBoxQueryBuilder type(GeoExecType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is not allowed to be null.");
        }
        this.type = type;
        return this;
    }

    public GeoBoundingBoxQueryBuilder type(String type) {
        this.type = GeoExecType.fromString(type);
        return this;
    }

    public GeoExecType type() {
        return this.type;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoBoundingBoxQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    QueryValidationException checkLatLon(boolean indexCreatedBeforeV2_0) {
        if (GeoValidationMethod.isIgnoreMalformed(this.validationMethod) || indexCreatedBeforeV2_0) {
            return null;
        }
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude(this.topLeft.getLat())) {
            validationException = this.addValidationError("top latitude is invalid: " + this.topLeft.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(this.topLeft.getLon())) {
            validationException = this.addValidationError("left longitude is invalid: " + this.topLeft.getLon(), validationException);
        }
        if (!GeoUtils.isValidLatitude(this.bottomRight.getLat())) {
            validationException = this.addValidationError("bottom latitude is invalid: " + this.bottomRight.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(this.bottomRight.getLon())) {
            validationException = this.addValidationError("right longitude is invalid: " + this.bottomRight.getLon(), validationException);
        }
        return validationException;
    }

    @Override
    public Query doToQuery(QueryShardContext context) {
        Query query;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "failed to find geo_point field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context, "field [" + this.fieldName + "] is not a geo_point field", new Object[0]);
        }
        QueryValidationException exception = this.checkLatLon(context.indexVersionCreated().before(Version.V_2_0_0));
        if (exception != null) {
            throw new QueryShardException(context, "couldn't validate latitude/ longitude values", exception, new Object[0]);
        }
        GeoPoint luceneTopLeft = new GeoPoint(this.topLeft);
        GeoPoint luceneBottomRight = new GeoPoint(this.bottomRight);
        Version indexVersionCreated = context.indexVersionCreated();
        if (indexVersionCreated.onOrAfter(Version.V_2_2_0) || GeoValidationMethod.isCoerce(this.validationMethod)) {
            double left;
            double right = luceneBottomRight.getLon();
            boolean completeLonRange = (right - (left = luceneTopLeft.getLon())) % 360.0 == 0.0 && right > left;
            GeoUtils.normalizePoint(luceneTopLeft, true, !completeLonRange);
            GeoUtils.normalizePoint(luceneBottomRight, true, !completeLonRange);
            if (completeLonRange) {
                luceneTopLeft.resetLon(-180.0);
                luceneBottomRight.resetLon(180.0);
            }
        }
        if (indexVersionCreated.onOrAfter(LatLonPointFieldMapper.LAT_LON_FIELD_VERSION)) {
            Query query2 = LatLonPoint.newBoxQuery(fieldType.name(), luceneBottomRight.getLat(), luceneTopLeft.getLat(), luceneTopLeft.getLon(), luceneBottomRight.getLon());
            if (fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newBoxQuery(fieldType.name(), luceneBottomRight.getLat(), luceneTopLeft.getLat(), luceneTopLeft.getLon(), luceneBottomRight.getLon());
                query2 = new IndexOrDocValuesQuery(query2, dvQuery);
            }
            return query2;
        }
        if (indexVersionCreated.onOrAfter(Version.V_2_2_0)) {
            GeoPointField.TermEncoding encoding = indexVersionCreated.before(Version.V_2_3_0) ? GeoPointField.TermEncoding.NUMERIC : GeoPointField.TermEncoding.PREFIX;
            return new GeoPointInBBoxQuery(fieldType.name(), encoding, luceneBottomRight.lat(), luceneTopLeft.lat(), luceneTopLeft.lon(), luceneBottomRight.lon());
        }
        switch (this.type) {
            case INDEXED: {
                BaseGeoPointFieldMapper.LegacyGeoPointFieldType geoFieldType = (BaseGeoPointFieldMapper.LegacyGeoPointFieldType)fieldType;
                query = LegacyIndexedGeoBoundingBoxQuery.create(luceneTopLeft, luceneBottomRight, geoFieldType, context);
                break;
            }
            case MEMORY: {
                IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)context.getForField(fieldType);
                query = new LegacyInMemoryGeoBoundingBoxQuery(luceneTopLeft, luceneBottomRight, indexFieldData);
                break;
            }
            default: {
                throw new IllegalStateException("geo bounding box type [" + this.type + "] not supported.");
            }
        }
        return query;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.array(TOP_LEFT_FIELD.getPreferredName(), this.topLeft.getLon(), this.topLeft.getLat());
        builder.array(BOTTOM_RIGHT_FIELD.getPreferredName(), this.bottomRight.getLon(), this.bottomRight.getLat());
        builder.endObject();
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), this.validationMethod);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<GeoBoundingBoxQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        double top = Double.NaN;
        double bottom = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        boolean coerce = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        boolean ignoreMalformed = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        GeoPoint sparse = new GeoPoint();
        String type = "memory";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
                        if (FIELD_FIELD.match(currentFieldName)) {
                            fieldName = parser.text();
                            continue;
                        }
                        if (TOP_FIELD.match(currentFieldName)) {
                            top = parser.doubleValue();
                            continue;
                        }
                        if (BOTTOM_FIELD.match(currentFieldName)) {
                            bottom = parser.doubleValue();
                            continue;
                        }
                        if (LEFT_FIELD.match(currentFieldName)) {
                            left = parser.doubleValue();
                            continue;
                        }
                        if (RIGHT_FIELD.match(currentFieldName)) {
                            right = parser.doubleValue();
                            continue;
                        }
                        if (TOP_LEFT_FIELD.match(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            top = sparse.getLat();
                            left = sparse.getLon();
                            continue;
                        }
                        if (BOTTOM_RIGHT_FIELD.match(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            bottom = sparse.getLat();
                            right = sparse.getLon();
                            continue;
                        }
                        if (TOP_RIGHT_FIELD.match(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            top = sparse.getLat();
                            right = sparse.getLon();
                            continue;
                        }
                        if (BOTTOM_LEFT_FIELD.match(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            bottom = sparse.getLat();
                            left = sparse.getLon();
                            continue;
                        }
                        throw new ElasticsearchParseException("failed to parse [{}] query. unexpected field [{}]", QUERY_NAME_FIELD.getPreferredName(), currentFieldName);
                    }
                    throw new ElasticsearchParseException("failed to parse [{}] query. field name expected but [{}] found", new Object[]{QUERY_NAME_FIELD.getPreferredName(), token});
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (COERCE_FIELD.match(currentFieldName)) {
                coerce = parser.booleanValue();
                if (!coerce) continue;
                ignoreMalformed = true;
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName)) {
                validationMethod = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (TYPE_FIELD.match(currentFieldName)) {
                type = parser.text();
                continue;
            }
            if (IGNORE_MALFORMED_FIELD.match(currentFieldName)) {
                ignoreMalformed = parser.booleanValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", QUERY_NAME_FIELD.getPreferredName(), currentFieldName);
        }
        GeoPoint topLeft = sparse.reset(top, left);
        GeoPoint bottomRight = new GeoPoint(bottom, right);
        GeoBoundingBoxQueryBuilder builder = new GeoBoundingBoxQueryBuilder(fieldName);
        builder.setCorners(topLeft, bottomRight);
        builder.queryName(queryName);
        builder.boost(boost);
        builder.type(GeoExecType.fromString(type));
        builder.ignoreUnmapped(ignoreUnmapped);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        } else {
            builder.setValidationMethod(GeoValidationMethod.infer(coerce, ignoreMalformed));
        }
        return Optional.of(builder);
    }

    @Override
    protected boolean doEquals(GeoBoundingBoxQueryBuilder other) {
        return Objects.equals(this.topLeft, other.topLeft) && Objects.equals(this.bottomRight, other.bottomRight) && Objects.equals(this.type, other.type) && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.topLeft, this.bottomRight, this.type, this.validationMethod, this.fieldName, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

