/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors.MultiTermVectorsItemResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.VersionType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.StringFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.TextFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Uid;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryRewriteContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardException;

public class MoreLikeThisQueryBuilder
extends AbstractQueryBuilder<MoreLikeThisQueryBuilder> {
    public static final String NAME = "more_like_this";
    public static final ParseField QUERY_NAME_FIELD = new ParseField("more_like_this", "mlt");
    public static final int DEFAULT_MAX_QUERY_TERMS = 25;
    public static final int DEFAULT_MIN_TERM_FREQ = 2;
    public static final int DEFAULT_MIN_DOC_FREQ = 5;
    public static final int DEFAULT_MAX_DOC_FREQ = Integer.MAX_VALUE;
    public static final int DEFAULT_MIN_WORD_LENGTH = 0;
    public static final int DEFAULT_MAX_WORD_LENGTH = 0;
    public static final String DEFAULT_MINIMUM_SHOULD_MATCH = "30%";
    public static final float DEFAULT_BOOST_TERMS = 0.0f;
    public static final boolean DEFAULT_INCLUDE = false;
    public static final boolean DEFAULT_FAIL_ON_UNSUPPORTED_FIELDS = true;
    private static final Set<Class<? extends MappedFieldType>> SUPPORTED_FIELD_TYPES = new HashSet<Class>(Arrays.asList(StringFieldMapper.StringFieldType.class, TextFieldMapper.TextFieldType.class, KeywordFieldMapper.KeywordFieldType.class));
    private final String[] fields;
    private final String[] likeTexts;
    private String[] unlikeTexts = Strings.EMPTY_ARRAY;
    private final Item[] likeItems;
    private Item[] unlikeItems = new Item[0];
    private int maxQueryTerms = 25;
    private int minTermFreq = 2;
    private int minDocFreq = 5;
    private int maxDocFreq = Integer.MAX_VALUE;
    private int minWordLength = 0;
    private int maxWordLength = 0;
    private String[] stopWords;
    private String analyzer;
    private String minimumShouldMatch = "30%";
    private float boostTerms = 0.0f;
    private boolean include = false;
    private boolean failOnUnsupportedField = true;

    public MoreLikeThisQueryBuilder(String[] likeTexts, Item[] likeItems) {
        this(null, likeTexts, likeItems);
    }

    public MoreLikeThisQueryBuilder(@Nullable String[] fields, @Nullable String[] likeTexts, @Nullable Item[] likeItems) {
        if (fields != null && fields.length == 0) {
            throw new IllegalArgumentException("more_like_this query requires 'fields' to be specified");
        }
        if (!(likeTexts != null && likeTexts.length != 0 || likeItems != null && likeItems.length != 0)) {
            throw new IllegalArgumentException("more_like_this query requires either 'like' texts or items to be specified.");
        }
        this.fields = fields;
        this.likeTexts = Optional.ofNullable(likeTexts).orElse(Strings.EMPTY_ARRAY);
        this.likeItems = Optional.ofNullable(likeItems).orElse(new Item[0]);
    }

    public MoreLikeThisQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readOptionalStringArray();
        this.likeTexts = in.readStringArray();
        this.likeItems = in.readList(Item::new).toArray(new Item[0]);
        this.unlikeTexts = in.readStringArray();
        this.unlikeItems = in.readList(Item::new).toArray(new Item[0]);
        this.maxQueryTerms = in.readVInt();
        this.minTermFreq = in.readVInt();
        this.minDocFreq = in.readVInt();
        this.maxDocFreq = in.readVInt();
        this.minWordLength = in.readVInt();
        this.maxWordLength = in.readVInt();
        this.stopWords = in.readOptionalStringArray();
        this.analyzer = in.readOptionalString();
        this.minimumShouldMatch = in.readString();
        this.boostTerms = ((Float)in.readGenericValue()).floatValue();
        this.include = in.readBoolean();
        this.failOnUnsupportedField = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalStringArray(this.fields);
        out.writeStringArray(this.likeTexts);
        out.writeList(Arrays.asList(this.likeItems));
        out.writeStringArray(this.unlikeTexts);
        out.writeList(Arrays.asList(this.unlikeItems));
        out.writeVInt(this.maxQueryTerms);
        out.writeVInt(this.minTermFreq);
        out.writeVInt(this.minDocFreq);
        out.writeVInt(this.maxDocFreq);
        out.writeVInt(this.minWordLength);
        out.writeVInt(this.maxWordLength);
        out.writeOptionalStringArray(this.stopWords);
        out.writeOptionalString(this.analyzer);
        out.writeString(this.minimumShouldMatch);
        out.writeGenericValue(Float.valueOf(this.boostTerms));
        out.writeBoolean(this.include);
        out.writeBoolean(this.failOnUnsupportedField);
    }

    public String[] fields() {
        return this.fields;
    }

    public String[] likeTexts() {
        return this.likeTexts;
    }

    public Item[] likeItems() {
        return this.likeItems;
    }

    public MoreLikeThisQueryBuilder unlike(String[] unlikeTexts) {
        this.unlikeTexts = Optional.ofNullable(unlikeTexts).orElse(Strings.EMPTY_ARRAY);
        return this;
    }

    public String[] unlikeTexts() {
        return this.unlikeTexts;
    }

    public MoreLikeThisQueryBuilder unlike(Item[] unlikeItems) {
        this.unlikeItems = Optional.ofNullable(unlikeItems).orElse(new Item[0]);
        return this;
    }

    public Item[] unlikeItems() {
        return this.unlikeItems;
    }

    public MoreLikeThisQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public int maxQueryTerms() {
        return this.maxQueryTerms;
    }

    public MoreLikeThisQueryBuilder minTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
        return this;
    }

    public int minTermFreq() {
        return this.minTermFreq;
    }

    public MoreLikeThisQueryBuilder minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public MoreLikeThisQueryBuilder maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public int maxDocFreq() {
        return this.maxDocFreq;
    }

    public MoreLikeThisQueryBuilder minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public int minWordLength() {
        return this.minWordLength;
    }

    public MoreLikeThisQueryBuilder maxWordLength(int maxWordLength) {
        this.maxWordLength = maxWordLength;
        return this;
    }

    public int maxWordLength() {
        return this.maxWordLength;
    }

    public MoreLikeThisQueryBuilder stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public MoreLikeThisQueryBuilder stopWords(List<String> stopWords) {
        if (stopWords == null) {
            throw new IllegalArgumentException("requires stopwords to be non-null");
        }
        this.stopWords = stopWords.toArray(new String[stopWords.size()]);
        return this;
    }

    public String[] stopWords() {
        return this.stopWords;
    }

    public MoreLikeThisQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public MoreLikeThisQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        if (minimumShouldMatch == null) {
            throw new IllegalArgumentException("[more_like_this] requires minimum should match to be non-null");
        }
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public MoreLikeThisQueryBuilder boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public float boostTerms() {
        return this.boostTerms;
    }

    public MoreLikeThisQueryBuilder include(boolean include) {
        this.include = include;
        return this;
    }

    public boolean include() {
        return this.include;
    }

    public MoreLikeThisQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    public boolean failOnUnsupportedField() {
        return this.failOnUnsupportedField;
    }

    @Deprecated
    public static Item[] ids(String ... ids) {
        Item[] items = new Item[ids.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new Item(null, null, ids[i]);
        }
        return items;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.fields != null) {
            builder.array(Field.FIELDS.getPreferredName(), this.fields);
        }
        MoreLikeThisQueryBuilder.buildLikeField(builder, Field.LIKE.getPreferredName(), this.likeTexts, this.likeItems);
        MoreLikeThisQueryBuilder.buildLikeField(builder, Field.UNLIKE.getPreferredName(), this.unlikeTexts, this.unlikeItems);
        builder.field(Field.MAX_QUERY_TERMS.getPreferredName(), this.maxQueryTerms);
        builder.field(Field.MIN_TERM_FREQ.getPreferredName(), this.minTermFreq);
        builder.field(Field.MIN_DOC_FREQ.getPreferredName(), this.minDocFreq);
        builder.field(Field.MAX_DOC_FREQ.getPreferredName(), this.maxDocFreq);
        builder.field(Field.MIN_WORD_LENGTH.getPreferredName(), this.minWordLength);
        builder.field(Field.MAX_WORD_LENGTH.getPreferredName(), this.maxWordLength);
        if (this.stopWords != null) {
            builder.array(Field.STOP_WORDS.getPreferredName(), this.stopWords);
        }
        if (this.analyzer != null) {
            builder.field(Field.ANALYZER.getPreferredName(), this.analyzer);
        }
        builder.field(Field.MINIMUM_SHOULD_MATCH.getPreferredName(), this.minimumShouldMatch);
        builder.field(Field.BOOST_TERMS.getPreferredName(), this.boostTerms);
        builder.field(Field.INCLUDE.getPreferredName(), this.include);
        builder.field(Field.FAIL_ON_UNSUPPORTED_FIELD.getPreferredName(), this.failOnUnsupportedField);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<MoreLikeThisQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ArrayList<String> fields = null;
        ArrayList<String> likeTexts = new ArrayList<String>();
        ArrayList<String> unlikeTexts = new ArrayList<String>();
        ArrayList<Item> likeItems = new ArrayList<Item>();
        ArrayList<Item> unlikeItems = new ArrayList<Item>();
        int maxQueryTerms = 25;
        int minTermFreq = 2;
        int minDocFreq = 5;
        int maxDocFreq = Integer.MAX_VALUE;
        int minWordLength = 0;
        int maxWordLength = 0;
        ArrayList<String> stopWords = null;
        String analyzer = null;
        String minimumShouldMatch = DEFAULT_MINIMUM_SHOULD_MATCH;
        float boostTerms = 0.0f;
        boolean include = false;
        boolean failOnUnsupportedField = true;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (Field.LIKE.match(currentFieldName)) {
                    MoreLikeThisQueryBuilder.parseLikeField(parseContext, likeTexts, likeItems);
                    continue;
                }
                if (Field.UNLIKE.match(currentFieldName)) {
                    MoreLikeThisQueryBuilder.parseLikeField(parseContext, unlikeTexts, unlikeItems);
                    continue;
                }
                if (Field.LIKE_TEXT.match(currentFieldName)) {
                    likeTexts.add(parser.text());
                    continue;
                }
                if (Field.MAX_QUERY_TERMS.match(currentFieldName)) {
                    maxQueryTerms = parser.intValue();
                    continue;
                }
                if (Field.MIN_TERM_FREQ.match(currentFieldName)) {
                    minTermFreq = parser.intValue();
                    continue;
                }
                if (Field.MIN_DOC_FREQ.match(currentFieldName)) {
                    minDocFreq = parser.intValue();
                    continue;
                }
                if (Field.MAX_DOC_FREQ.match(currentFieldName)) {
                    maxDocFreq = parser.intValue();
                    continue;
                }
                if (Field.MIN_WORD_LENGTH.match(currentFieldName)) {
                    minWordLength = parser.intValue();
                    continue;
                }
                if (Field.MAX_WORD_LENGTH.match(currentFieldName)) {
                    maxWordLength = parser.intValue();
                    continue;
                }
                if (Field.ANALYZER.match(currentFieldName)) {
                    analyzer = parser.text();
                    continue;
                }
                if (Field.MINIMUM_SHOULD_MATCH.match(currentFieldName)) {
                    minimumShouldMatch = parser.text();
                    continue;
                }
                if (Field.BOOST_TERMS.match(currentFieldName)) {
                    boostTerms = parser.floatValue();
                    continue;
                }
                if (Field.INCLUDE.match(currentFieldName)) {
                    include = parser.booleanValue();
                    continue;
                }
                if (Field.FAIL_ON_UNSUPPORTED_FIELD.match(currentFieldName)) {
                    failOnUnsupportedField = parser.booleanValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (Field.FIELDS.match(currentFieldName)) {
                    fields = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        fields.add(parser.text());
                    }
                    continue;
                }
                if (Field.LIKE.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        MoreLikeThisQueryBuilder.parseLikeField(parseContext, likeTexts, likeItems);
                    }
                    continue;
                }
                if (Field.UNLIKE.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        MoreLikeThisQueryBuilder.parseLikeField(parseContext, unlikeTexts, unlikeItems);
                    }
                    continue;
                }
                if (Field.IDS.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException("ids array element should only contain ids");
                        }
                        likeItems.add(new Item(null, null, parser.text()));
                    }
                    continue;
                }
                if (Field.DOCS.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token != XContentParser.Token.START_OBJECT) {
                            throw new IllegalArgumentException("docs array element should include an object");
                        }
                        likeItems.add(Item.parse(parser, new Item()));
                    }
                    continue;
                }
                if (Field.STOP_WORDS.match(currentFieldName)) {
                    stopWords = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        stopWords.add(parser.text());
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            if (Field.LIKE.match(currentFieldName)) {
                MoreLikeThisQueryBuilder.parseLikeField(parseContext, likeTexts, likeItems);
                continue;
            }
            if (Field.UNLIKE.match(currentFieldName)) {
                MoreLikeThisQueryBuilder.parseLikeField(parseContext, unlikeTexts, unlikeItems);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[mlt] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (likeTexts.isEmpty() && likeItems.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "more_like_this requires 'like' to be specified", new Object[0]);
        }
        if (fields != null && fields.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "more_like_this requires 'fields' to be non-empty", new Object[0]);
        }
        String[] fieldsArray = fields == null ? null : fields.toArray(new String[fields.size()]);
        String[] likeTextsArray = likeTexts.isEmpty() ? null : likeTexts.toArray(new String[likeTexts.size()]);
        String[] unlikeTextsArray = unlikeTexts.isEmpty() ? null : unlikeTexts.toArray(new String[unlikeTexts.size()]);
        Item[] likeItemsArray = likeItems.isEmpty() ? null : likeItems.toArray(new Item[likeItems.size()]);
        Item[] unlikeItemsArray = unlikeItems.isEmpty() ? null : unlikeItems.toArray(new Item[unlikeItems.size()]);
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = (MoreLikeThisQueryBuilder)((MoreLikeThisQueryBuilder)new MoreLikeThisQueryBuilder(fieldsArray, likeTextsArray, likeItemsArray).unlike(unlikeTextsArray).unlike(unlikeItemsArray).maxQueryTerms(maxQueryTerms).minTermFreq(minTermFreq).minDocFreq(minDocFreq).maxDocFreq(maxDocFreq).minWordLength(minWordLength).maxWordLength(maxWordLength).analyzer(analyzer).minimumShouldMatch(minimumShouldMatch).boostTerms(boostTerms).include(include).failOnUnsupportedField(failOnUnsupportedField).boost(boost)).queryName(queryName);
        if (stopWords != null) {
            moreLikeThisQueryBuilder.stopWords(stopWords);
        }
        return Optional.of(moreLikeThisQueryBuilder);
    }

    private static void parseLikeField(QueryParseContext parseContext, List<String> texts, List<Item> items) throws IOException {
        XContentParser parser = parseContext.parser();
        if (parser.currentToken().isValue()) {
            texts.add(parser.text());
        } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            items.add(Item.parse(parser, new Item()));
        } else {
            throw new IllegalArgumentException("Content of 'like' parameter should either be a string or an object");
        }
    }

    private static void buildLikeField(XContentBuilder builder, String fieldName, String[] texts, Item[] items) throws IOException {
        if (texts.length > 0 || items.length > 0) {
            builder.startArray(fieldName);
            for (String text : texts) {
                builder.value(text);
            }
            for (Item item : items) {
                builder.value((Object)item);
            }
            builder.endArray();
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Analyzer analyzerObj;
        Item[] likeItems = new Item[this.likeItems.length];
        for (int i = 0; i < likeItems.length; ++i) {
            likeItems[i] = new Item(this.likeItems[i]);
        }
        Item[] unlikeItems = new Item[this.unlikeItems.length];
        for (int i = 0; i < unlikeItems.length; ++i) {
            unlikeItems[i] = new Item(this.unlikeItems[i]);
        }
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setSimilarity(context.getSearchSimilarity());
        mltQuery.setMaxQueryTerms(this.maxQueryTerms);
        mltQuery.setMinTermFrequency(this.minTermFreq);
        mltQuery.setMinDocFreq(this.minDocFreq);
        mltQuery.setMaxDocFreq(this.maxDocFreq);
        mltQuery.setMinWordLen(this.minWordLength);
        mltQuery.setMaxWordLen(this.maxWordLength);
        mltQuery.setMinimumShouldMatch(this.minimumShouldMatch);
        if (this.stopWords != null) {
            mltQuery.setStopWords(new HashSet<String>(Arrays.asList(this.stopWords)));
        }
        if (this.boostTerms != 0.0f) {
            mltQuery.setBoostTerms(true);
            mltQuery.setBoostTermsFactor(this.boostTerms);
        }
        if ((analyzerObj = context.getIndexAnalyzers().get(this.analyzer)) == null) {
            analyzerObj = context.getMapperService().searchAnalyzer();
        }
        mltQuery.setAnalyzer(analyzerObj);
        boolean useDefaultField = this.fields == null;
        List<Object> moreLikeFields = new ArrayList();
        if (useDefaultField) {
            moreLikeFields = Collections.singletonList(context.defaultField());
        } else {
            for (String field : this.fields) {
                MappedFieldType fieldType = context.fieldMapper(field);
                if (fieldType != null && !SUPPORTED_FIELD_TYPES.contains(fieldType.getClass())) {
                    if (!this.failOnUnsupportedField) continue;
                    throw new IllegalArgumentException("more_like_this only supports text/keyword fields: [" + field + "]");
                }
                moreLikeFields.add(fieldType == null ? field : fieldType.name());
            }
        }
        if (moreLikeFields.isEmpty()) {
            return null;
        }
        mltQuery.setMoreLikeFields(moreLikeFields.toArray(new String[moreLikeFields.size()]));
        if (this.likeTexts.length > 0) {
            mltQuery.setLikeText(this.likeTexts);
        }
        if (this.unlikeTexts.length > 0) {
            mltQuery.setUnlikeText(this.unlikeTexts);
        }
        if (likeItems.length > 0) {
            return this.handleItems(context, mltQuery, likeItems, unlikeItems, this.include, moreLikeFields, useDefaultField);
        }
        return mltQuery;
    }

    private Query handleItems(QueryShardContext context, MoreLikeThisQuery mltQuery, Item[] likeItems, Item[] unlikeItems, boolean include, List<String> moreLikeFields, boolean useDefaultField) throws IOException {
        MultiTermVectorsResponse unlikeItemsResponse;
        Fields[] unlikeFields;
        for (Item item : likeItems) {
            MoreLikeThisQueryBuilder.setDefaultIndexTypeFields(context, item, moreLikeFields, useDefaultField);
        }
        for (Item item : unlikeItems) {
            MoreLikeThisQueryBuilder.setDefaultIndexTypeFields(context, item, moreLikeFields, useDefaultField);
        }
        MultiTermVectorsResponse likeItemsResponse = this.fetchResponse(context.getClient(), likeItems);
        mltQuery.setLikeFields(MoreLikeThisQueryBuilder.getFieldsFor(likeItemsResponse));
        if (unlikeItems.length > 0 && (unlikeFields = MoreLikeThisQueryBuilder.getFieldsFor(unlikeItemsResponse = this.fetchResponse(context.getClient(), unlikeItems))).length > 0) {
            mltQuery.setUnlikeFields(unlikeFields);
        }
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        boolQuery.add(mltQuery, BooleanClause.Occur.SHOULD);
        if (!include) {
            MoreLikeThisQueryBuilder.handleExclude(boolQuery, likeItems, context);
        }
        return boolQuery.build();
    }

    private static void setDefaultIndexTypeFields(QueryShardContext context, Item item, List<String> moreLikeFields, boolean useDefaultField) {
        if (item.index() == null) {
            item.index(context.index().getName());
        }
        if (item.type() == null) {
            if (context.queryTypes().size() > 1) {
                throw new QueryShardException(context, "ambiguous type for item with id: " + item.id() + " and index: " + item.index(), new Object[0]);
            }
            item.type(context.queryTypes().iterator().next());
        }
        if ((item.fields() == null || item.fields().length == 0) && item.doc() == null) {
            if (useDefaultField) {
                item.fields("*");
            } else {
                item.fields(moreLikeFields.toArray(new String[moreLikeFields.size()]));
            }
        }
    }

    private MultiTermVectorsResponse fetchResponse(Client client, Item[] items) throws IOException {
        MultiTermVectorsRequest request = new MultiTermVectorsRequest();
        for (Item item : items) {
            request.add(item.toTermVectorsRequest());
        }
        return client.multiTermVectors(request).actionGet();
    }

    private static Fields[] getFieldsFor(MultiTermVectorsResponse responses) throws IOException {
        ArrayList<Fields> likeFields = new ArrayList<Fields>();
        for (MultiTermVectorsItemResponse response : responses) {
            TermVectorsResponse getResponse;
            if (response.isFailed() || !(getResponse = response.getResponse()).isExists()) continue;
            likeFields.add(getResponse.getFields());
        }
        return likeFields.toArray(Fields.EMPTY_ARRAY);
    }

    private static void handleExclude(BooleanQuery.Builder boolQuery, Item[] likeItems, QueryShardContext context) {
        MappedFieldType uidField = context.fieldMapper("_uid");
        if (uidField == null) {
            return;
        }
        ArrayList<BytesRef> uids = new ArrayList<BytesRef>();
        for (Item item : likeItems) {
            if (item.doc() != null) continue;
            uids.add(Uid.createUidAsBytes(item.type(), item.id()));
        }
        if (!uids.isEmpty()) {
            Query query = uidField.termsQuery(uids, context);
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Arrays.hashCode(this.fields), Arrays.hashCode(this.likeTexts), Arrays.hashCode(this.unlikeTexts), Arrays.hashCode(this.likeItems), Arrays.hashCode(this.unlikeItems), this.maxQueryTerms, this.minTermFreq, this.minDocFreq, this.maxDocFreq, this.minWordLength, this.maxWordLength, Arrays.hashCode(this.stopWords), this.analyzer, this.minimumShouldMatch, Float.valueOf(this.boostTerms), this.include, this.failOnUnsupportedField);
    }

    @Override
    protected boolean doEquals(MoreLikeThisQueryBuilder other) {
        return Arrays.equals(this.fields, other.fields) && Arrays.equals(this.likeTexts, other.likeTexts) && Arrays.equals(this.unlikeTexts, other.unlikeTexts) && Arrays.equals(this.likeItems, other.likeItems) && Arrays.equals(this.unlikeItems, other.unlikeItems) && Objects.equals(this.maxQueryTerms, other.maxQueryTerms) && Objects.equals(this.minTermFreq, other.minTermFreq) && Objects.equals(this.minDocFreq, other.minDocFreq) && Objects.equals(this.maxDocFreq, other.maxDocFreq) && Objects.equals(this.minWordLength, other.minWordLength) && Objects.equals(this.maxWordLength, other.maxWordLength) && Arrays.equals(this.stopWords, other.stopWords) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(Float.valueOf(this.boostTerms), Float.valueOf(other.boostTerms)) && Objects.equals(this.include, other.include) && Objects.equals(this.failOnUnsupportedField, other.failOnUnsupportedField);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return this;
    }

    public static final class Item
    implements ToXContent,
    Writeable {
        public static final Item[] EMPTY_ARRAY = new Item[0];
        private String index;
        private String type;
        private String id;
        private BytesReference doc;
        private XContentType xContentType;
        private String[] fields;
        private Map<String, String> perFieldAnalyzer;
        private String routing;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Item() {
        }

        Item(Item copy) {
            if (copy.id == null && copy.doc == null) {
                throw new IllegalArgumentException("Item requires either id or doc to be non-null");
            }
            this.index = copy.index;
            this.type = copy.type;
            this.id = copy.id;
            this.routing = copy.routing;
            this.doc = copy.doc;
            this.xContentType = copy.xContentType;
            this.fields = copy.fields;
            this.perFieldAnalyzer = copy.perFieldAnalyzer;
            this.version = copy.version;
            this.versionType = copy.versionType;
        }

        public Item(@Nullable String index, @Nullable String type, String id) {
            if (id == null) {
                throw new IllegalArgumentException("Item requires id to be non-null");
            }
            this.index = index;
            this.type = type;
            this.id = id;
        }

        public Item(@Nullable String index, @Nullable String type, XContentBuilder doc) {
            if (doc == null) {
                throw new IllegalArgumentException("Item requires doc to be non-null");
            }
            this.index = index;
            this.type = type;
            this.doc = doc.bytes();
            this.xContentType = doc.contentType();
        }

        Item(StreamInput in) throws IOException {
            this.index = in.readOptionalString();
            this.type = in.readOptionalString();
            if (in.readBoolean()) {
                this.doc = (BytesReference)in.readGenericValue();
                this.xContentType = in.getVersion().onOrAfter(Version.V_5_3_0) ? XContentType.readFrom(in) : XContentFactory.xContentType(this.doc);
            } else {
                this.id = in.readString();
            }
            this.fields = in.readOptionalStringArray();
            this.perFieldAnalyzer = (Map)in.readGenericValue();
            this.routing = in.readOptionalString();
            this.version = in.readLong();
            this.versionType = VersionType.readFromStream(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.index);
            out.writeOptionalString(this.type);
            out.writeBoolean(this.doc != null);
            if (this.doc != null) {
                out.writeGenericValue(this.doc);
                if (out.getVersion().onOrAfter(Version.V_5_3_0)) {
                    this.xContentType.writeTo(out);
                }
            } else {
                out.writeString(this.id);
            }
            out.writeOptionalStringArray(this.fields);
            out.writeGenericValue(this.perFieldAnalyzer);
            out.writeOptionalString(this.routing);
            out.writeLong(this.version);
            this.versionType.writeTo(out);
        }

        public String index() {
            return this.index;
        }

        public Item index(String index) {
            this.index = index;
            return this;
        }

        public String type() {
            return this.type;
        }

        public Item type(String type) {
            this.type = type;
            return this;
        }

        public String id() {
            return this.id;
        }

        public BytesReference doc() {
            return this.doc;
        }

        public String[] fields() {
            return this.fields;
        }

        public Item fields(String ... fields) {
            this.fields = fields;
            return this;
        }

        public Map<String, String> perFieldAnalyzer() {
            return this.perFieldAnalyzer;
        }

        public Item perFieldAnalyzer(Map<String, String> perFieldAnalyzer) {
            this.perFieldAnalyzer = perFieldAnalyzer;
            return this;
        }

        public String routing() {
            return this.routing;
        }

        public Item routing(String routing) {
            this.routing = routing;
            return this;
        }

        public long version() {
            return this.version;
        }

        public Item version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Item versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        XContentType xContentType() {
            return this.xContentType;
        }

        TermVectorsRequest toTermVectorsRequest() {
            TermVectorsRequest termVectorsRequest = new TermVectorsRequest(this.index, this.type, this.id).selectedFields(this.fields).routing(this.routing).version(this.version).versionType(this.versionType).perFieldAnalyzer(this.perFieldAnalyzer).positions(false).offsets(false).payloads(false).fieldStatistics(false).termStatistics(false);
            if (this.doc != null) {
                termVectorsRequest.doc(this.doc, true, this.xContentType);
                this.id = termVectorsRequest.id();
            }
            return termVectorsRequest;
        }

        public static Item parse(XContentParser parser, Item item) throws IOException {
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentFieldName == null) continue;
                if (Field.INDEX.match(currentFieldName)) {
                    item.index = parser.text();
                    continue;
                }
                if (Field.TYPE.match(currentFieldName)) {
                    item.type = parser.text();
                    continue;
                }
                if (Field.ID.match(currentFieldName)) {
                    item.id = parser.text();
                    continue;
                }
                if (Field.DOC.match(currentFieldName)) {
                    item.doc = XContentFactory.jsonBuilder().copyCurrentStructure(parser).bytes();
                    item.xContentType = XContentType.JSON;
                    continue;
                }
                if (Field.FIELDS.match(currentFieldName)) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        ArrayList<String> fields = new ArrayList<String>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            fields.add(parser.text());
                        }
                        item.fields(fields.toArray(new String[fields.size()]));
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse More Like This item. field [fields] must be an array", new Object[0]);
                }
                if (Field.PER_FIELD_ANALYZER.match(currentFieldName)) {
                    item.perFieldAnalyzer(TermVectorsRequest.readPerFieldAnalyzer(parser.map()));
                    continue;
                }
                if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                    item.routing = parser.text();
                    continue;
                }
                if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                    item.version = parser.longValue();
                    continue;
                }
                if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                    item.versionType = VersionType.fromString(parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse More Like This item. unknown field [{}]", currentFieldName);
            }
            if (item.id != null && item.doc != null) {
                throw new ElasticsearchParseException("failed to parse More Like This item. either [id] or [doc] can be specified, but not both!", new Object[0]);
            }
            if (item.id == null && item.doc == null) {
                throw new ElasticsearchParseException("failed to parse More Like This item. neither [id] nor [doc] is specified!", new Object[0]);
            }
            return item;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.index != null) {
                builder.field(Field.INDEX.getPreferredName(), this.index);
            }
            if (this.type != null) {
                builder.field(Field.TYPE.getPreferredName(), this.type);
            }
            if (this.id != null) {
                builder.field(Field.ID.getPreferredName(), this.id);
            }
            if (this.doc != null) {
                builder.rawField(Field.DOC.getPreferredName(), this.doc, this.xContentType);
            }
            if (this.fields != null) {
                builder.array(Field.FIELDS.getPreferredName(), this.fields);
            }
            if (this.perFieldAnalyzer != null) {
                builder.field(Field.PER_FIELD_ANALYZER.getPreferredName(), this.perFieldAnalyzer);
            }
            if (this.routing != null) {
                builder.field(Field.ROUTING.getPreferredName(), this.routing);
            }
            if (this.version != -3L) {
                builder.field(Field.VERSION.getPreferredName(), this.version);
            }
            if (this.versionType != VersionType.INTERNAL) {
                builder.field(Field.VERSION_TYPE.getPreferredName(), this.versionType.toString().toLowerCase(Locale.ROOT));
            }
            return builder.endObject();
        }

        public String toString() {
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.prettyPrint();
                this.toXContent(builder, EMPTY_PARAMS);
                return builder.string();
            }
            catch (Exception e) {
                return "{ \"error\" : \"" + ExceptionsHelper.detailedMessage(e) + "\"}";
            }
        }

        public int hashCode() {
            return Objects.hash(this.index, this.type, this.id, this.doc, Arrays.hashCode(this.fields), this.perFieldAnalyzer, this.routing, this.version, this.versionType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            return Objects.equals(this.index, other.index) && Objects.equals(this.type, other.type) && Objects.equals(this.id, other.id) && Objects.equals(this.doc, other.doc) && Arrays.equals(this.fields, other.fields) && Objects.equals(this.perFieldAnalyzer, other.perFieldAnalyzer) && Objects.equals(this.routing, other.routing) && Objects.equals(this.version, other.version) && Objects.equals(this.versionType, other.versionType);
        }

        public static interface Field {
            public static final ParseField INDEX = new ParseField("_index", new String[0]);
            public static final ParseField TYPE = new ParseField("_type", new String[0]);
            public static final ParseField ID = new ParseField("_id", new String[0]);
            public static final ParseField DOC = new ParseField("doc", new String[0]);
            public static final ParseField FIELDS = new ParseField("fields", new String[0]);
            public static final ParseField PER_FIELD_ANALYZER = new ParseField("per_field_analyzer", new String[0]);
            public static final ParseField ROUTING = new ParseField("_routing", new String[0]);
            public static final ParseField VERSION = new ParseField("_version", new String[0]);
            public static final ParseField VERSION_TYPE = new ParseField("_version_type", new String[0]);
        }
    }

    private static interface Field {
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField LIKE = new ParseField("like", new String[0]);
        public static final ParseField UNLIKE = new ParseField("unlike", new String[0]);
        public static final ParseField LIKE_TEXT = new ParseField("like_text", new String[0]).withAllDeprecated("like");
        public static final ParseField IDS = new ParseField("ids", new String[0]).withAllDeprecated("like");
        public static final ParseField DOCS = new ParseField("docs", new String[0]).withAllDeprecated("like");
        public static final ParseField MAX_QUERY_TERMS = new ParseField("max_query_terms", new String[0]);
        public static final ParseField MIN_TERM_FREQ = new ParseField("min_term_freq", new String[0]);
        public static final ParseField MIN_DOC_FREQ = new ParseField("min_doc_freq", new String[0]);
        public static final ParseField MAX_DOC_FREQ = new ParseField("max_doc_freq", new String[0]);
        public static final ParseField MIN_WORD_LENGTH = new ParseField("min_word_length", "min_word_len");
        public static final ParseField MAX_WORD_LENGTH = new ParseField("max_word_length", "max_word_len");
        public static final ParseField STOP_WORDS = new ParseField("stop_words", new String[0]);
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField MINIMUM_SHOULD_MATCH = new ParseField("minimum_should_match", new String[0]);
        public static final ParseField BOOST_TERMS = new ParseField("boost_terms", new String[0]);
        public static final ParseField INCLUDE = new ParseField("include", new String[0]);
        public static final ParseField FAIL_ON_UNSUPPORTED_FIELD = new ParseField("fail_on_unsupported_field", new String[0]);
    }
}

