/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TermRangeQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.ShapeRelation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.DateMathParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.joda.Joda;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.BytesRefs;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DateFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyDateFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.RangeFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryRewriteContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryShardException;
import org.graylog.shaded.elasticsearch5.org.joda.time.DateTimeZone;

public class RangeQueryBuilder
extends AbstractQueryBuilder<RangeQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "range";
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    private static final ParseField FIELDDATA_FIELD = new ParseField("fielddata", new String[0]).withAllDeprecated("[no replacement]");
    private static final ParseField NAME_FIELD = new ParseField("_name", new String[0]).withAllDeprecated("query name is not supported in short version of range query");
    public static final ParseField LTE_FIELD = new ParseField("lte", "le");
    public static final ParseField GTE_FIELD = new ParseField("gte", "ge");
    public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
    public static final ParseField TO_FIELD = new ParseField("to", new String[0]);
    private static final ParseField INCLUDE_LOWER_FIELD = new ParseField("include_lower", new String[0]);
    private static final ParseField INCLUDE_UPPER_FIELD = new ParseField("include_upper", new String[0]);
    public static final ParseField GT_FIELD = new ParseField("gt", new String[0]);
    public static final ParseField LT_FIELD = new ParseField("lt", new String[0]);
    private static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private static final ParseField RELATION_FIELD = new ParseField("relation", new String[0]);
    private final String fieldName;
    private Object from;
    private Object to;
    private DateTimeZone timeZone;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private FormatDateTimeFormatter format;
    private ShapeRelation relation;

    public RangeQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    public RangeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        String relationString;
        this.fieldName = in.readString();
        this.from = in.readGenericValue();
        this.to = in.readGenericValue();
        this.includeLower = in.readBoolean();
        this.includeUpper = in.readBoolean();
        this.timeZone = in.readOptionalTimeZone();
        String formatString = in.readOptionalString();
        if (formatString != null) {
            this.format = Joda.forPattern(formatString);
        }
        if (in.getVersion().onOrAfter(Version.V_5_2_0) && (relationString = in.readOptionalString()) != null) {
            this.relation = ShapeRelation.getRelationByName(relationString);
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.from);
        out.writeGenericValue(this.to);
        out.writeBoolean(this.includeLower);
        out.writeBoolean(this.includeUpper);
        out.writeOptionalTimeZone(this.timeZone);
        String formatString = null;
        if (this.format != null) {
            formatString = this.format.format();
        }
        out.writeOptionalString(formatString);
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            String relationString = null;
            if (this.relation != null) {
                relationString = this.relation.getRelationName();
            }
            out.writeOptionalString(relationString);
        }
    }

    public String fieldName() {
        return this.fieldName;
    }

    public RangeQueryBuilder from(Object from, boolean includeLower) {
        this.from = RangeQueryBuilder.convertToBytesRefIfString(from);
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder from(Object from) {
        return this.from(from, this.includeLower);
    }

    public Object from() {
        return RangeQueryBuilder.convertToStringIfBytesRef(this.from);
    }

    public RangeQueryBuilder gt(Object from) {
        return this.from(from, false);
    }

    public RangeQueryBuilder gte(Object from) {
        return this.from(from, true);
    }

    public RangeQueryBuilder to(Object to, boolean includeUpper) {
        this.to = RangeQueryBuilder.convertToBytesRefIfString(to);
        this.includeUpper = includeUpper;
        return this;
    }

    public RangeQueryBuilder to(Object to) {
        return this.to(to, this.includeUpper);
    }

    public Object to() {
        return RangeQueryBuilder.convertToStringIfBytesRef(this.to);
    }

    public RangeQueryBuilder lt(Object to) {
        return this.to(to, false);
    }

    public RangeQueryBuilder lte(Object to) {
        return this.to(to, true);
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public RangeQueryBuilder timeZone(String timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("timezone cannot be null");
        }
        this.timeZone = DateTimeZone.forID(timeZone);
        return this;
    }

    public String timeZone() {
        return this.timeZone == null ? null : this.timeZone.getID();
    }

    DateTimeZone getDateTimeZone() {
        return this.timeZone;
    }

    public RangeQueryBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("format cannot be null");
        }
        this.format = Joda.forPattern(format);
        return this;
    }

    public String format() {
        return this.format == null ? null : this.format.format();
    }

    DateMathParser getForceDateParser() {
        if (this.format != null) {
            return new DateMathParser(this.format);
        }
        return null;
    }

    public ShapeRelation relation() {
        return this.relation;
    }

    public RangeQueryBuilder relation(String relation) {
        if (relation == null) {
            throw new IllegalArgumentException("relation cannot be null");
        }
        this.relation = ShapeRelation.getRelationByName(relation);
        if (this.relation == null) {
            throw new IllegalArgumentException(relation + " is not a valid relation");
        }
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(FROM_FIELD.getPreferredName(), RangeQueryBuilder.convertToStringIfBytesRef(this.from));
        builder.field(TO_FIELD.getPreferredName(), RangeQueryBuilder.convertToStringIfBytesRef(this.to));
        builder.field(INCLUDE_LOWER_FIELD.getPreferredName(), this.includeLower);
        builder.field(INCLUDE_UPPER_FIELD.getPreferredName(), this.includeUpper);
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getID());
        }
        if (this.format != null) {
            builder.field(FORMAT_FIELD.getPreferredName(), this.format.format());
        }
        if (this.relation != null) {
            builder.field(RELATION_FIELD.getPreferredName(), this.relation.getRelationName());
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static Optional<RangeQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        Object from = null;
        Object to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        String timeZone = null;
        float boost = 1.0f;
        String queryName = null;
        String format = null;
        String relation = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                RangeQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (FROM_FIELD.match(currentFieldName)) {
                        from = parser.objectBytes();
                        continue;
                    }
                    if (TO_FIELD.match(currentFieldName)) {
                        to = parser.objectBytes();
                        continue;
                    }
                    if (INCLUDE_LOWER_FIELD.match(currentFieldName)) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if (INCLUDE_UPPER_FIELD.match(currentFieldName)) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (GT_FIELD.match(currentFieldName)) {
                        from = parser.objectBytes();
                        includeLower = false;
                        continue;
                    }
                    if (GTE_FIELD.match(currentFieldName)) {
                        from = parser.objectBytes();
                        includeLower = true;
                        continue;
                    }
                    if (LT_FIELD.match(currentFieldName)) {
                        to = parser.objectBytes();
                        includeUpper = false;
                        continue;
                    }
                    if (LTE_FIELD.match(currentFieldName)) {
                        to = parser.objectBytes();
                        includeUpper = true;
                        continue;
                    }
                    if (TIME_ZONE_FIELD.match(currentFieldName)) {
                        timeZone = parser.text();
                        continue;
                    }
                    if (FORMAT_FIELD.match(currentFieldName)) {
                        format = parser.text();
                        continue;
                    }
                    if (RELATION_FIELD.match(currentFieldName)) {
                        relation = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            if (FIELDDATA_FIELD.match(currentFieldName)) continue;
            throw new ParsingException(parser.getTokenLocation(), "[range] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(fieldName);
        rangeQuery.from(from);
        rangeQuery.to(to);
        rangeQuery.includeLower(includeLower);
        rangeQuery.includeUpper(includeUpper);
        if (timeZone != null) {
            rangeQuery.timeZone(timeZone);
        }
        rangeQuery.boost(boost);
        rangeQuery.queryName(queryName);
        if (format != null) {
            rangeQuery.format(format);
        }
        if (relation != null) {
            rangeQuery.relation(relation);
        }
        return Optional.of(rangeQuery);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    protected MappedFieldType.Relation getRelation(QueryRewriteContext queryRewriteContext) throws IOException {
        IndexReader reader = queryRewriteContext.getIndexReader();
        if (reader == null) {
            return MappedFieldType.Relation.INTERSECTS;
        }
        MapperService mapperService = queryRewriteContext.getMapperService();
        MappedFieldType fieldType = mapperService.fullName(this.fieldName);
        if (fieldType == null) {
            return MappedFieldType.Relation.DISJOINT;
        }
        DateMathParser dateMathParser = this.format == null ? null : new DateMathParser(this.format);
        return fieldType.isFieldWithinQuery(queryRewriteContext.getIndexReader(), this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, dateMathParser, queryRewriteContext);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        MappedFieldType.Relation relation = this.getRelation(queryRewriteContext);
        switch (relation) {
            case DISJOINT: {
                return new MatchNoneQueryBuilder();
            }
            case WITHIN: {
                if (this.from != null || this.to != null || this.format != null || this.timeZone != null) {
                    RangeQueryBuilder newRangeQuery = new RangeQueryBuilder(this.fieldName);
                    newRangeQuery.from(null);
                    newRangeQuery.to(null);
                    newRangeQuery.format = null;
                    newRangeQuery.timeZone = null;
                    return newRangeQuery;
                }
                return this;
            }
            case INTERSECTS: {
                return this;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query query = null;
        MappedFieldType mapper = context.fieldMapper(this.fieldName);
        if (mapper != null) {
            if (mapper instanceof LegacyDateFieldMapper.DateFieldType) {
                query = ((LegacyDateFieldMapper.DateFieldType)mapper).rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, this.getForceDateParser(), context);
            } else if (mapper instanceof DateFieldMapper.DateFieldType) {
                query = ((DateFieldMapper.DateFieldType)mapper).rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, this.timeZone, this.getForceDateParser(), context);
            } else if (mapper instanceof RangeFieldMapper.RangeFieldType) {
                DateMathParser forcedDateParser = null;
                if (mapper.typeName() == RangeFieldMapper.RangeType.DATE.name && this.format != null) {
                    forcedDateParser = new DateMathParser(this.format);
                }
                query = ((RangeFieldMapper.RangeFieldType)mapper).rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, this.relation, this.timeZone, forcedDateParser, context);
            } else {
                if (this.timeZone != null) {
                    throw new QueryShardException(context, "[range] time_zone can not be applied to non date field [" + this.fieldName + "]", new Object[0]);
                }
                query = mapper.rangeQuery(this.from, this.to, this.includeLower, this.includeUpper, context);
            }
        } else if (this.timeZone != null) {
            throw new QueryShardException(context, "[range] time_zone can not be applied to non unmapped field [" + this.fieldName + "]", new Object[0]);
        }
        if (query == null) {
            query = new TermRangeQuery(this.fieldName, BytesRefs.toBytesRef(this.from), BytesRefs.toBytesRef(this.to), this.includeLower, this.includeUpper);
        }
        return query;
    }

    @Override
    protected int doHashCode() {
        String timeZoneId = this.timeZone == null ? null : this.timeZone.getID();
        String formatString = this.format == null ? null : this.format.format();
        return Objects.hash(this.fieldName, this.from, this.to, timeZoneId, this.includeLower, this.includeUpper, formatString);
    }

    @Override
    protected boolean doEquals(RangeQueryBuilder other) {
        String timeZoneId = this.timeZone == null ? null : this.timeZone.getID();
        String formatString = this.format == null ? null : this.format.format();
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(timeZoneId, other.timeZone()) && Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(formatString, other.format());
    }
}

