/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.support;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;

public final class QueryParsers {
    public static final ParseField CONSTANT_SCORE = new ParseField("constant_score", "constant_score_auto", "constant_score_filter");
    public static final ParseField SCORING_BOOLEAN = new ParseField("scoring_boolean", new String[0]);
    public static final ParseField CONSTANT_SCORE_BOOLEAN = new ParseField("constant_score_boolean", new String[0]);
    public static final ParseField TOP_TERMS = new ParseField("top_terms_", new String[0]);
    public static final ParseField TOP_TERMS_BOOST = new ParseField("top_terms_boost_", new String[0]);
    public static final ParseField TOP_TERMS_BLENDED_FREQS = new ParseField("top_terms_blended_freqs_", new String[0]);

    private QueryParsers() {
    }

    public static void setRewriteMethod(MultiTermQuery query, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
        if (rewriteMethod == null) {
            return;
        }
        query.setRewriteMethod(rewriteMethod);
    }

    public static MultiTermQuery.RewriteMethod parseRewriteMethod(@Nullable String rewriteMethod) {
        return QueryParsers.parseRewriteMethod(rewriteMethod, MultiTermQuery.CONSTANT_SCORE_REWRITE);
    }

    public static MultiTermQuery.RewriteMethod parseRewriteMethod(@Nullable String rewriteMethod, @Nullable MultiTermQuery.RewriteMethod defaultRewriteMethod) {
        if (rewriteMethod == null) {
            return defaultRewriteMethod;
        }
        if (CONSTANT_SCORE.match(rewriteMethod)) {
            return MultiTermQuery.CONSTANT_SCORE_REWRITE;
        }
        if (SCORING_BOOLEAN.match(rewriteMethod)) {
            return MultiTermQuery.SCORING_BOOLEAN_REWRITE;
        }
        if (CONSTANT_SCORE_BOOLEAN.match(rewriteMethod)) {
            return MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE;
        }
        int firstDigit = -1;
        for (int i = 0; i < rewriteMethod.length(); ++i) {
            if (!Character.isDigit(rewriteMethod.charAt(i))) continue;
            firstDigit = i;
            break;
        }
        if (firstDigit >= 0) {
            int size = Integer.parseInt(rewriteMethod.substring(firstDigit));
            String rewriteMethodName = rewriteMethod.substring(0, firstDigit);
            if (TOP_TERMS.match(rewriteMethodName)) {
                return new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(size);
            }
            if (TOP_TERMS_BOOST.match(rewriteMethodName)) {
                return new MultiTermQuery.TopTermsBoostOnlyBooleanQueryRewrite(size);
            }
            if (TOP_TERMS_BLENDED_FREQS.match(rewriteMethodName)) {
                return new MultiTermQuery.TopTermsBlendedFreqScoringRewrite(size);
            }
        }
        throw new IllegalArgumentException("Failed to parse rewrite_method [" + rewriteMethod + "]");
    }
}

