/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.hunspell.Dictionary;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.NamedRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ASCIIFoldingTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AnalysisRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ApostropheFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ArabicAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ArabicNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ArabicStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ArmenianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.BasqueAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.BrazilianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.BrazilianStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.BulgarianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CJKBigramFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CJKWidthFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CatalanAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CharFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ChineseAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CjkAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ClassicFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ClassicTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CommonGramsTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CzechAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.CzechStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.DanishAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.DecimalDigitFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.DelimitedPayloadTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.DutchAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.DutchStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.EdgeNGramTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.EdgeNGramTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ElisionTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.EnglishAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.FingerprintAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.FingerprintTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.FinnishAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.FlattenGraphTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.FrenchAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.FrenchStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.GalicianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.GermanAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.GermanNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.GermanStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.GreekAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.HindiAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.HindiNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.HtmlStripCharFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.HungarianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.HunspellTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.IndicNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.IndonesianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.IrishAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ItalianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.KStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.KeepTypesFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.KeepWordFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.KeywordAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.KeywordMarkerTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.KeywordTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.LatvianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.LengthTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.LetterTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.LimitTokenCountFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.LithuanianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.LowerCaseTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.LowerCaseTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.MappingCharFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.MinHashTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.NGramTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.NGramTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.NorwegianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PathHierarchyTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PatternAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PatternCaptureGroupTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PatternReplaceCharFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PatternReplaceTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PatternTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PersianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PersianNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PorterStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.PortugueseAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ReverseTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.RomanianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.RussianAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.RussianStemTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ScandinavianFoldingFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ScandinavianNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SerbianNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SimpleAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SnowballAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SnowballTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SoraniAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SoraniNormalizationFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SpanishAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StandardHtmlStripAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StandardTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StemmerOverrideTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StemmerTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StopAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.SwedishAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ThaiAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.ThaiTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.TokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.TrimTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.TruncateTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.TurkishAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.UAX29URLEmailTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.UniqueTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.UpperCaseTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.WhitespaceAnalyzerProvider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.WhitespaceTokenizerFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.WordDelimiterGraphTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.WordDelimiterTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.compound.DictionaryCompoundWordTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.compound.HyphenationCompoundWordTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.analysis.HunspellService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.AnalysisPlugin;

public final class AnalysisModule {
    private static final IndexSettings NA_INDEX_SETTINGS;
    private final HunspellService hunspellService;
    private final AnalysisRegistry analysisRegistry;

    public AnalysisModule(Environment environment, List<AnalysisPlugin> plugins) throws IOException {
        NamedRegistry<AnalysisProvider<CharFilterFactory>> charFilters = this.setupCharFilters(plugins);
        NamedRegistry<Dictionary> hunspellDictionaries = this.setupHunspellDictionaries(plugins);
        this.hunspellService = new HunspellService(environment.settings(), environment, hunspellDictionaries.getRegistry());
        NamedRegistry<AnalysisProvider<TokenFilterFactory>> tokenFilters = this.setupTokenFilters(plugins, this.hunspellService);
        NamedRegistry<AnalysisProvider<TokenizerFactory>> tokenizers = this.setupTokenizers(plugins);
        NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> analyzers = this.setupAnalyzers(plugins);
        NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> normalizers = this.setupNormalizers(plugins);
        this.analysisRegistry = new AnalysisRegistry(environment, charFilters.getRegistry(), tokenFilters.getRegistry(), tokenizers.getRegistry(), analyzers.getRegistry(), normalizers.getRegistry());
    }

    HunspellService getHunspellService() {
        return this.hunspellService;
    }

    public AnalysisRegistry getAnalysisRegistry() {
        return this.analysisRegistry;
    }

    private NamedRegistry<AnalysisProvider<CharFilterFactory>> setupCharFilters(List<AnalysisPlugin> plugins) {
        NamedRegistry<AnalysisProvider<CharFilterFactory>> charFilters = new NamedRegistry<AnalysisProvider<CharFilterFactory>>("char_filter");
        charFilters.register("html_strip", HtmlStripCharFilterFactory::new);
        charFilters.register("pattern_replace", AnalysisModule.requriesAnalysisSettings(PatternReplaceCharFilterFactory::new));
        charFilters.register("mapping", AnalysisModule.requriesAnalysisSettings(MappingCharFilterFactory::new));
        charFilters.extractAndRegister(plugins, AnalysisPlugin::getCharFilters);
        return charFilters;
    }

    public NamedRegistry<Dictionary> setupHunspellDictionaries(List<AnalysisPlugin> plugins) {
        NamedRegistry<Dictionary> hunspellDictionaries = new NamedRegistry<Dictionary>("dictionary");
        hunspellDictionaries.extractAndRegister(plugins, AnalysisPlugin::getHunspellDictionaries);
        return hunspellDictionaries;
    }

    private NamedRegistry<AnalysisProvider<TokenFilterFactory>> setupTokenFilters(List<AnalysisPlugin> plugins, HunspellService hunspellService) {
        NamedRegistry<AnalysisProvider<TokenFilterFactory>> tokenFilters = new NamedRegistry<AnalysisProvider<TokenFilterFactory>>("token_filter");
        tokenFilters.register("stop", StopTokenFilterFactory::new);
        tokenFilters.register("reverse", ReverseTokenFilterFactory::new);
        tokenFilters.register("asciifolding", ASCIIFoldingTokenFilterFactory::new);
        tokenFilters.register("length", LengthTokenFilterFactory::new);
        tokenFilters.register("lowercase", LowerCaseTokenFilterFactory::new);
        tokenFilters.register("uppercase", UpperCaseTokenFilterFactory::new);
        tokenFilters.register("porter_stem", PorterStemTokenFilterFactory::new);
        tokenFilters.register("kstem", KStemTokenFilterFactory::new);
        tokenFilters.register("standard", StandardTokenFilterFactory::new);
        tokenFilters.register("nGram", NGramTokenFilterFactory::new);
        tokenFilters.register("ngram", NGramTokenFilterFactory::new);
        tokenFilters.register("edgeNGram", EdgeNGramTokenFilterFactory::new);
        tokenFilters.register("edge_ngram", EdgeNGramTokenFilterFactory::new);
        tokenFilters.register("shingle", ShingleTokenFilterFactory::new);
        tokenFilters.register("min_hash", MinHashTokenFilterFactory::new);
        tokenFilters.register("unique", UniqueTokenFilterFactory::new);
        tokenFilters.register("truncate", AnalysisModule.requriesAnalysisSettings(TruncateTokenFilterFactory::new));
        tokenFilters.register("trim", TrimTokenFilterFactory::new);
        tokenFilters.register("limit", LimitTokenCountFilterFactory::new);
        tokenFilters.register("common_grams", AnalysisModule.requriesAnalysisSettings(CommonGramsTokenFilterFactory::new));
        tokenFilters.register("snowball", SnowballTokenFilterFactory::new);
        tokenFilters.register("stemmer", StemmerTokenFilterFactory::new);
        tokenFilters.register("word_delimiter", WordDelimiterTokenFilterFactory::new);
        tokenFilters.register("word_delimiter_graph", WordDelimiterGraphTokenFilterFactory::new);
        tokenFilters.register("delimited_payload_filter", DelimitedPayloadTokenFilterFactory::new);
        tokenFilters.register("elision", ElisionTokenFilterFactory::new);
        tokenFilters.register("flatten_graph", FlattenGraphTokenFilterFactory::new);
        tokenFilters.register("keep", AnalysisModule.requriesAnalysisSettings(KeepWordFilterFactory::new));
        tokenFilters.register("keep_types", AnalysisModule.requriesAnalysisSettings(KeepTypesFilterFactory::new));
        tokenFilters.register("pattern_capture", AnalysisModule.requriesAnalysisSettings(PatternCaptureGroupTokenFilterFactory::new));
        tokenFilters.register("pattern_replace", AnalysisModule.requriesAnalysisSettings(PatternReplaceTokenFilterFactory::new));
        tokenFilters.register("dictionary_decompounder", AnalysisModule.requriesAnalysisSettings(DictionaryCompoundWordTokenFilterFactory::new));
        tokenFilters.register("hyphenation_decompounder", AnalysisModule.requriesAnalysisSettings(HyphenationCompoundWordTokenFilterFactory::new));
        tokenFilters.register("arabic_stem", ArabicStemTokenFilterFactory::new);
        tokenFilters.register("brazilian_stem", BrazilianStemTokenFilterFactory::new);
        tokenFilters.register("czech_stem", CzechStemTokenFilterFactory::new);
        tokenFilters.register("dutch_stem", DutchStemTokenFilterFactory::new);
        tokenFilters.register("french_stem", FrenchStemTokenFilterFactory::new);
        tokenFilters.register("german_stem", GermanStemTokenFilterFactory::new);
        tokenFilters.register("russian_stem", RussianStemTokenFilterFactory::new);
        tokenFilters.register("keyword_marker", AnalysisModule.requriesAnalysisSettings(KeywordMarkerTokenFilterFactory::new));
        tokenFilters.register("stemmer_override", AnalysisModule.requriesAnalysisSettings(StemmerOverrideTokenFilterFactory::new));
        tokenFilters.register("arabic_normalization", ArabicNormalizationFilterFactory::new);
        tokenFilters.register("german_normalization", GermanNormalizationFilterFactory::new);
        tokenFilters.register("hindi_normalization", HindiNormalizationFilterFactory::new);
        tokenFilters.register("indic_normalization", IndicNormalizationFilterFactory::new);
        tokenFilters.register("sorani_normalization", SoraniNormalizationFilterFactory::new);
        tokenFilters.register("persian_normalization", PersianNormalizationFilterFactory::new);
        tokenFilters.register("scandinavian_normalization", ScandinavianNormalizationFilterFactory::new);
        tokenFilters.register("scandinavian_folding", ScandinavianFoldingFilterFactory::new);
        tokenFilters.register("serbian_normalization", SerbianNormalizationFilterFactory::new);
        tokenFilters.register("hunspell", AnalysisModule.requriesAnalysisSettings((indexSettings, env, name, settings) -> new HunspellTokenFilterFactory(indexSettings, name, settings, hunspellService)));
        tokenFilters.register("cjk_bigram", CJKBigramFilterFactory::new);
        tokenFilters.register("cjk_width", CJKWidthFilterFactory::new);
        tokenFilters.register("apostrophe", ApostropheFilterFactory::new);
        tokenFilters.register("classic", ClassicFilterFactory::new);
        tokenFilters.register("decimal_digit", DecimalDigitFilterFactory::new);
        tokenFilters.register("fingerprint", FingerprintTokenFilterFactory::new);
        tokenFilters.extractAndRegister(plugins, AnalysisPlugin::getTokenFilters);
        return tokenFilters;
    }

    private NamedRegistry<AnalysisProvider<TokenizerFactory>> setupTokenizers(List<AnalysisPlugin> plugins) {
        NamedRegistry<AnalysisProvider<TokenizerFactory>> tokenizers = new NamedRegistry<AnalysisProvider<TokenizerFactory>>("tokenizer");
        tokenizers.register("standard", StandardTokenizerFactory::new);
        tokenizers.register("uax_url_email", UAX29URLEmailTokenizerFactory::new);
        tokenizers.register("path_hierarchy", PathHierarchyTokenizerFactory::new);
        tokenizers.register("PathHierarchy", PathHierarchyTokenizerFactory::new);
        tokenizers.register("keyword", KeywordTokenizerFactory::new);
        tokenizers.register("letter", LetterTokenizerFactory::new);
        tokenizers.register("lowercase", LowerCaseTokenizerFactory::new);
        tokenizers.register("whitespace", WhitespaceTokenizerFactory::new);
        tokenizers.register("nGram", NGramTokenizerFactory::new);
        tokenizers.register("ngram", NGramTokenizerFactory::new);
        tokenizers.register("edgeNGram", EdgeNGramTokenizerFactory::new);
        tokenizers.register("edge_ngram", EdgeNGramTokenizerFactory::new);
        tokenizers.register("pattern", PatternTokenizerFactory::new);
        tokenizers.register("classic", ClassicTokenizerFactory::new);
        tokenizers.register("thai", ThaiTokenizerFactory::new);
        tokenizers.extractAndRegister(plugins, AnalysisPlugin::getTokenizers);
        return tokenizers;
    }

    private NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> setupAnalyzers(List<AnalysisPlugin> plugins) {
        NamedRegistry analyzers = new NamedRegistry("analyzer");
        analyzers.register("default", StandardAnalyzerProvider::new);
        analyzers.register("standard", StandardAnalyzerProvider::new);
        analyzers.register("standard_html_strip", StandardHtmlStripAnalyzerProvider::new);
        analyzers.register("simple", SimpleAnalyzerProvider::new);
        analyzers.register("stop", StopAnalyzerProvider::new);
        analyzers.register("whitespace", WhitespaceAnalyzerProvider::new);
        analyzers.register("keyword", KeywordAnalyzerProvider::new);
        analyzers.register("pattern", PatternAnalyzerProvider::new);
        analyzers.register("snowball", SnowballAnalyzerProvider::new);
        analyzers.register("arabic", ArabicAnalyzerProvider::new);
        analyzers.register("armenian", ArmenianAnalyzerProvider::new);
        analyzers.register("basque", BasqueAnalyzerProvider::new);
        analyzers.register("brazilian", BrazilianAnalyzerProvider::new);
        analyzers.register("bulgarian", BulgarianAnalyzerProvider::new);
        analyzers.register("catalan", CatalanAnalyzerProvider::new);
        analyzers.register("chinese", ChineseAnalyzerProvider::new);
        analyzers.register("cjk", CjkAnalyzerProvider::new);
        analyzers.register("czech", CzechAnalyzerProvider::new);
        analyzers.register("danish", DanishAnalyzerProvider::new);
        analyzers.register("dutch", DutchAnalyzerProvider::new);
        analyzers.register("english", EnglishAnalyzerProvider::new);
        analyzers.register("finnish", FinnishAnalyzerProvider::new);
        analyzers.register("french", FrenchAnalyzerProvider::new);
        analyzers.register("galician", GalicianAnalyzerProvider::new);
        analyzers.register("german", GermanAnalyzerProvider::new);
        analyzers.register("greek", GreekAnalyzerProvider::new);
        analyzers.register("hindi", HindiAnalyzerProvider::new);
        analyzers.register("hungarian", HungarianAnalyzerProvider::new);
        analyzers.register("indonesian", IndonesianAnalyzerProvider::new);
        analyzers.register("irish", IrishAnalyzerProvider::new);
        analyzers.register("italian", ItalianAnalyzerProvider::new);
        analyzers.register("latvian", LatvianAnalyzerProvider::new);
        analyzers.register("lithuanian", LithuanianAnalyzerProvider::new);
        analyzers.register("norwegian", NorwegianAnalyzerProvider::new);
        analyzers.register("persian", PersianAnalyzerProvider::new);
        analyzers.register("portuguese", PortugueseAnalyzerProvider::new);
        analyzers.register("romanian", RomanianAnalyzerProvider::new);
        analyzers.register("russian", RussianAnalyzerProvider::new);
        analyzers.register("sorani", SoraniAnalyzerProvider::new);
        analyzers.register("spanish", SpanishAnalyzerProvider::new);
        analyzers.register("swedish", SwedishAnalyzerProvider::new);
        analyzers.register("turkish", TurkishAnalyzerProvider::new);
        analyzers.register("thai", ThaiAnalyzerProvider::new);
        analyzers.register("fingerprint", FingerprintAnalyzerProvider::new);
        analyzers.extractAndRegister(plugins, AnalysisPlugin::getAnalyzers);
        return analyzers;
    }

    private NamedRegistry<AnalysisProvider<AnalyzerProvider<?>>> setupNormalizers(List<AnalysisPlugin> plugins) {
        NamedRegistry normalizers = new NamedRegistry("normalizer");
        return normalizers;
    }

    private static <T> AnalysisProvider<T> requriesAnalysisSettings(final AnalysisProvider<T> provider) {
        return new AnalysisProvider<T>(){

            @Override
            public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
                return provider.get(indexSettings, environment, name, settings);
            }

            @Override
            public boolean requiresAnalysisSettings() {
                return true;
            }
        };
    }

    static {
        Settings build = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).build();
        IndexMetaData metaData = IndexMetaData.builder("_na_").settings(build).build();
        NA_INDEX_SETTINGS = new IndexSettings(metaData, Settings.EMPTY);
    }

    public static interface AnalysisProvider<T> {
        public T get(IndexSettings var1, Environment var2, String var3, Settings var4) throws IOException;

        default public T get(Environment environment, String name) throws IOException {
            if (this.requiresAnalysisSettings()) {
                throw new IllegalArgumentException("Analysis settings required - can't instantiate analysis factory");
            }
            return this.get(NA_INDEX_SETTINGS, environment, name, NA_INDEX_SETTINGS.getSettings());
        }

        default public boolean requiresAnalysisSettings() {
            return false;
        }
    }
}

