/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.Requests;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestToXContentListener;

public class RestClusterSearchShardsAction
extends BaseRestHandler {
    public RestClusterSearchShardsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search_shards", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search_shards", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search_shards", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search_shards", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search_shards", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search_shards", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        ClusterSearchShardsRequest clusterSearchShardsRequest = Requests.clusterSearchShardsRequest(indices);
        clusterSearchShardsRequest.local(request.paramAsBoolean("local", clusterSearchShardsRequest.local()));
        if (request.hasParam("type")) {
            String type = request.param("type");
            this.deprecationLogger.deprecated("type [" + type + "] doesn't have any effect in the search shards api, it should be rather omitted", new Object[0]);
        }
        clusterSearchShardsRequest.routing(request.param("routing"));
        clusterSearchShardsRequest.preference(request.param("preference"));
        clusterSearchShardsRequest.indicesOptions(IndicesOptions.fromRequest(request, clusterSearchShardsRequest.indicesOptions()));
        return channel -> client.admin().cluster().searchShards(clusterSearchShardsRequest, new RestToXContentListener<ClusterSearchShardsResponse>((RestChannel)channel));
    }
}

