/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.DeprecationLogger;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.logging.Loggers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.AbstractSearchScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.CompiledScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ExecutableScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.LeafSearchScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.NativeScriptFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptEngineService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.SearchScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.SearchLookup;

public class NativeScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "native";
    private final Map<String, NativeScriptFactory> scripts;

    public NativeScriptEngineService(Settings settings, Map<String, NativeScriptFactory> scripts) {
        super(settings);
        if (!scripts.isEmpty()) {
            Logger logger = Loggers.getLogger(ScriptModule.class);
            DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
            deprecationLogger.deprecated("Native scripts are deprecated. Use a custom ScriptEngine to write scripts in java.", new Object[0]);
        }
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public String getExtension() {
        return "";
    }

    @Override
    public Object compile(String scriptName, String scriptSource, Map<String, String> params) {
        NativeScriptFactory scriptFactory = this.scripts.get(scriptSource);
        if (scriptFactory != null) {
            return scriptFactory;
        }
        throw new IllegalArgumentException("Native script [" + scriptSource + "] not found");
    }

    @Override
    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        NativeScriptFactory scriptFactory = (NativeScriptFactory)compiledScript.compiled();
        return scriptFactory.newScript(vars);
    }

    @Override
    public SearchScript search(CompiledScript compiledScript, final SearchLookup lookup, @Nullable Map<String, Object> vars) {
        final NativeScriptFactory scriptFactory = (NativeScriptFactory)compiledScript.compiled();
        final AbstractSearchScript script = (AbstractSearchScript)scriptFactory.newScript(vars);
        return new SearchScript(){

            @Override
            public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                script.setLookup(lookup.getLeafSearchLookup(context));
                return script;
            }

            @Override
            public boolean needsScores() {
                return scriptFactory.needsScores();
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isInlineScriptEnabled() {
        return true;
    }
}

