/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class FiltersAggregationBuilder
extends AbstractAggregationBuilder<FiltersAggregationBuilder> {
    public static final String NAME = "filters";
    private static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    private static final ParseField OTHER_BUCKET_FIELD = new ParseField("other_bucket", new String[0]);
    private static final ParseField OTHER_BUCKET_KEY_FIELD = new ParseField("other_bucket_key", new String[0]);
    private final List<FiltersAggregator.KeyedFilter> filters;
    private final boolean keyed;
    private boolean otherBucket = false;
    private String otherBucketKey = "_other_";

    public FiltersAggregationBuilder(String name, FiltersAggregator.KeyedFilter ... filters) {
        this(name, Arrays.asList(filters));
    }

    private FiltersAggregationBuilder(String name, List<FiltersAggregator.KeyedFilter> filters) {
        super(name);
        this.filters = new ArrayList<FiltersAggregator.KeyedFilter>(filters);
        Collections.sort(this.filters, (kf1, kf2) -> kf1.key().compareTo(kf2.key()));
        this.keyed = true;
    }

    public FiltersAggregationBuilder(String name, QueryBuilder ... filters) {
        super(name);
        ArrayList<FiltersAggregator.KeyedFilter> keyedFilters = new ArrayList<FiltersAggregator.KeyedFilter>(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            keyedFilters.add(new FiltersAggregator.KeyedFilter(String.valueOf(i), filters[i]));
        }
        this.filters = keyedFilters;
        this.keyed = false;
    }

    public FiltersAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        int filtersSize = in.readVInt();
        this.filters = new ArrayList<FiltersAggregator.KeyedFilter>(filtersSize);
        if (this.keyed) {
            for (int i = 0; i < filtersSize; ++i) {
                this.filters.add(new FiltersAggregator.KeyedFilter(in));
            }
        } else {
            for (int i = 0; i < filtersSize; ++i) {
                this.filters.add(new FiltersAggregator.KeyedFilter(String.valueOf(i), in.readNamedWriteable(QueryBuilder.class)));
            }
        }
        this.otherBucket = in.readBoolean();
        this.otherBucketKey = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeVInt(this.filters.size());
        if (this.keyed) {
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                keyedFilter.writeTo(out);
            }
        } else {
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                out.writeNamedWriteable(keyedFilter.filter());
            }
        }
        out.writeBoolean(this.otherBucket);
        out.writeString(this.otherBucketKey);
    }

    public FiltersAggregationBuilder otherBucket(boolean otherBucket) {
        this.otherBucket = otherBucket;
        return this;
    }

    public boolean otherBucket() {
        return this.otherBucket;
    }

    public List<FiltersAggregator.KeyedFilter> filters() {
        return Collections.unmodifiableList(this.filters);
    }

    public FiltersAggregationBuilder otherBucketKey(String otherBucketKey) {
        if (otherBucketKey == null) {
            throw new IllegalArgumentException("[otherBucketKey] must not be null: [" + this.name + "]");
        }
        this.otherBucketKey = otherBucketKey;
        return this;
    }

    public String otherBucketKey() {
        return this.otherBucketKey;
    }

    @Override
    protected AggregatorFactory<?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ArrayList<FiltersAggregator.KeyedFilter> rewrittenFilters = new ArrayList<FiltersAggregator.KeyedFilter>(this.filters.size());
        for (FiltersAggregator.KeyedFilter kf : this.filters) {
            rewrittenFilters.add(new FiltersAggregator.KeyedFilter(kf.key(), QueryBuilder.rewriteQuery(kf.filter(), context.getQueryShardContext())));
        }
        return new FiltersAggregatorFactory(this.name, rewrittenFilters, this.keyed, this.otherBucket, this.otherBucketKey, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.keyed) {
            builder.startObject(FiltersAggregator.FILTERS_FIELD.getPreferredName());
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                builder.field(keyedFilter.key(), keyedFilter.filter());
            }
            builder.endObject();
        } else {
            builder.startArray(FiltersAggregator.FILTERS_FIELD.getPreferredName());
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                builder.value((Object)keyedFilter.filter());
            }
            builder.endArray();
        }
        builder.field(FiltersAggregator.OTHER_BUCKET_FIELD.getPreferredName(), this.otherBucket);
        builder.field(FiltersAggregator.OTHER_BUCKET_KEY_FIELD.getPreferredName(), this.otherBucketKey);
        builder.endObject();
        return builder;
    }

    public static FiltersAggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        XContentParser parser = context.parser();
        ArrayList<FiltersAggregator.KeyedFilter> keyedFilters = null;
        ArrayList<QueryBuilder> nonKeyedFilters = null;
        XContentParser.Token token = null;
        String currentFieldName = null;
        String otherBucketKey = null;
        Boolean otherBucket = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (OTHER_BUCKET_FIELD.match(currentFieldName)) {
                    otherBucket = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (OTHER_BUCKET_KEY_FIELD.match(currentFieldName)) {
                    otherBucketKey = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (FILTERS_FIELD.match(currentFieldName)) {
                    keyedFilters = new ArrayList<FiltersAggregator.KeyedFilter>();
                    String key = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            key = parser.currentName();
                            continue;
                        }
                        QueryBuilder filter = context.parseInnerQueryBuilder().orElse(QueryBuilders.matchAllQuery());
                        keyedFilters.add(new FiltersAggregator.KeyedFilter(key, filter));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FILTERS_FIELD.match(currentFieldName)) {
                    nonKeyedFilters = new ArrayList<QueryBuilder>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        QueryBuilder filter = context.parseInnerQueryBuilder().orElse(QueryBuilders.matchAllQuery());
                        nonKeyedFilters.add(filter);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
        }
        if (otherBucket == null && otherBucketKey != null) {
            otherBucket = true;
        }
        FiltersAggregationBuilder factory = keyedFilters != null ? new FiltersAggregationBuilder(aggregationName, keyedFilters.toArray(new FiltersAggregator.KeyedFilter[keyedFilters.size()])) : new FiltersAggregationBuilder(aggregationName, nonKeyedFilters.toArray(new QueryBuilder[nonKeyedFilters.size()]));
        if (otherBucket != null) {
            factory.otherBucket(otherBucket);
        }
        if (otherBucketKey != null) {
            factory.otherBucketKey(otherBucketKey);
        }
        return factory;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.filters, this.keyed, this.otherBucket, this.otherBucketKey);
    }

    @Override
    protected boolean doEquals(Object obj) {
        FiltersAggregationBuilder other = (FiltersAggregationBuilder)obj;
        return Objects.equals(this.filters, other.filters) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.otherBucket, other.otherBucket) && Objects.equals(this.otherBucketKey, other.otherBucketKey);
    }

    @Override
    public String getType() {
        return NAME;
    }
}

