/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DiversifiedTopDocsCollector;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TopDocsCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.BestDocsDeferringCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class DiversifiedOrdinalsSamplerAggregator
extends SamplerAggregator {
    private ValuesSource.Bytes.WithOrdinals.FieldData valuesSource;
    private int maxDocsPerValue;

    public DiversifiedOrdinalsSamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.maxDocsPerValue = maxDocsPerValue;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector();
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector() {
            super(DiversifiedOrdinalsSamplerAggregator.this.shardSize, DiversifiedOrdinalsSamplerAggregator.this.context.bigArrays());
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            return new ValuesDiversifiedTopDocsCollector(size, DiversifiedOrdinalsSamplerAggregator.this.maxDocsPerValue);
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            @Override
            protected NumericDocValues getKeys(LeafReaderContext context) {
                final RandomAccessOrds globalOrds = DiversifiedOrdinalsSamplerAggregator.this.valuesSource.globalOrdinalsValues(context);
                final SortedDocValues singleValues = DocValues.unwrapSingleton(globalOrds);
                if (singleValues != null) {
                    return new NumericDocValues(){

                        @Override
                        public long get(int doc) {
                            return singleValues.getOrd(doc);
                        }
                    };
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int doc) {
                        globalOrds.setDocument(doc);
                        long valuesCount = globalOrds.cardinality();
                        if (valuesCount > 1L) {
                            throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                        }
                        if (valuesCount == 1L) {
                            long result = globalOrds.ordAt(0);
                            return result;
                        }
                        return Long.MIN_VALUE;
                    }
                };
            }
        }
    }
}

