/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.cardinality;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.cardinality.HyperLogLogPlusPlus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class CardinalityAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource, CardinalityAggregatorFactory> {
    private final Long precisionThreshold;

    public CardinalityAggregatorFactory(String name, ValuesSourceConfig<ValuesSource> config, Long precisionThreshold, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.precisionThreshold = precisionThreshold;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new CardinalityAggregator(this.name, null, this.precision(), this.context, parent, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new CardinalityAggregator(this.name, valuesSource, this.precision(), this.context, parent, pipelineAggregators, metaData);
    }

    private int precision() {
        return this.precisionThreshold == null ? 14 : HyperLogLogPlusPlus.precisionFromThreshold(this.precisionThreshold);
    }
}

