/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.values;

import java.lang.reflect.Array;
import java.util.Collection;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.ScorerAware;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.CollectionUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortingBinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.LeafSearchScript;

public class ScriptBytesValues
extends SortingBinaryDocValues
implements ScorerAware {
    private final LeafSearchScript script;

    public ScriptBytesValues(LeafSearchScript script) {
        this.script = script;
    }

    private void set(int i, Object o) {
        if (o == null) {
            this.values[i].clear();
        } else {
            CollectionUtils.ensureNoSelfReferences(o);
            this.values[i].copyChars(o.toString());
        }
    }

    @Override
    public void setDocument(int docId) {
        this.script.setDocument(docId);
        Object value = this.script.run();
        if (value == null) {
            this.count = 0;
        } else if (value.getClass().isArray()) {
            this.count = Array.getLength(value);
            this.grow();
            for (int i = 0; i < this.count; ++i) {
                this.set(i, Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            this.count = coll.size();
            this.grow();
            int i = 0;
            for (Object v : coll) {
                this.set(i++, v);
            }
        } else {
            this.count = 1;
            this.set(0, value);
        }
        this.sort();
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }
}

